/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.owned_identities;

import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.generic_types.list_view.StandardPanelListController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.MainStackManager;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.fx.owned_identities.IdentityListCell;
import io.olvid.windows.messenger.fx.owned_identities.OwnedIdentityCardModel;
import io.olvid.windows.messenger.fx.owned_identities.OwnedIdentityDisplayView;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

@FXMLView(path="fx/owned_identities/owned_identity_card.fxml")
public class OwnedIdentityCardController
extends BaseModalController {
    @FXML
    private VBox card_container;
    @FXML
    private Pane list_container;
    @FXML
    private Pane current_ident_container;
    @FXML
    public Button add_new_ident_button;
    @FXML
    private Region bottom_sep;
    private final LiveDataListener<Optional<OwnedIdentityInfo>> ownedIdentityLiveDataListener = this::onChange;
    private static final int CELL_HEIGHT = 80;
    private final OwnedIdentityCardModel ownedIdentityCardModel = new OwnedIdentityCardModel();
    private final StandardPanelListController<OwnedIdentityInfo> ownedIdentityListViewController;
    private final OwnedIdentityDisplayView ownedIdentityDisplayView = new OwnedIdentityDisplayView(Optional.of(this.ownedIdentityCardModel.getIdsOwnedIdentitySelected()));
    private LiveDataListener<List<OwnedIdentityInfo>> emptyListListener;

    public OwnedIdentityCardController() {
        this.ownedIdentityListViewController = StandardPanelListController.builder().withLiveData(this.ownedIdentityCardModel.getOtherOwnedIdentityInfoListLiveData()).withDataClass(OwnedIdentityInfo.class).withCellFactory((Callback<ListView<OwnedIdentityInfo>, AbstractListCell<OwnedIdentityInfo>>)((Callback)param -> new IdentityListCell(Optional.of(this.ownedIdentityCardModel.getIdsOwnedIdentitySelected())))).withoutBottomMargin().defaultComparator().noFilter().withoutSearch().withSingleSelection().withDisableUnselect(false).withoutButton(this::itemClickedConsumerHandler).build();
        this.ownedIdentityListViewController.getListView().getStyleClass().add((Object)"hoverable-list");
        this.loadFxml();
    }

    private void ownedIdentitiesWithUnreadMessagesListener(Set<Id<OwnedIdentity>> newValue, Set<Id<OwnedIdentity>> oldValue) {
        ViewControllerHelper.smartUIUpdate(() -> {
            this.ownedIdentityCardModel.getIdsOwnedIdentitySelected().removeIf(ind -> !newValue.contains(ind));
            this.ownedIdentityCardModel.getIdsOwnedIdentitySelected().addAll((Collection)newValue);
        });
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        super.initialize(location, resources);
        this.list_container.getChildren().add((Object)this.ownedIdentityListViewController.getLayout());
        this.ownedIdentityListViewController.getListView().setFixedCellSize(80.0);
        this.add_new_ident_button.setOnAction(this::onAddIdentityClicked);
        this.initOwnedIdentity();
        this.bottom_sep.managedProperty().bind((ObservableValue)this.bottom_sep.visibleProperty());
        this.emptyListListener = (newValue, oldValue) -> ViewControllerHelper.smartUIUpdate(() -> this.bottom_sep.visibleProperty().set(!newValue.isEmpty()));
        this.ownedIdentityCardModel.getOtherOwnedIdentityInfoListLiveData().addListener(this.emptyListListener);
    }

    private void initOwnedIdentity() {
        this.current_ident_container.setPadding(new Insets(0.0, 0.0, 16.0, 0.0));
        this.current_ident_container.getChildren().add((Object)this.ownedIdentityDisplayView);
    }

    @Override
    public ModalConfiguration.ModalSize getSize() {
        return ModalConfiguration.ModalSize.MEDIUM;
    }

    @Override
    public Region getLayout() {
        return this.card_container;
    }

    @Override
    public void onLayoutAttached() {
        SelectedOwnedIdentitySingleton.getInstance().addListener(this.ownedIdentityLiveDataListener);
        this.ownedIdentityCardModel.getOtherOwnedIdentityInfoListLiveData().addListener(this.emptyListListener);
        this.ownedIdentityCardModel.getOwnedIdentitiesWithUnreadMessagesLiveData().addListener(this::ownedIdentitiesWithUnreadMessagesListener);
    }

    @Override
    public void onLayoutDetached() {
        SelectedOwnedIdentitySingleton.getInstance().removeListener(this.ownedIdentityLiveDataListener);
        this.ownedIdentityCardModel.getOtherOwnedIdentityInfoListLiveData().removeListener(this.emptyListListener);
        this.ownedIdentityCardModel.getOwnedIdentitiesWithUnreadMessagesLiveData().removeListener(this::ownedIdentitiesWithUnreadMessagesListener);
    }

    private void itemClickedConsumerHandler(OwnedIdentityInfo ownedIdentityInfo, Node node) {
        if (ownedIdentityInfo != null) {
            SelectedOwnedIdentitySingleton.getInstance().updateCurrentIdentity(ownedIdentityInfo);
            AppLogger.d("ownedIdentityListViewController::itemClickedConsumerHandler identity selected: " + ownedIdentityInfo.getCustomDisplayNameOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST_POSITION_COMPANY));
        }
        this.closeModalDelegate.run();
    }

    private void onAddIdentityClicked(Event event) {
        this.closeModalDelegate.run();
        MainStackManager.displayedLayerState.pushState(MainStackManager.DisplayedLayerWrapper.of(MainStackManager.DisplayedLayer.OWNED_IDENTITY_MANAGEMENT));
    }

    private void onChange(Optional<OwnedIdentityInfo> newValue, Optional<OwnedIdentityInfo> oldValue) {
        if (newValue.equals(oldValue)) {
            return;
        }
        if (newValue.isEmpty()) {
            return;
        }
        OwnedIdentityInfo ownedIdentityInfo = newValue.get();
        ViewControllerHelper.smartUIUpdate(() -> this.ownedIdentityDisplayView.setOwnedIdentity(ownedIdentityInfo));
    }
}

