/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.standard_ui.state_builder;

import io.olvid.windows.messenger.fx.modal.standard_ui.button.ButtonBuilder;
import io.olvid.windows.messenger.fx.modal.standard_ui.flow.ModalFlowController;
import io.olvid.windows.messenger.fx.modal.standard_ui.flow.SingleId;
import io.olvid.windows.messenger.fx.modal.standard_ui.state_builder.ModalBuilderInterfaces;
import io.olvid.windows.messenger.fx.modal.standard_ui.state_builder.ModalInnerNodeWrapperController;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;

public class ModalBuilder
implements ModalBuilderInterfaces.Container,
ModalBuilderInterfaces.Titleable,
ModalBuilderInterfaces.Buttonable,
ModalBuilderInterfaces.AllBuilder {
    Label titleLabel = new Label();
    List<ButtonBuilder.ButtonData> bottomButton = new ArrayList<ButtonBuilder.ButtonData>();
    boolean containCancelButton = true;
    Runnable previousStep = null;
    Button floatingButton;
    Node innerNode;
    Runnable close;

    @Override
    public ModalBuilderInterfaces.Titleable withInnerNode(Node innerNode) {
        this.innerNode = innerNode;
        return this;
    }

    @Override
    public ModalBuilderInterfaces.Buttonable withTitle(String title) {
        this.titleLabel.setText(title);
        return this;
    }

    @Override
    public ModalBuilderInterfaces.Buttonable withTitle(StringProperty title) {
        this.titleLabel.textProperty().bind((ObservableValue)title);
        return this;
    }

    @Override
    public ModalBuilderInterfaces.AllBuilder withBottomButton(ButtonBuilder.ButtonData[] buttons) {
        this.bottomButton.addAll(List.of(buttons));
        return this;
    }

    @Override
    public ModalBuilderInterfaces.AllBuilder withoutButton() {
        return this;
    }

    @Override
    public ModalBuilderInterfaces.AllBuilder withFloatingButton(Button button) {
        this.floatingButton = button;
        return this;
    }

    @Override
    public ModalBuilderInterfaces.AllBuilderNoCancel withoutCancelButton() {
        this.containCancelButton = false;
        final ModalBuilder modalBuilder = this;
        return new ModalBuilderInterfaces.AllBuilderNoCancel(){

            @Override
            public <StateId> void addInModalStateFlow(StateId stateId, ModalFlowController<StateId> modalFlowController) {
                modalBuilder.addInModalStateFlow(stateId, modalFlowController);
            }

            @Override
            public <StateId> ModalBuilderInterfaces.FlowAdder<StateId> withPreviousStep(StateId stateId) {
                return modalBuilder.withPreviousStep(stateId);
            }

            @Override
            public <StateId> ModalBuilderInterfaces.FlowAdder<StateId> withPreviousStep(Supplier<StateId> stateIdSupplier) {
                return modalBuilder.withPreviousStep(stateIdSupplier);
            }
        };
    }

    @Override
    public <StateId> ModalBuilderInterfaces.FlowAdder<StateId> withPreviousStep(StateId previousStateId) {
        ModalBuilder modalBuilder = this;
        return (stateId, modalFlowContext) -> {
            modalBuilder.previousStep = () -> modalFlowContext.setState(previousStateId);
            modalBuilder.addInModalStateFlow(stateId, modalFlowContext);
        };
    }

    @Override
    public <StateId> ModalBuilderInterfaces.FlowAdder<StateId> withPreviousStep(Supplier<StateId> stateIdSupplier) {
        ModalBuilder modalBuilder = this;
        return (stateId, modalFlowContext) -> {
            modalBuilder.previousStep = () -> ModalBuilder.lambda$withPreviousStep$2(modalFlowContext, (Supplier)stateIdSupplier);
            modalBuilder.addInModalStateFlow(stateId, modalFlowContext);
        };
    }

    @Override
    public <StateId> void addInModalStateFlow(StateId stateId, ModalFlowController<StateId> modalFlowController) {
        this.close = modalFlowController::close;
        modalFlowController.registerState(stateId, () -> new ModalInnerNodeWrapperController(this));
    }

    private ModalFlowController<SingleId> createSingleStateModalPanel() {
        ModalFlowController<SingleId> singleStateContext = new ModalFlowController<SingleId>();
        this.close = singleStateContext::close;
        singleStateContext.registerState(SingleId.SINGLE_STATE, () -> new ModalInnerNodeWrapperController(this));
        singleStateContext.setState(SingleId.SINGLE_STATE);
        return singleStateContext;
    }

    public void setFloatingButton(Button button) {
        this.floatingButton = button;
    }

    void setContainCancelButtonToFalse() {
        this.containCancelButton = false;
    }

    private static /* synthetic */ void lambda$withPreviousStep$2(ModalFlowController modalFlowContext, Supplier stateIdSupplier) {
        modalFlowContext.setState(stateIdSupplier.get());
    }
}

