/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.standard_ui.button;

import io.olvid.windows.messenger.fx.modal.standard_ui.button.ButtonConfiguration;
import io.olvid.windows.messenger.fx.modal.standard_ui.button.ModalButtonType;
import java.util.function.Consumer;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.MouseEvent;

public class ButtonBuilder
implements ButtonConfiguration {
    Button button = new Button();
    private ModalButtonType type = ModalButtonType.NONE;

    @Override
    public ButtonData build() {
        return new ButtonData(this.button, this.type);
    }

    @Override
    public ButtonConfiguration withAction(EventHandler<MouseEvent> event) {
        this.button.setOnMouseClicked(event);
        return this;
    }

    @Override
    public ButtonConfiguration withGraphic(Node graphic) {
        this.button.setGraphic(graphic);
        return this;
    }

    @Override
    public ButtonConfiguration withCustomInstance(Consumer<Button> buttonStyler) {
        buttonStyler.accept(this.button);
        return this;
    }

    @Override
    public ButtonConfiguration withStandardButtonDefault(ModalButtonType type) {
        this.type = type;
        ModalButtonType.adaptButton(type, this.button);
        return this;
    }

    @Override
    public ButtonConfiguration withDisabledProperty(BooleanBinding disabledProperty) {
        this.button.disableProperty().bind((ObservableValue)disabledProperty);
        return this;
    }

    @Override
    public ButtonConfiguration withText(StringProperty text) {
        this.button.textProperty().bind((ObservableValue)text);
        return this;
    }

    @Override
    public ButtonConfiguration withText(String text) {
        this.button.setText(text);
        return this;
    }

    public record ButtonData(Button button, ModalButtonType type) {
    }
}

