/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.save_mode;

import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public class SaveSuccessModalController
extends BaseModalController {
    private final VBox root = new VBox(12.0);
    private int fileCount;
    private final Button closeButton = new Button();

    public SaveSuccessModalController(int fileCount) {
        this.fileCount = fileCount;
        this.buildUI();
    }

    @Override
    public ModalConfiguration.ModalSize getSize() {
        return ModalConfiguration.ModalSize.SELF_SIZE;
    }

    private void buildUI() {
        this.root.getStyleClass().add((Object)"save-success-modal-root");
        this.root.setMinWidth(400.0);
        this.root.setMaxWidth(500.0);
        this.root.setMaxHeight(100.0);
        this.root.setStyle("-fx-background-color: white;");
        this.root.getStylesheets().add((Object)"fx/design_system/font.css");
        this.root.getStylesheets().add((Object)"fx/modal/modal.css");
        this.root.getStylesheets().add((Object)"fx/modal/save_mode/save_success_modal.css");
        HBox header = new HBox();
        header.setAlignment(Pos.CENTER_LEFT);
        header.setPadding(new Insets(16.0, 16.0, 0.0, 16.0));
        Label title = new Label(ViewControllerHelper.getString("save_success_title"));
        title.getStyleClass().add((Object)"h1-bold");
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.closeButton.getStyleClass().add((Object)"close-button");
        this.closeButton.setOnAction(e -> this.close());
        header.getChildren().addAll((Object[])new Node[]{title, spacer, this.closeButton});
        VBox content = new VBox(16.0);
        content.setPadding(new Insets(16.0));
        content.setAlignment(Pos.CENTER);
        Label successMessage = new Label(String.format(ViewControllerHelper.getString("save_success_message"), this.fileCount));
        successMessage.setWrapText(true);
        successMessage.getStyleClass().add((Object)"body-1");
        HBox buttonBox = new HBox(12.0);
        buttonBox.setAlignment(Pos.CENTER_RIGHT);
        buttonBox.setPadding(new Insets(16.0, 0.0, 0.0, 0.0));
        Button okButton = new Button(ViewControllerHelper.getString("action_ok"));
        okButton.getStyleClass().add((Object)"button-primary");
        okButton.setOnAction(e -> this.close());
        buttonBox.getChildren().add((Object)okButton);
        content.getChildren().addAll((Object[])new Node[]{successMessage, buttonBox});
        this.root.getChildren().addAll((Object[])new Node[]{header, content});
    }

    private void close() {
        this.getCloseModalDelegate().run();
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
        super.onLayoutAttached();
    }

    @Override
    public void onLayoutDetached() {
        this.close();
        super.onLayoutDetached();
    }
}

