/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.save_mode;

import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.RadioAndDescription;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public class SaveModeModalController
extends BaseModalController {
    private final VBox root = new VBox(12.0);
    private SaveMode selectedMode = SaveMode.CANCEL;
    private Consumer<SaveMode> onModeSelected;
    private final ToggleGroup toggleGroup = new ToggleGroup();
    private boolean alreadyClosed = false;

    public SaveModeModalController(Consumer<SaveMode> onModeSelected) {
        this.onModeSelected = onModeSelected;
        this.buildUI();
    }

    @Override
    public ModalConfiguration.ModalSize getSize() {
        return ModalConfiguration.ModalSize.SELF_SIZE;
    }

    private void buildUI() {
        this.root.getStyleClass().add((Object)"save-mode-modal-root");
        this.root.setMinWidth(350.0);
        this.root.setMaxWidth(450.0);
        this.root.setMaxHeight(350.0);
        this.root.setStyle("-fx-background-color: white;");
        this.root.getStylesheets().add((Object)"fx/design_system/font.css");
        this.root.getStylesheets().add((Object)"fx/modal/modal.css");
        this.root.getStylesheets().add((Object)"fx/modal/save_mode/save_mode_modal.css");
        HBox header = new HBox();
        header.setAlignment(Pos.CENTER_LEFT);
        header.setPadding(new Insets(16.0, 16.0, 0.0, 16.0));
        Label title = new Label(ViewControllerHelper.getString("save_attachments_title"));
        title.getStyleClass().add((Object)"h1-bold");
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        Button closeButton = new Button();
        closeButton.getStyleClass().add((Object)"close-button");
        closeButton.setOnAction(e -> {
            this.selectedMode = SaveMode.CANCEL;
            this.close();
        });
        header.getChildren().addAll((Object[])new Node[]{title, spacer, closeButton});
        VBox content = new VBox(16.0);
        content.setPadding(new Insets(16.0));
        Label description = new Label(ViewControllerHelper.getString("save_mode_question"));
        description.getStyleClass().add((Object)"body-2");
        description.setWrapText(true);
        VBox optionsBox = new VBox(12.0);
        optionsBox.setPadding(new Insets(16.0, 0.0, 0.0, 0.0));
        ToggleButton zipButton = this.createToggleOption("save_mode_zip_title", "save_mode_zip_description", SaveMode.ZIP);
        ToggleButton individualButton = this.createToggleOption("save_mode_individual_title", "save_mode_individual_description", SaveMode.INDIVIDUAL);
        optionsBox.getChildren().addAll((Object[])new Node[]{zipButton, individualButton});
        HBox buttonBox = new HBox(8.0);
        buttonBox.setAlignment(Pos.CENTER);
        buttonBox.setPadding(new Insets(8.0, 0.0, 0.0, 0.0));
        Button cancelButton = new Button(ViewControllerHelper.getString("action_cancel"));
        cancelButton.getStyleClass().addAll((Object[])new String[]{"button-secondary", "body-2"});
        cancelButton.setOnAction(e -> {
            this.selectedMode = SaveMode.CANCEL;
            this.close();
        });
        Button confirmButton = new Button(ViewControllerHelper.getString("action_ok"));
        confirmButton.getStyleClass().addAll((Object[])new String[]{"button-primary", "body-1-bold"});
        confirmButton.setOnAction(e -> this.close());
        Region spacer1 = new Region();
        HBox.setHgrow((Node)spacer1, (Priority)Priority.ALWAYS);
        buttonBox.getChildren().addAll((Object[])new Node[]{cancelButton, spacer1, confirmButton});
        content.getChildren().addAll((Object[])new Node[]{description, optionsBox, buttonBox});
        this.root.getChildren().addAll((Object[])new Node[]{header, content});
    }

    private ToggleButton createToggleOption(String titleKey, String descriptionKey, SaveMode mode) {
        ToggleButton toggleButton = new ToggleButton();
        toggleButton.setFocusTraversable(true);
        toggleButton.getStyleClass().addAll((Object[])new String[]{"backup-choice-toggle"});
        toggleButton.setWrapText(true);
        toggleButton.setMaxWidth(Double.MAX_VALUE);
        RadioAndDescription radioAndDescription = new RadioAndDescription();
        radioAndDescription.setMinHeight(80.0);
        radioAndDescription.setTitle(ViewControllerHelper.getString(titleKey));
        radioAndDescription.setSubtitle(ViewControllerHelper.getString(descriptionKey));
        toggleButton.setGraphic((Node)radioAndDescription);
        toggleButton.setToggleGroup(this.toggleGroup);
        toggleButton.setOnMouseClicked(mouseEvent -> {
            this.selectedMode = mode;
        });
        radioAndDescription.radio.selectedProperty().bindBidirectional((Property)toggleButton.selectedProperty());
        return toggleButton;
    }

    private void close() {
        if (this.alreadyClosed) {
            return;
        }
        this.alreadyClosed = true;
        SaveMode modeToSend = this.selectedMode;
        Consumer<SaveMode> callback = this.onModeSelected;
        this.getCloseModalDelegate().run();
        if (callback != null) {
            Platform.runLater(() -> callback.accept(modeToSend));
        }
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
        super.onLayoutAttached();
    }

    @Override
    public void onLayoutDetached() {
        super.onLayoutDetached();
    }

    public static enum SaveMode {
        ZIP,
        INDIVIDUAL,
        CANCEL;

    }
}

