/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.reactions_details;

import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.reaction.AbstractReactionGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.reaction.InboundMessageReaction;
import io.olvid.windows.messenger.database.tables.reaction.OutboundMessageReaction;
import io.olvid.windows.messenger.database.tables.reaction.OwnedMessageReaction;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.fx.modal.reactions_details.ReactionDetailsInfo;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.IdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ReactionsDetailsMediatorLiveData<MessageType extends AbstractUserMessageGenerated<?>, MessageReaction extends AbstractReactionGenerated<MessageReaction>>
extends MediatorLiveData<Map<String, List<ReactionDetailsInfo>>> {
    final AppLogger logger = new AppLogger(ReactionsDetailsMediatorLiveData.class);
    Map<String, List<ReactionDetailsInfo>> currentReactionDetailsPerReaction = new LinkedHashMap<String, List<ReactionDetailsInfo>>();
    List<MessageReaction> currentMessageReactions = new LinkedList<MessageReaction>();
    MapLiveData<Id<MessageType>, List<MessageReaction>> reactionMapLiveData;
    final Id<MessageType> messageId;
    final Map<Id<IdentityRef>, LiveData<Optional<IdentityInfo>>> lazyIdInfoSrc = Collections.synchronizedMap(new LinkedHashMap());
    Map<Id<IdentityRef>, IdentityInfo> currentSendersInfo = Collections.synchronizedMap(new LinkedHashMap());

    public static ReactionsDetailsMediatorLiveData<InboundMessage, InboundMessageReaction> makeInbound(Id<InboundMessage> messageId, MapLiveData<Id<InboundMessage>, List<InboundMessageReaction>> reactionMapLiveData) {
        return new ReactionsDetailsMediatorLiveData<InboundMessage, InboundMessageReaction>(messageId, reactionMapLiveData);
    }

    public static ReactionsDetailsMediatorLiveData<OutboundMessage, OutboundMessageReaction> makeOutbound(Id<OutboundMessage> messageId, MapLiveData<Id<OutboundMessage>, List<OutboundMessageReaction>> reactionMapLiveData) {
        return new ReactionsDetailsMediatorLiveData<OutboundMessage, OutboundMessageReaction>(messageId, reactionMapLiveData);
    }

    public static ReactionsDetailsMediatorLiveData<OwnedMessage, OwnedMessageReaction> makeOwned(Id<OwnedMessage> messageId, MapLiveData<Id<OwnedMessage>, List<OwnedMessageReaction>> reactionMapLiveData) {
        return new ReactionsDetailsMediatorLiveData<OwnedMessage, OwnedMessageReaction>(messageId, reactionMapLiveData);
    }

    public ReactionsDetailsMediatorLiveData(Id<MessageType> messageid, MapLiveData<Id<MessageType>, List<MessageReaction>> reactionMapLiveData) {
        super(new LinkedHashMap());
        this.messageId = messageid;
        this.reactionMapLiveData = reactionMapLiveData;
        this.addSource(messageid, this.reactionMapLiveData, (newValue, oldValue) -> {
            this.logger.trace("ReactionsDetailsMediatorLiveData:: reactionMapLiveData source listener, reaction map size : " + newValue.size());
            if (oldValue != null && newValue.size() == oldValue.size()) {
                boolean same = true;
                for (int i = 0; i < newValue.size(); ++i) {
                    if (((AbstractReactionGenerated)newValue.get(i)).areContentTheSame(oldValue.get(i))) continue;
                    same = false;
                    break;
                }
                if (same) {
                    return;
                }
            }
            ArrayList<Id<IdentityRef>> sendersIdRef = new ArrayList<Id<IdentityRef>>();
            for (AbstractReactionGenerated abstractReactionGenerated : newValue) {
                sendersIdRef.add(abstractReactionGenerated.getSenderId());
            }
            for (Id id : this.lazyIdInfoSrc.keySet()) {
                LiveData<Optional<IdentityInfo>> identityInfoLd = this.lazyIdInfoSrc.get(id);
                this.removeSource(identityInfoLd);
                this.currentSendersInfo.clear();
            }
            this.lazyIdInfoSrc.clear();
            for (Id id : sendersIdRef) {
                LiveData identityRefSource = DbCache.getInstance().identityInfoMapLiveData.of(Optional.empty(), id);
                if (!this.currentSendersInfo.containsKey(id)) {
                    this.addSource(identityRefSource, (newInfo, oldInfo) -> newInfo.ifPresent(identityInfo -> {
                        this.currentSendersInfo.put(idRef, (IdentityInfo)identityInfo);
                        this.consolidate();
                    }));
                }
                this.lazyIdInfoSrc.put(id, identityRefSource);
            }
            this.currentReactionDetailsPerReaction.clear();
            if (!DiffUtils.areContentTheSame(this.currentMessageReactions, newValue)) {
                this.currentMessageReactions = newValue;
                this.consolidate();
            }
        });
    }

    private synchronized void consolidate() {
        this.logger.trace("ReactionsDetailsMediatorLiveData::consolidate call");
        for (AbstractReactionGenerated messageReaction : this.currentMessageReactions) {
            IdentityInfo info = this.currentSendersInfo.get(messageReaction.getSenderId());
            if (info != null) continue;
            return;
        }
        LinkedHashMap<String, List<ReactionDetailsInfo>> copytmp = new LinkedHashMap<String, List<ReactionDetailsInfo>>(this.currentReactionDetailsPerReaction);
        Optional<Object> myReaction = Optional.empty();
        for (AbstractReactionGenerated messageReaction : this.currentMessageReactions) {
            String emoji = messageReaction.getEmoji().orElse("?");
            long timestamp = messageReaction.getTimestamp();
            ArrayList<ReactionDetailsInfo> knownReactions = copytmp.get(emoji) == null ? new ArrayList<ReactionDetailsInfo>() : new ArrayList((Collection)copytmp.get(emoji));
            IdentityInfo info = this.currentSendersInfo.get(messageReaction.getSenderId());
            ReactionDetailsInfo newReaction = ReactionDetailsInfo.of(info, emoji, timestamp);
            boolean isMe = info.isMe();
            int index = knownReactions.indexOf(newReaction);
            if (index == -1) {
                if (isMe) {
                    knownReactions.addFirst(newReaction);
                    myReaction = Optional.of(emoji);
                } else if (info.getContactInfo().isPresent()) {
                    knownReactions.add(newReaction);
                }
            } else {
                ReactionDetailsInfo known = (ReactionDetailsInfo)knownReactions.get(index);
                if (!newReaction.identityInfo().areContentTheSame(known)) {
                    knownReactions.set(index, newReaction);
                }
            }
            copytmp.put(emoji, knownReactions);
        }
        Optional myReactionAsFinal = myReaction;
        ArrayList entryList = new ArrayList(copytmp.entrySet());
        entryList.sort(Comparator.comparingInt(o -> {
            if (myReactionAsFinal.isPresent() && ((String)o.getKey()).equals(myReactionAsFinal.get())) {
                return -2147483647;
            }
            return -((List)o.getValue()).size();
        }));
        LinkedHashMap<String, List> toRet = new LinkedHashMap<String, List>();
        for (Map.Entry entry : entryList) {
            toRet.put((String)entry.getKey(), (List)entry.getValue());
        }
        this.postValue(toRet);
    }
}

