/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.reactions_details;

import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.reaction.AbstractReactionGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.reaction.InboundMessageReaction;
import io.olvid.windows.messenger.database.tables.reaction.OutboundMessageReaction;
import io.olvid.windows.messenger.database.tables.reaction.OwnedMessageReaction;
import io.olvid.windows.messenger.fx.discussions.discussion_view.DiscussionViewModel;
import io.olvid.windows.messenger.fx.modal.reactions_details.AbstractReactionDetailsModalModel;
import io.olvid.windows.messenger.fx.modal.reactions_details.ReactionDetailsInfo;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import java.util.List;
import java.util.Map;

public abstract class AbstractReactionsDetailsInfoController<MessageType extends AbstractUserMessageGenerated<MessageType>, Reaction extends AbstractReactionGenerated<Reaction>> {
    protected AbstractReactionDetailsModalModel<MessageType, Reaction> model;
    protected final LiveDataListener<Map<String, List<ReactionDetailsInfo>>> reactionsListener;

    public AbstractReactionsDetailsInfoController(LiveDataListener<Map<String, List<ReactionDetailsInfo>>> reactionsListener) {
        this.reactionsListener = reactionsListener;
    }

    public abstract void subscribe();

    public void unsubscribe() {
        this.model.unplug();
    }

    public static class OwnedReactionsDetailsInfoController
    extends AbstractReactionsDetailsInfoController<OwnedMessage, OwnedMessageReaction> {
        public OwnedReactionsDetailsInfoController(Id<OwnedMessage> messageId, DiscussionViewModel viewModel, LiveDataListener<Map<String, List<ReactionDetailsInfo>>> listener) {
            super(listener);
            this.model = new AbstractReactionDetailsModalModel.OwnedMessageReactionDetailModel(messageId, viewModel);
        }

        @Override
        public void subscribe() {
            this.model.reactionReactionsDetailsMLD.addListener(this.reactionsListener);
        }
    }

    public static class OutboundReactionsDetailsInfoController
    extends AbstractReactionsDetailsInfoController<OutboundMessage, OutboundMessageReaction> {
        public OutboundReactionsDetailsInfoController(Id<OutboundMessage> messageId, DiscussionViewModel viewModel, LiveDataListener<Map<String, List<ReactionDetailsInfo>>> listener) {
            super(listener);
            this.model = new AbstractReactionDetailsModalModel.OutboundMessageReactionDetailsModel(messageId, viewModel);
        }

        @Override
        public void subscribe() {
            this.model.reactionReactionsDetailsMLD.addListener(this.reactionsListener);
        }
    }

    public static class InboundReactionsDetailsInfoController
    extends AbstractReactionsDetailsInfoController<InboundMessage, InboundMessageReaction> {
        public InboundReactionsDetailsInfoController(Id<InboundMessage> messageId, DiscussionViewModel viewModel, LiveDataListener<Map<String, List<ReactionDetailsInfo>>> listener) {
            super(listener);
            this.model = new AbstractReactionDetailsModalModel.InboundMessageReactionDetailsModel(messageId, viewModel);
        }

        @Override
        public void subscribe() {
            this.model.reactionReactionsDetailsMLD.addListener(this.reactionsListener);
        }
    }
}

