/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.reactions_details;

import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.reaction.AbstractReactionGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.reaction.InboundMessageReaction;
import io.olvid.windows.messenger.database.tables.reaction.OutboundMessageReaction;
import io.olvid.windows.messenger.database.tables.reaction.OwnedMessageReaction;
import io.olvid.windows.messenger.fx.discussions.discussion_view.DiscussionViewModel;
import io.olvid.windows.messenger.fx.modal.reactions_details.ReactionDetailsInfo;
import io.olvid.windows.messenger.fx.modal.reactions_details.ReactionsDetailsMediatorLiveData;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import java.util.List;
import java.util.Optional;

public abstract class AbstractReactionDetailsModalModel<Message extends AbstractUserMessageGenerated<Message>, MessageReaction extends AbstractReactionGenerated<MessageReaction>> {
    protected final Id<Message> messageId;
    protected ReactionsDetailsMediatorLiveData<Message, MessageReaction> reactionReactionsDetailsMLD;
    private Optional<LiveData<List<ReactionDetailsInfo>>> reactionsLivedataList = Optional.empty();

    public AbstractReactionDetailsModalModel(Id<Message> msgId) {
        this.messageId = msgId;
    }

    public LiveData<List<ReactionDetailsInfo>> getReactionsEntryValue(String emojiAsString) {
        this.reactionsLivedataList = Optional.of(LiveDataFactory.switchMapWithCustomSourceCompare(this.reactionReactionsDetailsMLD, stringListMap -> {
            Optional<List> reactionDetailsInfosOpt = Optional.ofNullable((List)stringListMap.get(emojiAsString));
            if (reactionDetailsInfosOpt.isPresent()) {
                return new MutableLiveData<List>(reactionDetailsInfosOpt.get());
            }
            return new MutableLiveData(List.of());
        }, (stringListMap, stringListMap2) -> false));
        return this.reactionsLivedataList.get();
    }

    public void unplug() {
        this.reactionReactionsDetailsMLD.removeAllListeners();
        if (this.reactionsLivedataList.isPresent()) {
            this.reactionsLivedataList.ifPresent(LiveData::removeAllListeners);
        }
    }

    public static class OwnedMessageReactionDetailModel
    extends AbstractReactionDetailsModalModel<OwnedMessage, OwnedMessageReaction> {
        public OwnedMessageReactionDetailModel(Id<OwnedMessage> messageId, DiscussionViewModel model) {
            super(messageId);
            this.reactionReactionsDetailsMLD = ReactionsDetailsMediatorLiveData.makeOwned(messageId, model.getReactionsLiveDataPerOwnedMessage());
        }
    }

    public static class OutboundMessageReactionDetailsModel
    extends AbstractReactionDetailsModalModel<OutboundMessage, OutboundMessageReaction> {
        public OutboundMessageReactionDetailsModel(Id<OutboundMessage> messageId, DiscussionViewModel model) {
            super(messageId);
            this.reactionReactionsDetailsMLD = ReactionsDetailsMediatorLiveData.makeOutbound(messageId, model.getReactionsLiveDataPerOutboundMessage());
        }
    }

    public static class InboundMessageReactionDetailsModel
    extends AbstractReactionDetailsModalModel<InboundMessage, InboundMessageReaction> {
        public InboundMessageReactionDetailsModel(Id<InboundMessage> messageId, DiscussionViewModel model) {
            super(messageId);
            this.reactionReactionsDetailsMLD = ReactionsDetailsMediatorLiveData.makeInbound(messageId, model.getReactionsLiveDataPerInboundMessage());
        }
    }
}

