/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.message_infos.view.messages;

import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.custom_components.bubbles.IdentityBubble;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.InfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.messages.AbstractMessageInfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.model.InfoData;
import io.olvid.windows.messenger.fx.modal.message_infos.view.AbstractInfoDataListCell;
import io.olvid.windows.messenger.fx.modal.message_infos.view.VBoxList;
import io.olvid.windows.messenger.fx.modal.message_infos.view.messages.PreviousRecipientInfoListCell;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.IdentityInfo;
import io.olvid.windows.messenger.misc.state_pattern.StackContext;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;

public final class RecipientInfoListCell
extends AbstractInfoDataListCell<InfoData.RecipientInfo> {
    private final IdentityBubble bubble = new IdentityBubble(20.0);
    private final VBoxList<InfoData.PreviousRecipientInfo, PreviousRecipientInfoListCell> previousInfoList;
    private final BooleanProperty showPreviousInfos = new SimpleBooleanProperty(false);

    public RecipientInfoListCell(StackContext<InfoController.InfoState> stackContext) {
        super(stackContext, true);
        this.label.getStyleClass().add((Object)"h2");
        this.mainHBox.setPadding(new Insets(12.0));
        this.label.setMinHeight(40.0);
        this.mainHBox.getChildren().add(0, (Object)this.bubble);
        this.previousInfoList = AbstractMessageInfoController.makeVBoxList((Pane)this, PreviousRecipientInfoListCell.class, () -> new PreviousRecipientInfoListCell(stackContext), Optional.empty());
        this.previousInfoList.visibleProperty().bind((ObservableValue)this.showPreviousInfos.and((ObservableBooleanValue)Bindings.isEmpty((ObservableList)this.previousInfoList.getChildren()).not()));
        this.previousInfoList.paddingProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> new Insets(0.0, 0.0, 16.0, this.label.getLayoutX() - HBox.getMargin((Node)this.label).getLeft()), (Observable[])new Observable[]{this.label.layoutXProperty()}));
        this.setOnMouseClicked(e -> this.showPreviousInfos.set(!this.showPreviousInfos.get()));
    }

    @Override
    public void update(InfoData.RecipientInfo item) {
        super.update(item);
        this.updateWithIdentityInfo(Optional.empty());
        Id<IdentityRef> identityRefId = item.recipientId();
        this.updateIdentityRefListener(Optional.of(identityRefId));
        this.previousInfoList.update(item.previousRecipientInfos());
    }

    @Override
    protected void updateWithIdentityInfo(Optional<IdentityInfo> identityInfo) {
        if (identityInfo.isEmpty()) {
            this.label.setText(null);
            BubbleUtils.resetBubbleData(this.bubble);
        } else if (identityInfo.get().isMe()) {
            this.label.setText(ViewControllerHelper.getString("you"));
            BubbleUtils.setBubbleData(identityInfo.get().getOwnedIdentityInfo(), this.bubble);
        } else if (identityInfo.get().getContactInfo().isPresent()) {
            ContactInfo contactInfo = identityInfo.get().getContactInfo().get();
            this.label.setText(contactInfo.getCustomOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST));
            BubbleUtils.setBubbleData(contactInfo, this.bubble);
        } else {
            this.label.setText(null);
            BubbleUtils.resetBubbleData(this.bubble);
        }
    }
}

