/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.message_infos.view.messages;

import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.custom_components.bubbles.IdentityBubble;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.InfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.model.InfoData;
import io.olvid.windows.messenger.fx.modal.message_infos.view.AbstractInfoDataListCell;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.PendingGroupMemberInfo;
import io.olvid.windows.messenger.livedata.mediator.ContactInfoLiveData;
import io.olvid.windows.messenger.misc.state_pattern.StackContext;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.util.Duration;

public abstract class AbstractNotSentYetInfoListCell<T extends InfoData>
extends AbstractInfoDataListCell<T> {
    protected final IdentityBubble bubble = new IdentityBubble(20.0);
    protected final Tooltip tooltip = new Tooltip();

    public AbstractNotSentYetInfoListCell(StackContext<InfoController.InfoState> stackContext) {
        super(stackContext, true);
        this.label.getStyleClass().add((Object)"h2");
        this.mainHBox.setPadding(new Insets(12.0));
        this.label.setMinHeight(40.0);
        this.mainHBox.getChildren().addFirst((Object)this.bubble);
        SvgSizeable infoInfo = new SvgSizeable();
        infoInfo.getStyleClass().addAll((Object[])new String[]{"svg-info", "icon-medium", "icon-grey"});
        Button infoButton = new Button();
        infoButton.getStyleClass().add((Object)"empty-button-no-hover");
        infoButton.setGraphic((Node)infoInfo);
        this.tooltip.setShowDelay(Duration.ZERO);
        infoButton.setTooltip(this.tooltip);
        this.mainHBox.getChildren().add((Object)infoButton);
    }

    @Override
    public void update(T item) {
    }

    @Override
    protected void updateWithContactInfo(ContactInfoLiveData.ContactInfoState contactInfoOpt) {
        ContactInfoLiveData.ContactInfoState contactInfoState = contactInfoOpt;
        Objects.requireNonNull(contactInfoState);
        ContactInfoLiveData.ContactInfoState contactInfoState2 = contactInfoState;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ContactInfoLiveData.ContactInfoState.Computing.class, ContactInfoLiveData.ContactInfoState.Deleted.class, ContactInfoLiveData.ContactInfoState.Present.class}, (Object)contactInfoState2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ContactInfoLiveData.ContactInfoState.Computing computing = (ContactInfoLiveData.ContactInfoState.Computing)contactInfoState2;
                this.label.setText(null);
                BubbleUtils.resetBubbleData(this.bubble);
                this.tooltip.setText(null);
                break;
            }
            case 1: {
                ContactInfoLiveData.ContactInfoState.Deleted deleted = (ContactInfoLiveData.ContactInfoState.Deleted)contactInfoState2;
                this.label.setText(ViewControllerHelper.getString("deleted_contact"));
                BubbleUtils.resetBubbleData(this.bubble);
                this.tooltip.setText(null);
                break;
            }
            case 2: {
                ContactInfoLiveData.ContactInfoState.Present present = (ContactInfoLiveData.ContactInfoState.Present)contactInfoState2;
                ContactInfo contactInfo = present.info();
                String contactName = contactInfo.getCustomOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST);
                this.label.setText(contactName);
                BubbleUtils.setBubbleData(contactInfo, this.bubble);
                this.tooltip.setText(ViewControllerHelper.getString("tooltip_not_send_yet_canal", contactName));
            }
        }
    }

    @Override
    protected void updateWithPendingMemberInfo(Optional<PendingGroupMemberInfo> pendingGroupMemberInfoOpt) {
        if (pendingGroupMemberInfoOpt.isPresent()) {
            PendingGroupMemberInfo pendingGroupMemberInfo = pendingGroupMemberInfoOpt.get();
            String pendingMemberName = pendingGroupMemberInfo.detailsInfo().getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST);
            this.label.setText(pendingMemberName);
            BubbleUtils.setBubbleData(pendingGroupMemberInfo, this.bubble);
            this.tooltip.setText(ViewControllerHelper.getString("tooltip_not_send_yet_pending_message", pendingMemberName));
        } else {
            this.label.setText(null);
            BubbleUtils.resetBubbleData(this.bubble);
            this.tooltip.setText(null);
        }
    }
}

