/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.message_infos.view;

import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import java.util.List;
import java.util.function.Function;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.VBox;

public class VBoxList<T extends Diffable, N extends Node>
extends VBox
implements LiveDataListener<List<T>> {
    private final Class<N> clazz;
    private final Function<T, N> makeNode;
    private LiveData<List<T>> currentSource;

    public VBoxList(Class<N> clazz, Function<T, N> makeNode) {
        this.clazz = clazz;
        this.makeNode = makeNode;
    }

    public void unplug() {
        if (this.currentSource == null) {
            return;
        }
        this.currentSource.removeListener(this);
        this.currentSource = null;
    }

    public void plug(LiveData<List<T>> liveData) {
        if (this.currentSource == liveData) {
            return;
        }
        this.unplug();
        liveData.addListener(this);
        this.currentSource = liveData;
    }

    public void update(List<T> values) {
        this.unplug();
        this.onChange(values, List.of());
    }

    @Override
    public void onChange(List<T> newValue, List<T> oldValue) {
        ViewControllerHelper.smartUIUpdate(() -> DiffUtils.applyChanges(newValue, this.clazz, (ObservableList<Node>)this.getChildren(), this.makeNode));
    }
}

