/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.message_infos.view;

import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.InfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.model.InfoData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.IdentityInfo;
import io.olvid.windows.messenger.livedata.info.PendingGroupMemberInfo;
import io.olvid.windows.messenger.livedata.mediator.ContactInfoLiveData;
import io.olvid.windows.messenger.misc.DateUtils;
import io.olvid.windows.messenger.misc.state_pattern.StackContext;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public abstract class AbstractInfoDataListCell<Data extends InfoData>
extends VBox
implements DiffUtils.NodeController<Data> {
    protected final Label label = new Label();
    protected final Label date = new Label();
    protected final Region separator = new Region();
    protected final HBox mainHBox;
    protected final SvgSizeable chevron;
    protected Data current = null;
    private Optional<Id<IdentityRef>> currentIdentityRef = Optional.empty();
    private Optional<Id<PendingGroupMember>> currentPendingRef = Optional.empty();
    private Optional<Id<ContactRef>> currentContactRef = Optional.empty();
    private final LiveDataListener<Optional<IdentityInfo>> identityChangeListener = this::identityChangeListener;
    private final LiveDataListener<ContactInfoLiveData.ContactInfoState> contactChangeListener = this::contactChangeListener;
    private final LiveDataListener<Optional<PendingGroupMemberInfo>> pendingGroupMemberInfoListener = this::pendingGroupMemberInfoListener;

    protected AbstractInfoDataListCell(StackContext<InfoController.InfoState> stackContext, boolean showSeparator) {
        if (showSeparator) {
            this.attachSeparatorAbove();
        }
        this.mainHBox = new HBox();
        this.getChildren().add((Object)this.mainHBox);
        this.date.getStyleClass().add((Object)"body-2");
        this.mainHBox.setAlignment(Pos.CENTER_LEFT);
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        HBox.setMargin((Node)this.label, (Insets)new Insets(0.0, 0.0, 0.0, 12.0));
        this.mainHBox.getChildren().addAll((Object[])new Node[]{this.label, spacer, this.date});
        this.setOnMouseClicked(e -> {
            if (this.current != null && this.current.getNextState().isPresent()) {
                stackContext.pushState(this.current.getNextState().get());
            }
        });
        this.chevron = new SvgSizeable();
        this.chevron.getStyleClass().addAll((Object[])new String[]{"svg-chevron", "icon-medium"});
        this.mainHBox.getChildren().add((Object)this.chevron);
        this.chevron.managedProperty().bind((ObservableValue)this.chevron.visibleProperty());
        this.chevron.setVisible(false);
    }

    @Override
    public void update(Data item) {
        this.current = item;
        Optional<Long> timestamp = item.getTimestamp();
        if (timestamp.isPresent()) {
            LocalDateTime localDateTime = DateUtils.of(timestamp.get());
            this.date.setText(DateUtils.formatRelativeDateAndTime(localDateTime));
        } else {
            this.date.setText(null);
        }
    }

    @Override
    public Data getValue() {
        return this.current;
    }

    @Override
    public void dispose() {
        this.current = null;
        this.updateIdentityRefListener(Optional.empty());
        this.updateContactRefListener(Optional.empty());
    }

    @Override
    public Node getNode() {
        return this;
    }

    protected final void updateIdentityRefListener(Optional<Id<IdentityRef>> refId) {
        if (this.currentIdentityRef.isPresent() && !this.currentIdentityRef.equals(refId)) {
            DbCache.getInstance().identityInfoMapLiveData.removeListener(this.currentIdentityRef.get(), this.identityChangeListener);
            this.currentIdentityRef = Optional.empty();
        }
        if (this.currentIdentityRef.isEmpty() && refId.isPresent()) {
            DbCache.getInstance().identityInfoMapLiveData.addListener(refId.get(), this.identityChangeListener);
            this.currentIdentityRef = refId;
        }
    }

    protected final void updateContactRefListener(Optional<Id<ContactRef>> refId) {
        if (this.currentContactRef.isPresent() && !this.currentContactRef.equals(refId)) {
            DbCache.getInstance().contactRefInfoMapLiveData.removeListener(this.currentContactRef.get(), this.contactChangeListener);
            this.currentIdentityRef = Optional.empty();
        }
        if (this.currentContactRef.isEmpty() && refId.isPresent()) {
            DbCache.getInstance().contactRefInfoMapLiveData.addListener(refId.get(), this.contactChangeListener);
            this.currentContactRef = refId;
        }
    }

    protected final void updatePendingMemberListener(Optional<Id<PendingGroupMember>> refId) {
        if (this.currentPendingRef.isPresent() && !this.currentPendingRef.equals(refId)) {
            DbCache.getInstance().pendingGroupMemberInfoLiveData.removeListener(this.currentPendingRef.get(), this.pendingGroupMemberInfoListener);
            this.currentPendingRef = Optional.empty();
        }
        if (this.currentPendingRef.isEmpty() && refId.isPresent()) {
            DbCache.getInstance().pendingGroupMemberInfoLiveData.addListener(refId.get(), this.pendingGroupMemberInfoListener);
            this.currentPendingRef = refId;
        }
    }

    protected void updateWithContactInfo(ContactInfoLiveData.ContactInfoState contactInfo) {
    }

    protected void updateWithIdentityInfo(Optional<IdentityInfo> identityInfo) {
    }

    protected void updateWithPendingMemberInfo(Optional<PendingGroupMemberInfo> identityInfo) {
    }

    private void attachSeparatorAbove() {
        this.separator.managedProperty().bind((ObservableValue)this.separator.visibleProperty());
        this.separator.getStyleClass().add((Object)"sep-light-grey");
        this.getChildren().add((Object)this.separator);
        VBox.setMargin((Node)this.separator, (Insets)new Insets(0.0, 12.0, 0.0, 12.0));
        this.parentProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                return;
            }
            newValue.getChildrenUnmodifiable().addListener(c -> {
                ObservableList list = c.getList();
                if (list.isEmpty()) {
                    return;
                }
                boolean isFirst = list.get(0) == this;
                this.separator.setVisible(!isFirst);
            });
        });
    }

    private void identityChangeListener(Optional<IdentityInfo> newValue, Optional<IdentityInfo> oldValue) {
        if (Objects.equals(newValue, oldValue)) {
            return;
        }
        ViewControllerHelper.smartUIUpdate(() -> this.updateWithIdentityInfo(newValue));
    }

    private void contactChangeListener(ContactInfoLiveData.ContactInfoState newValue, ContactInfoLiveData.ContactInfoState oldValue) {
        if (Objects.equals(newValue, oldValue)) {
            return;
        }
        ViewControllerHelper.smartUIUpdate(() -> this.updateWithContactInfo(newValue));
    }

    private void pendingGroupMemberInfoListener(Optional<PendingGroupMemberInfo> newValue, Optional<PendingGroupMemberInfo> oldValue) {
        if (Objects.equals(newValue, oldValue)) {
            return;
        }
        ViewControllerHelper.smartUIUpdate(() -> this.updateWithPendingMemberInfo(newValue));
    }
}

