/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.message_infos.model;

import io.olvid.windows.messenger.database.tables.attachment.AttachmentRecipientInfo;
import io.olvid.windows.messenger.database.tables.message.MessageRecipientInfo;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.MessageStatusView;

public enum RecipientStatus {
    CANCELLED,
    UPLOADING,
    PROCESSING,
    SENT,
    DELIVERED,
    READ;


    public static RecipientStatus of(MessageRecipientInfo.Status status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case MessageRecipientInfo.Status.PROCESSING -> PROCESSING;
            case MessageRecipientInfo.Status.SENT -> SENT;
            case MessageRecipientInfo.Status.DELIVERED -> DELIVERED;
            case MessageRecipientInfo.Status.READ -> READ;
        };
    }

    public static RecipientStatus of(AttachmentRecipientInfo.Status status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case AttachmentRecipientInfo.Status.CANCELLED -> CANCELLED;
            case AttachmentRecipientInfo.Status.UPLOADING -> UPLOADING;
            case AttachmentRecipientInfo.Status.SENT -> SENT;
            case AttachmentRecipientInfo.Status.DELIVERED -> DELIVERED;
            case AttachmentRecipientInfo.Status.READ -> READ;
        };
    }

    public String getLabel() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ViewControllerHelper.getString("label_metadata_kind_cancelled");
            case 1 -> ViewControllerHelper.getString("label_metadata_kind_uploading");
            case 2 -> ViewControllerHelper.getString("label_metadata_kind_sent");
            case 3 -> ViewControllerHelper.getString("label_metadata_kind_uploaded");
            case 4 -> ViewControllerHelper.getString("label_metadata_kind_delivered");
            case 5 -> ViewControllerHelper.getString("label_metadata_kind_read");
        };
    }

    public MessageStatusView.Icon getIcon() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> MessageStatusView.Icon.NONE;
            case 1, 2 -> MessageStatusView.Icon.PROCESSING;
            case 3 -> MessageStatusView.Icon.SENT;
            case 4 -> MessageStatusView.Icon.DELIVERED_TO_ONE;
            case 5 -> MessageStatusView.Icon.READ_BY_ONE;
        };
    }
}

