/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.message_infos.model;

import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.MessageStatusView;
import java.util.Optional;

public enum MetadataKind {
    RECEIVED,
    READ,
    UPLOADED,
    SENT,
    UNDELIVERED,
    WIPED,
    EDITED,
    REMOTE_DELETED,
    LOCATION_SHARING_LATEST_UPDATE,
    LOCATION_SHARING_END;


    public String getLabel(Optional<String> deleterInfo) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ViewControllerHelper.getString("label_metadata_kind_delivered");
            case 1 -> ViewControllerHelper.getString("label_metadata_kind_read");
            case 2 -> ViewControllerHelper.getString("label_metadata_kind_uploaded");
            case 4 -> ViewControllerHelper.getString("label_metadata_kind_undelivered");
            case 5 -> ViewControllerHelper.getString("label_metadata_kind_wiped");
            case 6 -> ViewControllerHelper.getString("label_metadata_kind_edited");
            case 3 -> ViewControllerHelper.getString("label_metadata_kind_sent");
            case 7 -> {
                if (deleterInfo.isEmpty()) {
                    yield ViewControllerHelper.getString("label_metadata_kind_remote_deleted");
                }
                yield ViewControllerHelper.getString("label_metadata_kind_remote_deleted_by", deleterInfo.get());
            }
            case 8 -> ViewControllerHelper.getString("label_metadata_kind_location_sharing_latest_update");
            case 9 -> ViewControllerHelper.getString("label_metadata_kind_location_sharing_end");
        };
    }

    public MessageStatusView.Icon getIcon() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> MessageStatusView.Icon.DELIVERED_TO_ONE;
            case 1 -> MessageStatusView.Icon.READ_BY_ONE;
            case 2 -> MessageStatusView.Icon.SENT;
            case 3 -> MessageStatusView.Icon.PROCESSING;
            case 4 -> MessageStatusView.Icon.NONE;
            case 5 -> MessageStatusView.Icon.WIPED;
            case 6 -> MessageStatusView.Icon.EDITED;
            case 7 -> MessageStatusView.Icon.DELETED;
            case 8 -> MessageStatusView.Icon.NONE;
            case 9 -> MessageStatusView.Icon.NONE;
        };
    }
}

