/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.message_infos.controller.attachments;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.attachment.AttachmentRecipientInfo;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.message.MessageRecipientInfo;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.MessageStatusView;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.AbstractInfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.InfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.messages.AbstractMessageInfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.model.InfoData;
import io.olvid.windows.messenger.fx.modal.message_infos.model.RecipientStatus;
import io.olvid.windows.messenger.fx.modal.message_infos.view.VBoxList;
import io.olvid.windows.messenger.fx.modal.message_infos.view.messages.MetadataListCell;
import io.olvid.windows.messenger.fx.modal.message_infos.view.messages.RecipientInfoListCell;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.state_pattern.StackContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;

public class OutboundAttachmentInfoController
extends AbstractInfoController<OutboundMessage> {
    private final LiveData<OutboundAttachment> attachmentLiveData;
    private final LiveData<List<AttachmentRecipientInfo>> attachementRecipientInfoLiveData;
    private final LiveDataListener<OutboundAttachment> attachmentChangeListener = this::attachmentChangeListener;
    protected final int recipientsCount;
    protected final boolean hasOwnedDevice;

    public OutboundAttachmentInfoController(StackContext<InfoController.InfoState> stackContext, Id<OutboundAttachment> attachmentId, Id<OutboundMessage> messageId, int recipientsCount, boolean hasOwnedDevice) {
        super(stackContext, messageId, OutboundMessage.class, DbManager.getInstance().getOutboundMessageDao());
        this.recipientsCount = recipientsCount;
        this.hasOwnedDevice = hasOwnedDevice;
        this.attachmentLiveData = LiveDataFactory.buildDbLiveDataItem(OutboundAttachment.class, () -> (OutboundAttachment)DbManager.getInstance().getOutboundAttachmentDao().get(attachmentId));
        this.attachementRecipientInfoLiveData = LiveDataFactory.buildDbLiveDataList(AttachmentRecipientInfo.class, () -> DbManager.getInstance().getAttachmentRecipientInfoDao().getAllForAttachment(attachmentId));
        if (this.showIndividualRecipientStatus()) {
            AttachmentRecipientInfo.Status[] statuses = AttachmentRecipientInfo.Status.values();
            for (int i = statuses.length - 1; 0 <= i; --i) {
                AttachmentRecipientInfo.Status status = statuses[i];
                RecipientStatus recipientStatus = RecipientStatus.of(status);
                this.buildAttachmentRecipientInfoListView(recipientStatus.getLabel(), this.buildAttachmentRecipientInfoLiveData(status), recipientStatus.getIcon());
            }
            this.buildPendingMemberInfoListView(ViewControllerHelper.getString("text_not_sent_yet_pending"), OutboundAttachmentInfoController.buildPendingMemberLiveData(messageId), Optional.empty());
            this.buildNotSentYetInfoListView(ViewControllerHelper.getString("text_not_sent_yet_canal"), OutboundAttachmentInfoController.buildPendingLiveData(messageId), Optional.empty());
        } else {
            this.buildAllAttachmentRecipientInfoListView();
        }
        this.attachmentLiveData.addListener(this.attachmentChangeListener);
    }

    protected boolean showIndividualRecipientStatus() {
        return this.recipientsCount > 1;
    }

    @Override
    public void onLayoutDetached() {
        this.attachmentLiveData.removeListener(this.attachmentChangeListener);
    }

    private void attachmentChangeListener(OutboundAttachment newValue, OutboundAttachment oldValue) {
        ViewControllerHelper.smartUIUpdate(() -> {
            if (newValue == null) {
                this.stackContext.goToPreviousState();
                return;
            }
            this.title.setText(newValue.getFilename());
        });
    }

    private List<InfoData.PreviousRecipientInfo> buildPreviousInfo(AttachmentRecipientInfo info, AttachmentRecipientInfo.Status status) {
        ArrayList<InfoData.PreviousRecipientInfo> previous = new ArrayList<InfoData.PreviousRecipientInfo>();
        for (AttachmentRecipientInfo.Status s : AttachmentRecipientInfo.Status.values()) {
            Optional<Long> timestamp;
            if (status.isLessOrEqualTo(s) || (timestamp = info.getTimestamp(s)).isEmpty()) continue;
            previous.add(new InfoData.PreviousRecipientInfo(RecipientStatus.of(s), timestamp.get()));
        }
        return previous;
    }

    private LiveData<List<InfoData.RecipientInfo>> buildAttachmentRecipientInfoLiveData(AttachmentRecipientInfo.Status status) {
        return LiveDataFactory.map(this.attachementRecipientInfoLiveData, List.of(), infos -> {
            ArrayList<InfoData.RecipientInfo> result = new ArrayList<InfoData.RecipientInfo>();
            for (AttachmentRecipientInfo info : infos) {
                if (info.status() != status) continue;
                Id<MessageRecipientInfo> messageRecipientInfoId = info.getMessageRecipientInfoId();
                MessageRecipientInfo messageRecipientInfo = DbManager.getInstance().getMessageRecipientInfoDao().get(messageRecipientInfoId);
                Optional<Long> timestamp = info.getTimestamp(info.status());
                List<InfoData.PreviousRecipientInfo> previousInfos = this.buildPreviousInfo(info, status);
                result.add(new InfoData.RecipientInfo(RecipientStatus.of(info.status()), timestamp, messageRecipientInfo.getRecipientRefId(), previousInfos));
            }
            Collections.sort(result);
            return result;
        });
    }

    private void buildAttachmentRecipientInfoListView(String title, LiveData<List<InfoData.RecipientInfo>> messageInfoLiveData, MessageStatusView.Icon icon) {
        VBoxList vBoxList = AbstractMessageInfoController.makeVBoxList((Pane)this.mainVBox, RecipientInfoListCell.class, () -> new RecipientInfoListCell(this.stackContext), Optional.empty());
        OutboundAttachmentInfoController.attachTitle((Pane)this.mainVBox, title, Optional.of(icon), vBoxList);
        vBoxList.plug(messageInfoLiveData);
        vBoxList.visibleProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)vBoxList.getChildren()).not());
    }

    private void buildAllAttachmentRecipientInfoListView() {
        LiveData infoLiveData = LiveDataFactory.map(this.attachementRecipientInfoLiveData, List.of(), infos -> {
            ArrayList<InfoData.MetadataOrStatus> datas = new ArrayList<InfoData.MetadataOrStatus>();
            for (AttachmentRecipientInfo info : infos) {
                for (AttachmentRecipientInfo.Status status : AttachmentRecipientInfo.Status.values()) {
                    Optional<Long> timestamp = info.getTimestamp(status);
                    if (timestamp.isEmpty()) continue;
                    RecipientStatus recipientStatus = RecipientStatus.of(status);
                    datas.add(new InfoData.MetadataOrStatus(Either.right(recipientStatus), timestamp.get(), Optional.empty()));
                }
            }
            return datas;
        });
        VBoxList vBoxList = AbstractMessageInfoController.makeVBoxList((Pane)this.mainVBox, MetadataListCell.class, () -> new MetadataListCell(this.stackContext), Optional.empty());
        vBoxList.plug(infoLiveData);
        vBoxList.visibleProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)vBoxList.getChildren()).not());
        VBox.setMargin(vBoxList, (Insets)new Insets(24.0, 0.0, 0.0, 0.0));
    }
}

