/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.message_infos.controller;

import io.olvid.windows.messenger.database.dao.attachment.AbstractAttachmentDao;
import io.olvid.windows.messenger.database.dao.message.AbstractUserMessageDao;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.attachments.AttachmentsListInfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.attachments.OutboundAttachmentInfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.messages.InboundMessageInfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.messages.OutboundMessageInfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.messages.OwnedMessageInfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.model.InfoData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.misc.state_pattern.StackContext;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Region;

public class InfoController
extends BaseModalController
implements LiveDataListener<InfoState> {
    private final ScrollPane scrollPane = new ScrollPane();
    private BaseViewController currentController = null;
    final StackContext<InfoState> stackContext = new StackContext();

    public InfoController(InfoState defaultState) {
        this.setSize(ModalConfiguration.ModalSize.BIG);
        this.scrollPane.maxHeightProperty().bind((ObservableValue)this.getModalHeight());
        this.scrollPane.maxWidthProperty().bind((ObservableValue)this.getModalWidth());
        this.scrollPane.prefHeightProperty().bind((ObservableValue)this.getModalHeight());
        this.scrollPane.prefWidthProperty().bind((ObservableValue)this.getModalWidth());
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.stackContext.getCurrentStateLiveData().addListener(this);
        this.stackContext.pushState(defaultState);
    }

    @Override
    public void onChange(InfoState newValue, InfoState oldValue) {
        ViewControllerHelper.smartUIUpdate(() -> {
            if (newValue == null) {
                if (this.closeModalDelegate != null) {
                    this.closeModalDelegate.run();
                }
                this.currentController = null;
                return;
            }
            this.update(newValue);
        });
    }

    @Override
    public void onLayoutDetached() {
        super.onLayoutDetached();
        if (this.currentController != null) {
            this.currentController.onLayoutDetached();
            this.stackContext.getCurrentStateLiveData().removeListener(this);
            this.currentController = null;
        }
    }

    private void update(InfoState infoState) {
        BaseViewController controller = infoState.makeController(this.stackContext);
        controller.getLayout().prefWidthProperty().bind((ObservableValue)this.getModalWidth());
        controller.getLayout().prefHeightProperty().bind((ObservableValue)this.getModalHeight());
        if (this.currentController != null) {
            this.currentController.onLayoutDetached();
        }
        this.currentController = controller;
        this.scrollPane.setContent((Node)controller.getLayout());
    }

    @Override
    public Region getLayout() {
        return this.scrollPane;
    }

    public static sealed interface InfoState {
        public BaseViewController makeController(StackContext<InfoState> var1);

        public record OutboundAttachmentInfoState(Id<OutboundAttachment> attachmentId, Id<OutboundMessage> messageId, int recipientsCount, boolean hasOwnedDevice) implements InfoState
        {
            @Override
            public BaseViewController makeController(StackContext<InfoState> stackContext) {
                return new OutboundAttachmentInfoController(stackContext, this.attachmentId, this.messageId, this.recipientsCount, this.hasOwnedDevice);
            }
        }

        public record AttachmentsListState<Message extends AbstractUserMessageGenerated<Message>, Attachment extends AbstractAttachmentGenerated<Attachment>>(Id<Message> messageId, Class<Message> messageClass, AbstractUserMessageDao<Message, ?, ?> messageDao, Class<Attachment> attachmentClass, AbstractAttachmentDao<Message, Attachment> attachmentDao, Function<Attachment, InfoData.AttachmentData<Attachment>> makeData) implements InfoState
        {
            @Override
            public BaseViewController makeController(StackContext<InfoState> stackContext) {
                return new AttachmentsListInfoController(stackContext, this);
            }
        }

        public record OwnedMessageInfoState(Id<OwnedMessage> id) implements InfoState
        {
            @Override
            public BaseViewController makeController(StackContext<InfoState> stackContext) {
                return new OwnedMessageInfoController(stackContext, this.id);
            }
        }

        public record OutboundMessageInfoState(Id<OutboundMessage> id, int recipientsCount, boolean hasOwnedDevice) implements InfoState
        {
            @Override
            public BaseViewController makeController(StackContext<InfoState> stackContext) {
                return new OutboundMessageInfoController(stackContext, this.id, this.recipientsCount, this.hasOwnedDevice);
            }
        }

        public record InboundMessageInfoState(Id<InboundMessage> id) implements InfoState
        {
            @Override
            public BaseViewController makeController(StackContext<InfoState> stackContext) {
                return new InboundMessageInfoController(stackContext, this.id);
            }
        }
    }
}

