/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.message_infos.controller;

import io.olvid.windows.messenger.database.dao.message.AbstractUserMessageDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.PendingMessage;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.MessageStatusView;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.InfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.messages.AbstractMessageInfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.model.InfoData;
import io.olvid.windows.messenger.fx.modal.message_infos.view.AbstractInfoDataListCell;
import io.olvid.windows.messenger.fx.modal.message_infos.view.VBoxList;
import io.olvid.windows.messenger.fx.modal.message_infos.view.attachments.AttachmentInfoListCell;
import io.olvid.windows.messenger.fx.modal.message_infos.view.messages.NotSentToContactCell;
import io.olvid.windows.messenger.fx.modal.message_infos.view.messages.NotSentToPendingMemberCell;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.state_pattern.StackContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public abstract class AbstractInfoController<Message extends AbstractUserMessageGenerated<Message>>
extends BaseViewController {
    private final LiveData<Message> messageLiveData;
    protected final Id<Message> messageId;
    protected final Label title = new Label();
    protected final HBox headerHBox = new HBox();
    protected final VBox mainVBox = new VBox();
    protected final StackContext<InfoController.InfoState> stackContext;
    private final LiveDataListener<Message> messageChangeListener = this::messageChangeListener;
    protected final AbstractUserMessageDao<Message, ?, ?> messageDao;

    protected AbstractInfoController(StackContext<InfoController.InfoState> stackContext, Id<Message> messageId, Class<Message> messageClass, AbstractUserMessageDao<Message, ?, ?> messageDao) {
        this.messageId = messageId;
        this.stackContext = stackContext;
        this.messageDao = messageDao;
        this.mainVBox.getStylesheets().add((Object)"fx/discussions/discussion_view/messages/message_list/message_list_cell.css");
        this.mainVBox.getStyleClass().add((Object)"modal-base-grey");
        this.mainVBox.setPadding(new Insets(0.0, 24.0, 24.0, 24.0));
        SvgSizeable previousIcon = new SvgSizeable();
        previousIcon.getStyleClass().addAll((Object[])new String[]{"svg-arrow-left", "icon-large"});
        Button previousButton = new Button("", (Node)previousIcon);
        previousButton.getStyleClass().add((Object)"transparent-icon-button");
        previousButton.managedProperty().bind((ObservableValue)previousButton.visibleProperty());
        previousButton.setVisible(stackContext.getStackSize() > 0);
        previousButton.setOnAction(e -> stackContext.goToPreviousState());
        HBox.setMargin((Node)this.title, (Insets)new Insets(0.0, 0.0, 0.0, 16.0));
        this.title.getStyleClass().add((Object)"h1");
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        SvgSizeable closeIcon = new SvgSizeable();
        closeIcon.getStyleClass().addAll((Object[])new String[]{"svg-close", "icon-large"});
        Button closeButton = new Button("", (Node)closeIcon);
        closeButton.getStyleClass().add((Object)"transparent-icon-button");
        closeButton.setOnAction(e -> stackContext.clearContext());
        this.mainVBox.getChildren().add((Object)this.headerHBox);
        this.headerHBox.getChildren().addAll((Object[])new Node[]{previousButton, this.title, spacer, closeButton});
        this.headerHBox.setAlignment(Pos.CENTER_LEFT);
        VBox.setMargin((Node)this.headerHBox, (Insets)new Insets(24.0, 0.0, 0.0, 0.0));
        this.messageLiveData = LiveDataFactory.buildDbLiveDataItem(messageClass, () -> (AbstractUserMessageGenerated)messageDao.get(messageId));
        this.messageLiveData.addListener(this.messageChangeListener);
    }

    private void messageChangeListener(Message newValue, Message oldValue) {
        if (newValue == null) {
            this.stackContext.clearContext();
        }
    }

    @Override
    public final Region getLayout() {
        return this.mainVBox;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
        this.messageLiveData.removeListener(this.messageChangeListener);
        for (Node child : this.getLayout().getChildrenUnmodifiable()) {
            if (!(child instanceof VBoxList)) continue;
            VBoxList vBoxList = (VBoxList)child;
            vBoxList.unplug();
            vBoxList.update(List.of());
        }
    }

    public static <Data extends InfoData, Cell extends AbstractInfoDataListCell<Data>> VBoxList<Data, Cell> makeVBoxList(Pane parent, Class<Cell> callClass, Supplier<Cell> cellFactory, Optional<Integer> index) {
        VBoxList<InfoData, AbstractInfoDataListCell> vBox = new VBoxList<InfoData, AbstractInfoDataListCell>(callClass, data -> {
            AbstractInfoDataListCell cell = (AbstractInfoDataListCell)cellFactory.get();
            cell.update(data);
            return cell;
        });
        vBox.getStyleClass().add((Object)"metadata-list-view");
        vBox.managedProperty().bind((ObservableValue)vBox.visibleProperty());
        if (index.isEmpty()) {
            parent.getChildren().add(vBox);
        } else {
            parent.getChildren().add(index.get().intValue(), vBox);
        }
        return vBox;
    }

    protected static void attachTitle(Pane parent, String title, Optional<MessageStatusView.Icon> icon, Node node) {
        int i = parent.getChildren().indexOf((Object)node);
        if (i == -1) {
            AppLogger.e("Cannot found node in given parent");
            return;
        }
        HBox titleHBox = new HBox(12.0);
        if (icon.isPresent()) {
            MessageStatusView statusView = new MessageStatusView("icon-medium", 4.5);
            statusView.update(icon.get());
            titleHBox.getChildren().add((Object)statusView);
        }
        Label label = new Label(title);
        label.getStyleClass().add((Object)"h2");
        titleHBox.getChildren().add((Object)label);
        titleHBox.visibleProperty().bind((ObservableValue)node.visibleProperty());
        titleHBox.managedProperty().bind((ObservableValue)titleHBox.visibleProperty());
        VBox.setMargin((Node)titleHBox, (Insets)new Insets(24.0, 0.0, 12.0, 0.0));
        parent.getChildren().add(i, (Object)titleHBox);
    }

    protected <Attachment extends AbstractAttachmentGenerated<Attachment>> void buildAttachmentInfoDataListView(LiveData<List<Attachment>> attachmentLiveData, Function<Attachment, InfoData.AttachmentData<Attachment>> makeData, Supplier<AttachmentInfoListCell<Attachment>> makeCell) {
        LiveData infoDataLiveData = LiveDataFactory.map(attachmentLiveData, List.of(), datas -> {
            if (datas == null) {
                return List.of();
            }
            return datas.stream().map(makeData).toList();
        });
        Class<AttachmentInfoListCell> cellClass = AttachmentInfoListCell.class;
        VBoxList vBoxList = AbstractMessageInfoController.makeVBoxList((Pane)this.mainVBox, cellClass, makeCell, Optional.empty());
        vBoxList.plug(infoDataLiveData);
        vBoxList.visibleProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)vBoxList.getChildren()).not());
        AbstractInfoController.attachTitle((Pane)this.mainVBox, ViewControllerHelper.getString("text_attachments"), Optional.empty(), vBoxList);
    }

    protected static LiveData<List<InfoData.NotSentYetInfo>> buildPendingLiveData(Id<OutboundMessage> messageId) {
        LiveData<List<PendingMessage>> pendingMessagesLiveData = LiveDataFactory.buildDbLiveDataList(PendingMessage.class, () -> DbManager.getInstance().getPendingMessageDao().getAllByMessage(messageId));
        return LiveDataFactory.map(pendingMessagesLiveData, List.of(), pendingMessages -> {
            ArrayList<InfoData.NotSentYetInfo> result = new ArrayList<InfoData.NotSentYetInfo>();
            for (PendingMessage pendingMessage : pendingMessages) {
                ContactRef contactCount = DbManager.getInstance().getContactRefDao().get(pendingMessage.getContactRefId());
                if (contactCount == null || !contactCount.getContactId().isPresent()) continue;
                result.add(new InfoData.NotSentYetInfo(pendingMessage.getContactRefId()));
            }
            return result;
        });
    }

    protected static LiveData<List<InfoData.NotSentToPendingMemberInfo>> buildPendingMemberLiveData(Id<OutboundMessage> messageId) {
        LiveData<List<PendingMessage>> pendingMessagesLiveData = LiveDataFactory.buildDbLiveDataList(PendingMessage.class, () -> DbManager.getInstance().getPendingMessageDao().getAllByMessage(messageId));
        return LiveDataFactory.map(pendingMessagesLiveData, List.of(), pendingMessages -> {
            ArrayList result = new ArrayList();
            for (PendingMessage pendingMessage : pendingMessages) {
                Optional<PendingGroupMember> pendingGroupMemberOpt = DbManager.getInstance().getPendingGroupMemberDao().getUnknownPendingMember(pendingMessage.getContactRefId());
                pendingGroupMemberOpt.ifPresent(pendingGroupMember -> result.add(new InfoData.NotSentToPendingMemberInfo((Id<PendingGroupMember>)pendingGroupMember.getItemId())));
            }
            return result;
        });
    }

    protected void buildNotSentYetInfoListView(String title, LiveData<List<InfoData.NotSentYetInfo>> messageInfoLiveData, Optional<Integer> index) {
        VBoxList vBoxList = AbstractMessageInfoController.makeVBoxList((Pane)this.mainVBox, NotSentToContactCell.class, () -> new NotSentToContactCell(this.stackContext), index);
        AbstractInfoController.attachTitle((Pane)this.mainVBox, title, Optional.of(MessageStatusView.Icon.PENDING), vBoxList);
        vBoxList.plug(messageInfoLiveData);
        vBoxList.visibleProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)vBoxList.getChildren()).not());
    }

    protected void buildPendingMemberInfoListView(String title, LiveData<List<InfoData.NotSentToPendingMemberInfo>> messageInfoLiveData, Optional<Integer> index) {
        VBoxList vBoxList = AbstractMessageInfoController.makeVBoxList((Pane)this.mainVBox, NotSentToPendingMemberCell.class, () -> new NotSentToPendingMemberCell(this.stackContext), index);
        AbstractInfoController.attachTitle((Pane)this.mainVBox, title, Optional.of(MessageStatusView.Icon.PENDING), vBoxList);
        vBoxList.plug(messageInfoLiveData);
        vBoxList.visibleProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)vBoxList.getChildren()).not());
    }
}

