/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.ephemeral_message;

import io.olvid.windows.messenger.fx.framework.utils.FxButtons;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.fx.modal.ephemeral_message.TimePickerModalModel;
import io.olvid.windows.messenger.fx.modal.ephemeral_message.TimeUnitOption;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.ObjectProperty;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public class TimePickerModalController
extends BaseModalController {
    private final TimePickerModalModel model;
    private final ObjectProperty<Long> selectedDurationSecondsProperty;
    private static final PseudoClass INVALID = PseudoClass.getPseudoClass((String)"invalid");
    private VBox root;
    private Label titleLabel;
    private TextField amountField;
    private ComboBox<TimeUnitOption> unitCombo;
    private Button confirmButton;
    private Button cancelButton;
    private Label errorLabel;

    public TimePickerModalController(TimePickerModalModel model, ObjectProperty<Long> selectedDurationSecondsProperty, String delayLabel) {
        this.model = Objects.requireNonNull(model);
        this.selectedDurationSecondsProperty = Objects.requireNonNull(selectedDurationSecondsProperty);
        this.titleLabel = new Label(ViewControllerHelper.getString(delayLabel));
        this.initializeLayout();
        this.initializeBehavior();
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    private void initializeLayout() {
        this.setSize(ModalConfiguration.ModalSize.SELF_SIZE);
        this.amountField = new TextField();
        this.amountField.getStyleClass().setAll((Object[])new String[]{"white-text-field", "field-rounded", "h-sm"});
        this.unitCombo = new ComboBox(this.model.getOptions());
        this.unitCombo.setMaxWidth(Double.MAX_VALUE);
        this.unitCombo.setCellFactory(cb -> new ListCell<TimeUnitOption>(this){

            protected void updateItem(TimeUnitOption item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.setText(empty || item == null ? null : item.label());
            }
        });
        this.unitCombo.setButtonCell((ListCell)new ListCell<TimeUnitOption>(this){

            protected void updateItem(TimeUnitOption item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.setText(empty || item == null ? null : item.label());
            }
        });
        this.confirmButton = FxButtons.create(() -> {
            Long s = this.parseUserInputToSeconds();
            if (s == null) {
                this.shake((Node)this.amountField);
                this.amountField.requestFocus();
                return;
            }
            this.selectedDurationSecondsProperty.set((Object)s);
            this.closeModalDelegate.run();
        }).label(ViewControllerHelper.getString("button_label_validate")).addStyleClasses("primary-button", "button-sm").addLabelStyleClasses("white-text").fullWidth().build();
        this.cancelButton = FxButtons.create(() -> this.closeModalDelegate.run()).label(ViewControllerHelper.getString("cancel")).addStyleClasses("secondary-button", "button-sm").fullWidth().build();
        this.errorLabel = new Label();
        this.errorLabel.getStyleClass().addAll((Object[])new String[]{"error-text"});
        this.errorLabel.setVisible(false);
        this.errorLabel.setManaged(true);
        HBox container = new HBox(12.0, new Node[]{this.titleLabel, this.amountField, this.unitCombo, this.cancelButton, this.confirmButton});
        container.setPadding(new Insets(20.0, 0.0, 0.0, 0.0));
        container.setAlignment(Pos.CENTER_LEFT);
        this.root = new VBox(6.0, new Node[]{container, this.errorLabel});
        this.root.setAlignment(Pos.CENTER_LEFT);
        this.root.setPadding(new Insets(16.0));
        this.root.getStyleClass().addAll((Object[])new String[]{"modal-contextual-background"});
        this.root.getStylesheets().add((Object)"fx/modal/modal.css");
        this.root.setMaxWidth(580.0);
        this.root.setMaxHeight(80.0);
    }

    private void initializeBehavior() {
        this.amountField.setTextFormatter(new TextFormatter(change -> {
            String n = change.getControlNewText();
            return n.matches("\\d{0,3}") ? change : null;
        }));
        Long seconds = (Long)this.selectedDurationSecondsProperty.get();
        this.prefillFromSeconds(seconds);
        this.amountField.textProperty().addListener((obs, o, n) -> this.validateAndUpdateUI());
        this.unitCombo.valueProperty().addListener((obs, oldU, newU) -> {
            this.clampToUnitRange();
            this.validateAndUpdateUI();
        });
        this.validateAndUpdateUI();
    }

    private boolean isValueValid(String text, TimeUnit unit) {
        if (unit == null || text == null || text.isBlank()) {
            return false;
        }
        long min = 1L;
        long max = this.maxFor(unit);
        try {
            long v = Long.parseLong(text);
            return v >= min && v <= max;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private long maxFor(TimeUnit unit) {
        return switch (unit) {
            case TimeUnit.SECONDS, TimeUnit.MINUTES -> 59L;
            case TimeUnit.HOURS -> 23L;
            case TimeUnit.DAYS -> 364L;
            default -> Long.MAX_VALUE;
        };
    }

    private String constraintMessage(TimeUnit unit) {
        if (unit == null) {
            return ViewControllerHelper.getString("time_picker_invalid");
        }
        return ViewControllerHelper.getString(switch (unit) {
            case TimeUnit.SECONDS -> "time_picker_invalid_seconds";
            case TimeUnit.MINUTES -> "time_picker_invalid_minutes";
            case TimeUnit.HOURS -> "time_picker_invalid_hours";
            case TimeUnit.DAYS -> "time_picker_invalid_days";
            default -> "time_picker_invalid";
        });
    }

    private void clampToUnitRange() {
        long v;
        String t = this.amountField.getText();
        if (t == null || t.isBlank() || this.unitCombo.getValue() == null) {
            return;
        }
        try {
            v = Long.parseLong(t);
        }
        catch (NumberFormatException e) {
            return;
        }
        long min = 1L;
        long max = this.maxFor(((TimeUnitOption)this.unitCombo.getValue()).timeUnit());
        if (v < min) {
            this.amountField.setText(String.valueOf(min));
        } else if (v > max) {
            this.amountField.setText(String.valueOf(max));
        }
    }

    private void validateAndUpdateUI() {
        TimeUnit unit = this.unitCombo.getValue() == null ? null : ((TimeUnitOption)this.unitCombo.getValue()).timeUnit();
        String txt = this.amountField.getText();
        boolean valid = this.isValueValid(txt, unit);
        this.confirmButton.setDisable(!valid);
        this.amountField.pseudoClassStateChanged(INVALID, !valid);
        this.amountField.setTooltip(!valid ? new Tooltip(this.constraintMessage(unit)) : null);
        this.errorLabel.setText(this.constraintMessage(unit));
        this.errorLabel.setManaged(true);
        this.errorLabel.setVisible(!valid);
    }

    private void prefillFromSeconds(Long seconds) {
        if (seconds == null) {
            this.unitCombo.getSelectionModel().select((Object)TimeUnitOption.hours());
            this.amountField.setText("1");
            return;
        }
        if (seconds % TimeUnit.DAYS.toSeconds(1L) == 0L) {
            this.unitCombo.getSelectionModel().select((Object)TimeUnitOption.days());
            this.amountField.setText(String.valueOf(seconds / TimeUnit.DAYS.toSeconds(1L)));
        } else if (seconds % TimeUnit.HOURS.toSeconds(1L) == 0L) {
            this.unitCombo.getSelectionModel().select((Object)TimeUnitOption.hours());
            this.amountField.setText(String.valueOf(seconds / TimeUnit.HOURS.toSeconds(1L)));
        } else if (seconds % TimeUnit.MINUTES.toSeconds(1L) == 0L) {
            this.unitCombo.getSelectionModel().select((Object)TimeUnitOption.minutes());
            this.amountField.setText(String.valueOf(seconds / TimeUnit.MINUTES.toSeconds(1L)));
        } else {
            this.unitCombo.getSelectionModel().select((Object)TimeUnitOption.seconds());
            this.amountField.setText(String.valueOf(seconds));
        }
    }

    private Long parseUserInputToSeconds() {
        TimeUnitOption opt;
        String amt = this.amountField.getText();
        if (!this.isValueValid(amt, (opt = (TimeUnitOption)this.unitCombo.getValue()) == null ? null : opt.timeUnit())) {
            return null;
        }
        long value = Long.parseLong(amt.trim());
        long factor = switch (opt.timeUnit()) {
            case TimeUnit.DAYS -> TimeUnit.DAYS.toSeconds(1L);
            case TimeUnit.HOURS -> TimeUnit.HOURS.toSeconds(1L);
            case TimeUnit.MINUTES -> TimeUnit.MINUTES.toSeconds(1L);
            default -> 1L;
        };
        return Math.multiplyExact(value, factor);
    }

    private void shake(Node n) {
        n.setStyle("-fx-border-color: -fx-danger; -fx-border-radius: 4;");
    }
}

