/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.ephemeral_message;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.engine.helpers.message.tasks.SetDraftJsonExpirationTask;
import io.olvid.windows.messenger.fx.modal.ephemeral_message.DurationOption;
import io.olvid.windows.messenger.fx.modal.ephemeral_message.TimePickerModalModel;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class EphemeralMessageModalModel {
    private final BooleanProperty readOnce = new SimpleBooleanProperty(false);
    public final ObjectProperty<Long> visibilityDurationSeconds = new SimpleObjectProperty(null);
    public final ObjectProperty<Long> existenceDurationSeconds = new SimpleObjectProperty(null);
    public TimePickerModalModel timePickerModalModel = new TimePickerModalModel();

    public final ObservableList<DurationOption> visibilityOptions() {
        return FXCollections.observableArrayList((Object[])new DurationOption[]{DurationOption.hours(1L), DurationOption.hours(12L), DurationOption.days(1L), DurationOption.days(7L), DurationOption.days(30L), DurationOption.forever(), DurationOption.customOption()});
    }

    public final ObservableList<DurationOption> existenceOptions() {
        return FXCollections.observableArrayList((Object[])new DurationOption[]{DurationOption.days(1L), DurationOption.days(7L), DurationOption.days(30L), DurationOption.days(90L), DurationOption.forever(), DurationOption.customOption()});
    }

    public boolean isReadOnce() {
        return this.readOnce.get();
    }

    public void setReadOnce(boolean value) {
        this.readOnce.set(value);
    }

    public BooleanProperty readOnceProperty() {
        return this.readOnce;
    }

    public ObjectProperty<Long> visibilityDurationSecondsProperty() {
        return this.visibilityDurationSeconds;
    }

    public ObjectProperty<Long> existenceDurationSecondsProperty() {
        return this.existenceDurationSeconds;
    }

    public void applyChanges(Discussion discussion, DiscussionCustomization discussionCustomization) {
        Long vis = (Long)this.visibilityDurationSeconds.get();
        Long exist = (Long)this.existenceDurationSeconds.get();
        boolean ro = this.isReadOnce();
        AsyncTaskExecutor.submitTask(() -> {
            discussionCustomization.setPrefDefaultSettingExistenceDuration(Optional.ofNullable(exist));
            discussionCustomization.setPrefDefaultSettingVisibilityDuration(Optional.ofNullable(vis));
            discussionCustomization.setPrefDefaultSettingReadOnce(ro);
            DbManager.getInstance().getDiscussionCustomizationDao().update(discussionCustomization);
            new SetDraftJsonExpirationTask(discussion, ro, vis, exist).run();
        });
    }

    public void reset() {
        this.readOnce.set(false);
        this.visibilityDurationSeconds.set(null);
        this.existenceDurationSeconds.set(null);
    }
}

