/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.ephemeral_message;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionSelectionModel;
import io.olvid.windows.messenger.fx.framework.utils.FxButtons;
import io.olvid.windows.messenger.fx.framework.utils.FxIcons;
import io.olvid.windows.messenger.fx.framework.view_controller.CloseGuard;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.CloseableModalController;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.fx.modal.ephemeral_message.DurationOption;
import io.olvid.windows.messenger.fx.modal.ephemeral_message.EphemeralMessageModalModel;
import io.olvid.windows.messenger.fx.modal.ephemeral_message.TimePickerModalController;
import io.olvid.windows.messenger.fx.settings.components.ToggleSettingItemView;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class EphemeralMessageModalController
extends CloseableModalController {
    private static final Insets ROW_SIDE_PADDING = new Insets(0.0, 24.0, 0.0, 24.0);
    private static final Insets HEADER_PADDING = new Insets(14.0, 16.0, 10.0, 16.0);
    private static final Insets BODY_PADDING = new Insets(24.0, 0.0, 24.0, 0.0);
    private static final Insets FOOTER_PADDING = new Insets(0.0, 24.0, 24.0, 24.0);
    private static final Insets ROOT_PADDING = new Insets(6.0);
    private final EphemeralMessageModalModel model;
    private final StackPane root = new StackPane();
    private Discussion discussion;
    private DiscussionCustomization discussionCustomization;
    private final LiveDataListener<Discussion> discussionListener = this::onCurrentDiscussionChanged;

    public EphemeralMessageModalController(EphemeralMessageModalModel model) {
        this.model = model;
        Discussion cur = DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().getValue();
        if (cur != null) {
            this.initDiscussionState(cur);
        } else {
            model.reset();
        }
        this.initializeLayout();
        this.bindLifecycle();
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
        DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().addListener(this.discussionListener);
    }

    @Override
    public void onLayoutDetached() {
        DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().removeListener(this.discussionListener);
    }

    private void initializeLayout() {
        this.setSize(ModalConfiguration.ModalSize.SELF_SIZE);
        ObservableList<DurationOption> visibilityOptions = this.model.visibilityOptions();
        ObservableList<DurationOption> existenceOptions = this.model.existenceOptions();
        BorderPane wrapper = new BorderPane();
        wrapper.getStyleClass().add((Object)"ephemeral-modal");
        Label title = new Label(ViewControllerHelper.getString("ephemeral_messages_modal_title"));
        title.getStyleClass().add((Object)"h1");
        Region headerSpacer = new Region();
        HBox.setHgrow((Node)headerSpacer, (Priority)Priority.ALWAYS);
        Button closeButton = new Button();
        closeButton.getStyleClass().addAll((Object[])new String[]{"transparent-icon-button"});
        closeButton.setFocusTraversable(false);
        closeButton.setTooltip(new Tooltip("Fermer"));
        Node closeIcon = FxIcons.icon(FxIcons.CLOSE((Paint)Color.BLACK, (Paint)Color.BLACK), 12.0, 12.0);
        closeButton.setGraphic(closeIcon);
        closeButton.setOnAction(ignored -> this.closeModalDelegate.run());
        HBox header = new HBox(12.0, new Node[]{title, headerSpacer, closeButton});
        header.setAlignment(Pos.CENTER_LEFT);
        header.setPadding(HEADER_PADDING);
        Button validBtn = FxButtons.create(() -> {
            this.model.applyChanges(this.discussion, this.discussionCustomization);
            this.closeModalDelegate.run();
        }).label(ViewControllerHelper.getString("save_button_label")).addStyleClasses("primary-button").addLabelStyleClasses("white-text").fullWidth().build();
        Button cancelBtn = FxButtons.create(() -> this.closeModalDelegate.run()).label(ViewControllerHelper.getString("cancel")).addStyleClasses("secondary-button").fullWidth().build();
        VBox footer = new VBox(12.0, new Node[]{validBtn, cancelBtn});
        footer.setPadding(FOOTER_PADDING);
        footer.setAlignment(Pos.CENTER_RIGHT);
        VBox body = new VBox(14.0);
        HBox rowReadOnce = this.buildToggleRow(ViewControllerHelper.getString("ephemeral_read_once_option"), this.model.readOnceProperty());
        HBox rowVisibility = this.buildComboRow(FxIcons.EYE((Paint)Color.BLACK, null), ViewControllerHelper.getString("ephemeral_visibility_duration_option"), this.model.visibilityDurationSecondsProperty(), visibilityOptions, () -> this.showCustomDurationDialog(this.model.visibilityDurationSecondsProperty(), "ephemeral_visibility_duration_option"));
        HBox rowLifetime = this.buildComboRow(FxIcons.FRAME3((Paint)Color.BLACK, (Paint)Color.BLACK), ViewControllerHelper.getString("ephemeral_existence_duration_option"), this.model.existenceDurationSecondsProperty(), existenceOptions, () -> this.showCustomDurationDialog(this.model.existenceDurationSecondsProperty(), "ephemeral_existence_duration_option"));
        Region s1 = this.buildSeparator();
        Region s2 = this.buildSeparator();
        rowReadOnce.setPadding(ROW_SIDE_PADDING);
        rowVisibility.setPadding(ROW_SIDE_PADDING);
        rowLifetime.setPadding(ROW_SIDE_PADDING);
        body.setPadding(BODY_PADDING);
        body.getChildren().addAll((Object[])new Node[]{rowReadOnce, s1, rowVisibility, s2, rowLifetime});
        wrapper.setTop((Node)header);
        wrapper.setCenter((Node)body);
        wrapper.setBottom((Node)footer);
        this.root.getStyleClass().addAll((Object[])new String[]{"modal-contextual-background"});
        this.root.getStylesheets().add((Object)"fx/modal/modal.css");
        this.root.getChildren().setAll((Object[])new Node[]{wrapper});
        this.root.setMaxWidth(371.0);
        this.root.setMaxHeight(289.0);
        this.root.setPadding(ROOT_PADDING);
    }

    private Region buildSeparator() {
        Region separator = new Region();
        separator.setMaxHeight(1.0);
        separator.setPrefHeight(1.0);
        separator.getStyleClass().add((Object)"separator");
        return separator;
    }

    private void initDiscussionState(Discussion newDiscussion) {
        this.discussion = newDiscussion;
        AsyncTaskExecutor.submitTask(() -> {
            DiscussionCustomization dc = DbManager.getInstance().getDiscussionCustomizationDao().getDiscussionCustomization((Id<Discussion>)newDiscussion.getItemId());
            ViewControllerHelper.smartUIUpdate(() -> {
                this.discussionCustomization = dc;
                if (dc == null) {
                    this.model.reset();
                    return;
                }
                this.model.setReadOnce(dc.isPrefDefaultSettingReadOnce());
                this.model.visibilityDurationSecondsProperty().set((Object)dc.getPrefDefaultSettingVisibilityDuration().orElse(null));
                this.model.existenceDurationSecondsProperty().set((Object)dc.getPrefDefaultSettingExistenceDuration().orElse(null));
            });
        });
    }

    private void onCurrentDiscussionChanged(Discussion newDiscussion, Discussion oldDiscussion) {
        if (newDiscussion == null || Objects.equals(newDiscussion, this.discussion)) {
            return;
        }
        this.discussion = newDiscussion;
        this.discussionCustomization = DbManager.getInstance().getDiscussionCustomizationDao().getDiscussionCustomization((Id<Discussion>)this.discussion.getItemId());
        this.model.setReadOnce(this.discussionCustomization.isPrefDefaultSettingReadOnce());
        this.model.visibilityDurationSeconds.set((Object)this.discussionCustomization.getPrefDefaultSettingVisibilityDuration().orElse(null));
        this.model.existenceDurationSeconds.set((Object)this.discussionCustomization.getPrefDefaultSettingExistenceDuration().orElse(null));
    }

    private void showCustomDurationDialog(ObjectProperty<Long> delayProperty, String delayLabel) {
        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new TimePickerModalController(this.model.timePickerModalModel, delayProperty, delayLabel), false));
    }

    private HBox buildToggleRow(String labelText, BooleanProperty boundProperty) {
        ToggleSettingItemView toggleItem = new ToggleSettingItemView();
        toggleItem.twitch.selectedProperty().bindBidirectional((Property)boundProperty);
        Label label = new Label(labelText);
        Node icon = FxIcons.icon(FxIcons.ZAP((Paint)Color.BLACK, null), 16.667, 15.0);
        return this.row(icon, label, (Node)toggleItem);
    }

    private HBox buildComboRow(FxIcons.IconDef iconDef, String labelText, final ObjectProperty<Long> boundSeconds, final ObservableList<DurationOption> options, Runnable onCustomize) {
        Label label = new Label(labelText);
        final ComboBox combo = new ComboBox(options);
        combo.setMaxWidth(Double.MAX_VALUE);
        final ArrayList<DurationOption> baseOptions = new ArrayList<DurationOption>((Collection<DurationOption>)options);
        combo.setCellFactory(cb -> new ListCell<DurationOption>(this){

            protected void updateItem(DurationOption item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.setText(empty || item == null ? null : item.label());
            }
        });
        combo.setButtonCell((ListCell)new ListCell<DurationOption>(this){

            protected void updateItem(DurationOption item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.setText(empty || item == null ? null : item.label());
            }
        });
        Long current = boundSeconds == null ? null : (Long)boundSeconds.get();
        DurationOption initial = options.stream().filter(o -> Objects.equals(o.seconds(), current)).findFirst().orElse(null);
        if (initial == null) {
            if (current != null) {
                DurationOption display = new DurationOption(EphemeralMessageModalController.formatDurationLabel(current), current, false);
                options.addFirst((Object)display);
                initial = display;
            } else {
                initial = (DurationOption)options.getFirst();
            }
        }
        combo.getSelectionModel().select((Object)initial);
        combo.valueProperty().addListener((obs, oldVal, newVal) -> {
            if (newVal == null) {
                return;
            }
            if (newVal.isCustom()) {
                ChangeListener<Long> oneShot = new ChangeListener<Long>(){

                    public void changed(ObservableValue<? extends Long> obs, Long oldS, Long newS) {
                        boundSeconds.removeListener((ChangeListener)this);
                        if (newS == null) {
                            DurationOption forever = baseOptions.stream().filter(opt -> opt.seconds() == null && !opt.isCustom()).findFirst().orElse(null);
                            if (forever != null) {
                                combo.getSelectionModel().select((Object)forever);
                            }
                            options.setAll((Collection)baseOptions);
                            return;
                        }
                        DurationOption match = baseOptions.stream().filter(opt -> Objects.equals(opt.seconds(), newS)).findFirst().orElse(null);
                        if (match != null) {
                            options.setAll((Collection)baseOptions);
                            combo.getSelectionModel().select((Object)match);
                            return;
                        }
                        ArrayList<DurationOption> fresh = new ArrayList<DurationOption>(baseOptions);
                        DurationOption display = new DurationOption(EphemeralMessageModalController.formatDurationLabel(newS), newS, false);
                        fresh.addFirst(display);
                        options.setAll(fresh);
                        combo.getSelectionModel().select((Object)display);
                    }
                };
                if (boundSeconds != null) {
                    boundSeconds.addListener((ChangeListener)oneShot);
                }
                if (onCustomize != null) {
                    onCustomize.run();
                }
                combo.getSelectionModel().select(oldVal);
                return;
            }
            if (boundSeconds != null) {
                boundSeconds.set((Object)newVal.seconds());
            }
        });
        Node icon = FxIcons.icon(iconDef, 20.0, 20.0);
        combo.setMinWidth(130.0);
        return this.row(icon, label, (Node)combo);
    }

    private static String formatDurationLabel(Long seconds) {
        if (seconds == null) {
            return ViewControllerHelper.getString("ephemeral_delay_ever_option");
        }
        long s = seconds;
        long day = 86400L;
        long hour = 3600L;
        long minute = 60L;
        if (s % day == 0L) {
            return EphemeralMessageModalController.plural(s / day, "unit_time_day", "unit_time_day_plural");
        }
        if (s % hour == 0L) {
            return EphemeralMessageModalController.plural(s / hour, "unit_time_hour", "unit_time_hour_plural");
        }
        if (s % minute == 0L) {
            return EphemeralMessageModalController.plural(s / minute, "unit_time_minute", "unit_time_minute_plural");
        }
        return EphemeralMessageModalController.plural(s, "unit_time_second", "unit_time_second_plural");
    }

    private static String plural(long value, String unit, String unitPlural) {
        String unitStr = ViewControllerHelper.getString(value > 1L ? unitPlural : unit);
        return value + " " + unitStr;
    }

    private HBox row(Node icon, Label label, Node rightControl) {
        label.getStyleClass().add((Object)"row-label");
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        HBox row = new HBox(12.0, new Node[]{icon, label, spacer, rightControl});
        row.setAlignment(Pos.CENTER_LEFT);
        row.setMinHeight(44.0);
        row.setPadding(new Insets(0.0, 16.0, 0.0, 16.0));
        return row;
    }

    @Override
    protected CloseGuard getActiveCloseGuard() {
        return null;
    }
}

