/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.confirmation.keycloak;

import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.keycloak.protocol.AuthenticationProtocol;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class KeycloakAuthenticationConfirmationModalModel
implements NotificationListener<AuthenticationProtocol.KeycloakAuthenticationNotification> {
    private final AppLogger logger = new AppLogger(KeycloakAuthenticationConfirmationModalModel.class);
    private final byte[] ownedIdentityBytes;
    public final BooleanProperty loading = new SimpleBooleanProperty(false);
    public final StringProperty progressLabel = new SimpleStringProperty();
    public final StringProperty errorLabel = new SimpleStringProperty();
    public final BooleanProperty success = new SimpleBooleanProperty(false);
    public final BooleanProperty failed = new SimpleBooleanProperty(false);
    public final BooleanProperty showManualRedirectInput = new SimpleBooleanProperty(false);
    public final StringProperty redirectInput = new SimpleStringProperty();

    public KeycloakAuthenticationConfirmationModalModel(byte[] ownedIdentityBytes) {
        this.logger.info("KeycloakAuthenticationConfirmationModalModel::new");
        this.ownedIdentityBytes = ownedIdentityBytes;
        this.progressLabel.set((Object)ViewControllerHelper.getString("keycloak_authentication_required_text"));
    }

    @Override
    public void onReceived(AuthenticationProtocol.KeycloakAuthenticationNotification keycloakAuthenticationNotification) {
        this.logger.debug("KeycloakAuthenticationConfirmationModalModel::onReceived received enrollement notification : %s", keycloakAuthenticationNotification.getNotificationType());
        ViewControllerHelper.smartUIUpdate(() -> {
            AuthenticationProtocol.KeycloakAuthenticationNotification keycloakAuthenticationNotification2 = keycloakAuthenticationNotification;
            Objects.requireNonNull(keycloakAuthenticationNotification2);
            AuthenticationProtocol.KeycloakAuthenticationNotification selector0$temp = keycloakAuthenticationNotification2;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AuthenticationProtocol.AuthenticationProtocolFailed.class, AuthenticationProtocol.AuthenticationSuccessNotification.class, AuthenticationProtocol.DiscoveringNotification.class, AuthenticationProtocol.WaitingForAccessTokenNotification.class, AuthenticationProtocol.WaitingForAuthorizationCodeNotification.class}, (Object)selector0$temp, index$1)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    AuthenticationProtocol.AuthenticationProtocolFailed authenticationProtocolFailed = (AuthenticationProtocol.AuthenticationProtocolFailed)selector0$temp;
                    switch (authenticationProtocolFailed.failMessage()) {
                        case RFC_BAD_REDIRECT_URL: {
                            this.errorLabel.setValue(ViewControllerHelper.getString("keycloak_authentication_failed_bad_redirect"));
                            break;
                        }
                        case RFC_INTERNAL_ERROR: 
                        case RFC_INVALID_AUTH_STATE: 
                        case RFC_AUTHENTICATION_REQUIRED: 
                        case RFC_INVALID_DETAILS_SIGNATURE: 
                        case RFC_IDENTITY_NOT_MANAGED: {
                            this.errorLabel.setValue(ViewControllerHelper.getString("keycloak_identity_internal_error_label"));
                            break;
                        }
                        case RFC_NETWORK_ERROR: {
                            this.errorLabel.setValue(ViewControllerHelper.getString("keycloak_network_error_label"));
                            break;
                        }
                        case RFC_BAD_RESPONSE: 
                        case RFC_SERVER_ERROR: {
                            this.errorLabel.setValue(ViewControllerHelper.getString("keycloak_bad_response_label"));
                            break;
                        }
                        case RFC_IDENTITY_ALREADY_UPLOADED: {
                            this.errorLabel.setValue(ViewControllerHelper.getString("on_boarding_flow_keycloak_already_uploaded"));
                            break;
                        }
                        case RFC_IDENTITY_REVOKED: {
                            this.errorLabel.setValue(ViewControllerHelper.getString("keycloak_binding_error_identity_revoked_text_label"));
                            break;
                        }
                        case RFC_INTTERUPTED: {
                            this.logger.debug("KeycloakAuthenticationConfirmationModalModel::onReceived protocol interrupted (prolly by user)");
                        }
                    }
                    this.progressLabel.set((Object)ViewControllerHelper.getString("authentication_error_label"));
                    this.loading.set(false);
                    this.showManualRedirectInput.set(false);
                    this.redirectInput.set(null);
                    this.failed.set(true);
                    break;
                }
                case 1: {
                    AuthenticationProtocol.AuthenticationSuccessNotification ignored = (AuthenticationProtocol.AuthenticationSuccessNotification)selector0$temp;
                    this.success.set(true);
                    this.failed.set(false);
                    break;
                }
                case 2: {
                    AuthenticationProtocol.DiscoveringNotification ignored = (AuthenticationProtocol.DiscoveringNotification)selector0$temp;
                    this.errorLabel.set(null);
                    this.failed.set(false);
                    this.progressLabel.set((Object)ViewControllerHelper.getString("discovering_keycloak_server"));
                    break;
                }
                case 3: {
                    AuthenticationProtocol.WaitingForAccessTokenNotification ignored = (AuthenticationProtocol.WaitingForAccessTokenNotification)selector0$temp;
                    this.errorLabel.set(null);
                    this.failed.set(false);
                    this.progressLabel.set((Object)ViewControllerHelper.getString("waiting_for_access_token_label"));
                    break;
                }
                case 4: {
                    AuthenticationProtocol.WaitingForAuthorizationCodeNotification waitingForAuthorizationCodeNotification = (AuthenticationProtocol.WaitingForAuthorizationCodeNotification)selector0$temp;
                    this.errorLabel.set(null);
                    this.failed.set(false);
                    this.progressLabel.set((Object)ViewControllerHelper.getString("waiting_for_redirect_url_code"));
                    try {
                        AppRuntimeHelper.launchBrowser(waitingForAuthorizationCodeNotification.authenticationUrl());
                        break;
                    }
                    catch (IOException e) {
                        this.errorLabel.set((Object)ViewControllerHelper.getString("open_browser_failed_label"));
                    }
                }
            }
        });
    }

    public void startAuthenticationProtocol() {
        ViewControllerHelper.smartUIUpdate(() -> this.loading.set(true));
        KeycloakManager.getInstance().startAuthenticationProtocol(this.ownedIdentityBytes, this);
    }

    public void stopAuthenticationProtocol() {
        KeycloakManager.getInstance().stopAuthenticationProtocol();
    }
}

