/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.confirmation.keycloak;

import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.confirmation.ConfirmationModalController;
import io.olvid.windows.messenger.fx.modal.confirmation.keycloak.KeycloakAuthenticationConfirmationModalModel;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.TcpMessageNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.TcpServerNC;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;

public class KeycloakAuthenticationConfirmationModalController
extends ConfirmationModalController {
    private final KeycloakAuthenticationConfirmationModalModel modalModel;
    private final ChangeListener<Boolean> onSuccess = this::onSuccess;
    private final Label errorLabel = new Label();
    public final TextField input = new TextField();
    public final Button nextButton = new Button();
    public final Hyperlink enableManualRedirectHyperlink = new Hyperlink(ViewControllerHelper.getString("on_boarding_flow_keycloak_authentication_in_paste_redirect_url_label"));

    public KeycloakAuthenticationConfirmationModalController() {
        this.logger.info("KeycloakAuthenticationConfirmationModalController::new");
        if (SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().isEmpty()) {
            throw new IllegalStateException("KeycloakAuthenticationConfirmationModalController::new selected owned identity is null");
        }
        this.modalModel = new KeycloakAuthenticationConfirmationModalModel(SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().get().bytesOwnedIdentity());
        this.confirmationModalHeaderLabel.setText(ViewControllerHelper.getString("keycloak_authentication_required_header_text_label"));
        SvgSizeable svgSizeable = new SvgSizeable();
        svgSizeable.getStyleClass().addAll((Object[])new String[]{"icon-white", "icon-medium", "svg-arrow-right"});
        this.validateButton.setGraphic((Node)svgSizeable);
        this.validateButton.visibleProperty().bind((ObservableValue)this.modalModel.loading.not());
        this.cancelButton.setOnMouseClicked(this::onCancelClicked);
        this.ringContainer.visibleProperty().bind((ObservableValue)this.modalModel.loading);
        this.ringContainer.managedProperty().bind((ObservableValue)this.ringContainer.visibleProperty());
        this.errorLabel.textProperty().bind((ObservableValue)this.modalModel.errorLabel);
        this.errorLabel.visibleProperty().bind((ObservableValue)this.modalModel.failed);
        this.errorLabel.managedProperty().bind((ObservableValue)this.errorLabel.visibleProperty());
        this.errorLabel.getStyleClass().setAll((Object[])new String[]{"error-text", "body-1-size"});
        this.errorLabel.setTextAlignment(TextAlignment.CENTER);
        this.errorLabel.setWrapText(true);
        this.modalContentText.textProperty().bind((ObservableValue)this.modalModel.progressLabel);
        VBox labelsContainer = new VBox(new Node[]{this.errorLabel});
        labelsContainer.setAlignment(Pos.CENTER);
        this.input.getStyleClass().addAll((Object[])new String[]{"body-2"});
        this.input.setPromptText(ViewControllerHelper.getString("on_boarding_flow_keycloak_authentication_link_example"));
        this.input.textProperty().bindBidirectional((Property)this.modalModel.redirectInput);
        SvgSizeable buttonIcon = new SvgSizeable();
        buttonIcon.getStyleClass().addAll((Object[])new String[]{"icon-medium", "svg-chevron", "icon-white"});
        this.nextButton.setGraphic((Node)buttonIcon);
        this.nextButton.getStyleClass().add((Object)"primary-button");
        this.nextButton.disableProperty().bind((ObservableValue)this.input.textProperty().isEmpty());
        this.nextButton.setOnMouseClicked(event -> {
            TcpMessageNotification tcpMessageNotification = new TcpMessageNotification(TcpServerNC.TcpMessageNotificationEnumType.KEYCLOAK_AUTHENTICATION_REDIRECT_URI.messageId, this.input.getText().trim());
            NCRegistry.getTCPServerNC().postNotification(tcpMessageNotification);
        });
        HBox inputAndButton = new HBox(new Node[]{this.input, this.nextButton});
        inputAndButton.setSpacing(12.0);
        HBox.setHgrow((Node)this.input, (Priority)Priority.ALWAYS);
        inputAndButton.visibleProperty().bind((ObservableValue)this.modalModel.showManualRedirectInput);
        this.enableManualRedirectHyperlink.setOnAction(event -> this.modalModel.showManualRedirectInput.set(true));
        this.enableManualRedirectHyperlink.getStyleClass().addAll((Object[])new String[]{"body-1-size"});
        this.enableManualRedirectHyperlink.setTextAlignment(TextAlignment.CENTER);
        this.enableManualRedirectHyperlink.visibleProperty().bind((ObservableValue)this.modalModel.showManualRedirectInput.not());
        StackPane explanationOrInput = new StackPane(new Node[]{inputAndButton, this.enableManualRedirectHyperlink});
        explanationOrInput.setAlignment(Pos.CENTER);
        explanationOrInput.visibleProperty().bind((ObservableValue)this.modalModel.failed.not().and((ObservableBooleanValue)this.modalModel.loading));
        HBox.setHgrow((Node)explanationOrInput, (Priority)Priority.ALWAYS);
        this.contextualTextVbox.getChildren().add(2, (Object)labelsContainer);
        this.contextualTextVbox.getChildren().add(3, (Object)explanationOrInput);
        this.bindLifecycle();
    }

    private void onSuccess(ObservableValue<? extends Boolean> observableValue, Boolean oldVal, Boolean newVal) {
        if (newVal.booleanValue()) {
            this.closeModalDelegate.run();
        }
    }

    @Override
    protected void onValidateClicked(MouseEvent mouseEvent) {
        this.modalModel.startAuthenticationProtocol();
    }

    @Override
    protected void onCancelClicked(MouseEvent mouseEvent) {
        this.modalModel.stopAuthenticationProtocol();
        this.closeModalDelegate.run();
    }

    @Override
    public void onLayoutAttached() {
        this.modalModel.success.addListener(this.onSuccess);
    }

    @Override
    public void onLayoutDetached() {
        this.modalModel.stopAuthenticationProtocol();
        this.modalModel.success.removeListener(this.onSuccess);
    }
}

