/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.confirmation.keycloak;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.fx.modal.confirmation.ConfirmationModalController;
import io.olvid.windows.messenger.keycloak.KeycloakCallReturn;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.misc.Pair;
import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class DialogKeycloakIdentityReplacement
extends ConfirmationModalController {
    public static final String KEYCLOAK_IDENTITY_REPLACEMENT_DIALOG_TEXT_LABEL_ID = "keycloak_identity_replacement_dialog_text_label";
    public static final String KEYCLOAK_IDENTITY_REPLACEMENT_DIALOG_HEADER_TEXT_LABEL_ID = "keycloak_identity_replacement_dialog_header_text_label";
    public static final String KEYCLOAK_ERROR_HEADER_TEXT_LABEL_ID = "keycloak_error_header_text_label";
    public static final String KEYCLOAK_IDENTITY_REPLACEMENT_FORBIDDEN_TEXT_ID = "keycloak_identity_replacement_forbidden_text";
    public static final String REPLACE_LABEL_ID = "replace_button_text_label";
    public static final String VALIDATE_LABEL_ID = "button_label_validate";
    private final Pair<byte[], Boolean> bytesOwnedIdentityWithRevocationAllowed;

    public DialogKeycloakIdentityReplacement(Pair<byte[], Boolean> ownedIdentityBytesWithPermission) {
        Objects.requireNonNull(ownedIdentityBytesWithPermission);
        this.setSize(ModalConfiguration.ModalSize.MEDIUM);
        this.bytesOwnedIdentityWithRevocationAllowed = ownedIdentityBytesWithPermission;
        this.modalContentText.wrappingWidthProperty().bind((ObservableValue)this.getModalWidth().multiply(0.8));
        if (ownedIdentityBytesWithPermission.getSecond().booleanValue()) {
            this.confirmationModalHeaderLabel.setText(ViewControllerHelper.RESOURCE_BUNDLE.getString(KEYCLOAK_IDENTITY_REPLACEMENT_DIALOG_HEADER_TEXT_LABEL_ID));
            this.modalContentText.setText(ViewControllerHelper.RESOURCE_BUNDLE.getString(KEYCLOAK_IDENTITY_REPLACEMENT_DIALOG_TEXT_LABEL_ID));
            this.validateButton.setText(ViewControllerHelper.RESOURCE_BUNDLE.getString(REPLACE_LABEL_ID));
        } else {
            this.confirmationModalHeaderLabel.setText(ViewControllerHelper.RESOURCE_BUNDLE.getString(KEYCLOAK_ERROR_HEADER_TEXT_LABEL_ID));
            this.modalContentText.setText(ViewControllerHelper.RESOURCE_BUNDLE.getString(KEYCLOAK_IDENTITY_REPLACEMENT_FORBIDDEN_TEXT_ID));
            this.validateButton.setText(ViewControllerHelper.RESOURCE_BUNDLE.getString(VALIDATE_LABEL_ID));
            ViewControllerHelper.hideNode((Node)this.cancelButton);
            this.validateButton.setOnMouseClicked(this::onCancelClicked);
        }
    }

    @Override
    protected void onCancelClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
            this.closeModalDelegate.run();
        }
    }

    @Override
    protected void onValidateClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != MouseButton.PRIMARY) {
            return;
        }
        AsyncTaskExecutor.submitTask(() -> {
            KeycloakCallReturn<Integer> ret = KeycloakManager.getInstance().uploadOwnIdentity(this.bytesOwnedIdentityWithRevocationAllowed.getFirst());
            this.logger.info("DialogKeycloakIdentityReplacement::onValidateClicked upload identity ret :" + String.valueOf(ret));
            if (ret.isSuccess()) {
                this.logger.info("DialogKeycloakIdentityReplacement::onValidateClicked Uploaded identity");
                this.closeModalDelegate.run();
                return;
            }
            switch (ret.getError()) {
                case RFC_AUTHENTICATION_REQUIRED: 
                case RFC_IDENTITY_ALREADY_UPLOADED: {
                    break;
                }
                case RFC_IDENTITY_REVOKED: {
                    KeycloakManager.getInstance().forceSelfTestAndReauthentication(this.bytesOwnedIdentityWithRevocationAllowed.getFirst(), true);
                }
            }
            this.logger.error("DialogKeycloakIdentityReplacement::onValidateClicked Erreur de remplacement de votre ID Olvid pr\u00e9c\u00e9dent");
            this.closeModalDelegate.run();
        });
    }
}

