/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.confirmation.discussion_deletion;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.GroupMemberPermissions;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.engine.helpers.discussion.DiscussionDeletionHelper;
import io.olvid.windows.messenger.engine.helpers.message.MessagePostHelper;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionSelectionModel;
import io.olvid.windows.messenger.fx.modal.confirmation.discussion_deletion.DiscussionDeletionModalController;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.GenericNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscussionDeletionModalModel {
    private static final Logger log = LoggerFactory.getLogger(DiscussionDeletionModalModel.class);
    private AppLogger logger = new AppLogger(DiscussionSelectionModel.class);
    public BooleanProperty loading = new SimpleBooleanProperty(true);
    public BooleanProperty canDeleteEverywhere = new SimpleBooleanProperty(false);
    public Discussion discussion;

    public DiscussionDeletionModalModel(Id<Discussion> discussionId) {
        Objects.requireNonNull(discussionId);
        AsyncTaskExecutor.submitTask(() -> {
            this.discussion = (Discussion)DbManager.getInstance().getDiscussionDao().get(discussionId);
            if (this.discussion.isGroupDiscussion()) {
                GroupMemberPermissions ownPermission = DbManager.getInstance().getGroupMemberPermissionsDao().getOwnPermission(this.discussion.getGroupId().get());
                this.canDeleteEverywhere.set(ownPermission.hasPermissionRemoteDeleteAnything());
            }
            this.loading.set(false);
        });
    }

    public boolean handleDeletion(DiscussionDeletionModalController.DeletionMode deletionMode) {
        this.logger.debug("DiscussionDeletionModalModel::handleDeletion handling deletion with mode : %s", new Object[]{deletionMode});
        boolean ret = false;
        switch (deletionMode) {
            case LOCAL: {
                ret = DiscussionDeletionHelper.deleteDiscussionLocallyDbTask((Id<Discussion>)this.discussion.getItemId());
                break;
            }
            case ONLY_OWNED_DEVICES: 
            case EVERYWHERE: {
                ret = MessagePostHelper.postDeleteDiscussionEverywhereMessageDbTask(this.discussion, deletionMode == DiscussionDeletionModalController.DeletionMode.ONLY_OWNED_DEVICES);
                if (ret) {
                    ret &= DiscussionDeletionHelper.deleteDiscussionLocallyDbTask((Id<Discussion>)this.discussion.getItemId());
                    break;
                }
                this.logger.debug("DiscussionDeletionModalModel::handleDeletion couldn't post delete discussion message");
                return false;
            }
        }
        if (DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().getValue() != null && ((Id)DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().getValue().getItemId()).equals(this.discussion.getItemId())) {
            NCRegistry.getUIActionNC().postNotification(GenericNotification.of(UIActionNC.UserInteractionNotificationEnumType.DISCUSSION_SELECTED, null));
        }
        return ret;
    }
}

