/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.confirmation;

import io.olvid.windows.messenger.fx.custom_components.loader.RingProgressIndicator;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public abstract class ConfirmationModalController
extends BaseModalController {
    private static double BUTTON_HEIGHT = 55.0;
    protected final VBox confirmationModalContainer = new VBox();
    protected final VBox contextualTextVbox = new VBox();
    protected final Label confirmationModalHeaderLabel = new Label();
    protected final Text modalContentText = new Text();
    protected final HBox buttonsHbox = new HBox();
    protected final Button validateButton = new Button();
    protected final Button cancelButton = new Button();
    protected DoubleBinding contentTextWidthBinding;
    protected final RingProgressIndicator ringProgressIndicator = new RingProgressIndicator();
    protected final StackPane ringContainer = new StackPane();
    protected final StackPane validateButtonOrSpinner = new StackPane();

    public ConfirmationModalController() {
        this.confirmationModalContainer.setAlignment(Pos.CENTER);
        this.confirmationModalContainer.getStylesheets().add((Object)"fx/modal/confirmation/confirmation_modal.css");
        this.confirmationModalContainer.getStylesheets().add((Object)"fx/modal/modal.css");
        this.confirmationModalHeaderLabel.setAlignment(Pos.CENTER);
        this.confirmationModalHeaderLabel.setTextAlignment(TextAlignment.CENTER);
        this.confirmationModalHeaderLabel.getStyleClass().add((Object)"h1");
        this.modalContentText.setTextAlignment(TextAlignment.CENTER);
        this.modalContentText.getStyleClass().add((Object)"text-area");
        this.cancelButton.getStyleClass().add((Object)"secondary-button");
        this.cancelButton.setText(ViewControllerHelper.getString("cancel"));
        this.cancelButton.setPrefHeight(BUTTON_HEIGHT);
        this.cancelButton.setMaxHeight(BUTTON_HEIGHT);
        this.cancelButton.setMinHeight(BUTTON_HEIGHT);
        this.validateButton.getStyleClass().add((Object)"primary-button");
        this.validateButton.setPrefHeight(BUTTON_HEIGHT);
        this.validateButton.setMaxHeight(BUTTON_HEIGHT);
        this.validateButton.setMinHeight(BUTTON_HEIGHT);
        this.ringProgressIndicator.getStyleClass().setAll((Object[])new String[]{"sync-progress-indicator", "indeterminate"});
        this.ringProgressIndicator.setProgress(-1);
        this.ringProgressIndicator.setInnerCircleRadius(8);
        this.ringProgressIndicator.setRingWidth(2);
        this.ringContainer.getChildren().add((Object)this.ringProgressIndicator);
        this.ringContainer.setAlignment(Pos.CENTER);
        this.validateButtonOrSpinner.getChildren().addAll((Object[])new Node[]{this.validateButton, this.ringContainer});
        Region sep = new Region();
        this.buttonsHbox.getStyleClass().add((Object)"button-container");
        this.buttonsHbox.getChildren().addAll((Object[])new Node[]{this.cancelButton, sep, this.validateButtonOrSpinner});
        HBox.setHgrow((Node)sep, (Priority)Priority.ALWAYS);
        this.contextualTextVbox.setAlignment(Pos.CENTER);
        this.contextualTextVbox.setSpacing(12.0);
        this.contextualTextVbox.getStyleClass().add((Object)"modal-contextual-background");
        this.contextualTextVbox.setPadding(new Insets(12.0, 12.0, 12.0, 12.0));
        this.contextualTextVbox.getChildren().addAll((Object[])new Node[]{this.confirmationModalHeaderLabel, this.modalContentText, this.buttonsHbox});
        this.confirmationModalContainer.getChildren().add((Object)this.contextualTextVbox);
        this.setSize(ModalConfiguration.ModalSize.BIG);
        this.initialize();
    }

    public void initialize() {
        this.contentTextWidthBinding = Bindings.createDoubleBinding(() -> this.getModalWidth().get() * 0.75, (Observable[])new Observable[]{this.getModalWidth()});
        this.modalContentText.setWrappingWidth(this.getModalWidth().get() * 0.75);
        this.modalContentText.wrappingWidthProperty().bind((ObservableValue)this.contentTextWidthBinding);
        this.validateButton.setOnMouseClicked(this::onValidateClicked);
        this.cancelButton.setOnMouseClicked(this::onCancelClicked);
        ViewControllerHelper.hideNode((Node)this.ringContainer);
    }

    protected void onCancelClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
            this.closeModalDelegate.run();
        }
    }

    protected abstract void onValidateClicked(MouseEvent var1);

    @Override
    public Region getLayout() {
        return this.confirmationModalContainer;
    }
}

