/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.attachmentsViewer;

import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.attachmentsViewer.AttachmentsViewerModalController;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.NumberBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;

public class AttachmentView
extends Pane {
    public final ImageView imageView;
    private final SimpleDoubleProperty imageHeight = new SimpleDoubleProperty();
    private final SimpleDoubleProperty imageWidth = new SimpleDoubleProperty();
    private DoubleBinding imageHeightExternalBinding;
    private DoubleBinding imageWidthExternalBinding;

    public AttachmentView(Pane image_container) {
        this.imageView = new ImageView();
        this.imageView.setSmooth(true);
        this.imageView.setPreserveRatio(true);
        this.setPrefHeight(0.0);
        this.setPrefWidth(0.0);
        this.setMaxHeight(0.0);
        this.setMaxWidth(0.0);
        this.getChildren().add((Object)this.imageView);
        BooleanBinding isRotated90 = this.attachmentRotateProperty().isEqualTo(90);
        BooleanBinding isRotated270 = this.attachmentRotateProperty().isEqualTo(270);
        BooleanBinding isRotated = Bindings.or((ObservableBooleanValue)isRotated90, (ObservableBooleanValue)isRotated270);
        NumberBinding attachmentHeightProperty = Bindings.when((ObservableBooleanValue)isRotated).then((ObservableNumberValue)image_container.widthProperty()).otherwise((ObservableNumberValue)image_container.heightProperty());
        NumberBinding attachmentWidthProperty = Bindings.when((ObservableBooleanValue)isRotated).then((ObservableNumberValue)image_container.heightProperty()).otherwise((ObservableNumberValue)image_container.widthProperty());
        this.initSizeExternalBindings();
        this.imageView.fitHeightProperty().bind((ObservableValue)attachmentHeightProperty);
        this.imageView.fitWidthProperty().bind((ObservableValue)attachmentWidthProperty);
        this.imageHeight.bind((ObservableValue)Bindings.createDoubleBinding(() -> {
            if (this.imageView.getImage() == null) {
                return 0.0;
            }
            double aspectRatio = this.imageView.getImage().getWidth() / this.imageView.getImage().getHeight();
            return Math.min(this.imageView.getFitHeight(), this.imageView.getFitWidth() / aspectRatio);
        }, (Observable[])new Observable[]{this.imageView.fitHeightProperty(), this.imageView.fitWidthProperty(), this.imageView.imageProperty()}));
        this.imageWidth.bind((ObservableValue)Bindings.createDoubleBinding(() -> {
            if (this.imageView.getImage() == null) {
                return 0.0;
            }
            double aspectRatio = this.imageView.getImage().getWidth() / this.imageView.getImage().getHeight();
            return Math.min(this.imageView.getFitWidth(), this.imageView.getFitHeight() * aspectRatio);
        }, (Observable[])new Observable[]{this.imageView.fitHeightProperty(), this.imageView.fitWidthProperty(), this.imageView.imageProperty()}));
        this.imageView.translateXProperty().bind((ObservableValue)this.imageWidth.divide(2).multiply(-1));
        this.imageView.translateYProperty().bind((ObservableValue)this.imageHeight.divide(2).multiply(-1));
    }

    private void initSizeExternalBindings() {
        this.imageHeightExternalBinding = Bindings.createDoubleBinding(() -> ((Bounds)this.imageView.boundsInParentProperty().get()).getHeight(), (Observable[])new Observable[]{this.imageView.boundsInParentProperty()});
        this.imageWidthExternalBinding = Bindings.createDoubleBinding(() -> ((Bounds)this.imageView.boundsInParentProperty().get()).getWidth(), (Observable[])new Observable[]{this.imageView.boundsInParentProperty()});
    }

    public DoubleProperty attachmentRotateProperty() {
        return this.imageView.rotateProperty();
    }

    public void configureImage(AttachmentsViewerModalController.ImageConfiguration imageConfiguration) {
        this.updateViewToShow(Kind.image);
        this.imageView.setImage(imageConfiguration.image());
        if (imageConfiguration.orientation().isPresent()) {
            this.imageView.setRotate((double)imageConfiguration.orientation().get().rotation());
        } else {
            this.imageView.setRotate(0.0);
        }
        if (imageConfiguration.isDefault()) {
            this.imageView.setScaleX(0.15);
            this.imageView.setScaleY(0.15);
        } else {
            this.imageView.setScaleX(1.0);
            this.imageView.setScaleY(1.0);
        }
    }

    private void updateViewToShow(Kind kind) {
        switch (kind.ordinal()) {
            case 0: {
                ViewControllerHelper.showNode((Node)this.imageView);
            }
        }
    }

    public DoubleBinding imageHeightProperty() {
        return this.imageHeightExternalBinding;
    }

    public DoubleBinding imageWidthProperty() {
        return this.imageWidthExternalBinding;
    }

    private static enum Kind {
        image;

    }
}

