/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal;

import io.olvid.windows.messenger.fx.custom_components.custom_controls.popup.CustomPopup;
import io.olvid.windows.messenger.fx.custom_components.layers.LayerAnchorPane;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.SizeObserver;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.MainStackManager;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationType;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import java.net.URL;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

@FXMLView(path="fx/modal/basic_modal_model.fxml")
public class ModalLayerController
extends BaseViewController {
    public static final Duration MODAL_FADE_DURATION = Duration.millis((double)150.0);
    @FXML
    LayerAnchorPane modal_anchor;
    @FXML
    StackPane modal_container_stack;
    @FXML
    StackPane modal_background_anchor;
    @FXML
    StackPane stacked_modal_background_anchor;
    private final ModalConfiguration configuration;
    private final Deque<BaseModalController> stackedModalControllers = new LinkedList<BaseModalController>();
    final NotificationListener<? extends NotificationType> notificationListener = this::modalNotificationListener;
    static NotificationType.NotificationEnumType[] subscribedUIActionNotificationsTypes = new NotificationType.NotificationEnumType[]{UIActionNC.UserInteractionNotificationEnumType.OPEN_MODAL};
    private ParallelTransition appearsTransition;
    private ParallelTransition disappearsTransition;

    public ModalLayerController() {
        this.configuration = new ModalConfiguration();
        this.loadFxml();
        NCRegistry.getUIActionNC().subscribe(subscribedUIActionNotificationsTypes, this.notificationListener);
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.createTransition();
        this.initBlurEffect();
        this.stacked_modal_background_anchor.setPickOnBounds(true);
        if (this.configuration.exitLevel == ModalConfiguration.ExitLevel.OUTSIDE) {
            this.stacked_modal_background_anchor.setOnMouseClicked(event -> {
                if (event.getTarget() == this.stacked_modal_background_anchor) {
                    this.closeModalDelegate(false, true);
                }
            });
        }
        if (this.configuration.transparent) {
            this.modal_anchor.setStyle("-fx-background-color: #00000000");
        }
    }

    private void initBlurEffect() {
        this.modal_anchor.visibleProperty().addListener((observable, oldValue, newVisibility) -> {
            if (this.modal_anchor.getParent() != null && newVisibility.booleanValue()) {
                this.appearsTransition.play();
            }
        });
    }

    private void createTransition() {
        FadeTransition appearsBackgroundFadeTransition = new FadeTransition(MODAL_FADE_DURATION);
        appearsBackgroundFadeTransition.setNode((Node)this.modal_container_stack);
        appearsBackgroundFadeTransition.setFromValue(0.2);
        appearsBackgroundFadeTransition.setToValue(1.0);
        FadeTransition appearsModalFadeTransition = new FadeTransition(MODAL_FADE_DURATION);
        appearsModalFadeTransition.setNode((Node)this.modal_anchor);
        appearsModalFadeTransition.setFromValue(0.2);
        appearsModalFadeTransition.setToValue(1.0);
        this.appearsTransition = new ParallelTransition(new Animation[]{appearsBackgroundFadeTransition, appearsModalFadeTransition});
        FadeTransition disappearsBackgroundFadeTransition = new FadeTransition(MODAL_FADE_DURATION);
        disappearsBackgroundFadeTransition.setNode((Node)this.modal_container_stack);
        disappearsBackgroundFadeTransition.setFromValue(1.0);
        disappearsBackgroundFadeTransition.setToValue(0.0);
        FadeTransition disappearsModalFadeTransition = new FadeTransition(MODAL_FADE_DURATION);
        disappearsModalFadeTransition.setNode((Node)this.modal_anchor);
        disappearsModalFadeTransition.setFromValue(1.0);
        disappearsModalFadeTransition.setToValue(0.0);
        this.disappearsTransition = new ParallelTransition(new Animation[]{disappearsBackgroundFadeTransition, disappearsModalFadeTransition});
    }

    @Override
    public Region getLayout() {
        return this.modal_anchor;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }

    public ModalConfiguration.ModalSize getSize() {
        return this.configuration.size;
    }

    private void bindModalSize(BaseModalController modalController) {
        AppLogger.d("ModalLayerController::bind");
        Region region = modalController.getLayout();
        if (region instanceof Pane) {
            Pane pane = (Pane)region;
            switch (modalController.getSize()) {
                case SELF_SIZE: {
                    break;
                }
                case BIG: {
                    pane.maxHeightProperty().bind((ObservableValue)SizeObserver.getBigModalHeight());
                    pane.maxWidthProperty().bind((ObservableValue)SizeObserver.getBigModalWidth());
                    break;
                }
                case MEDIUM: {
                    pane.maxHeightProperty().bind((ObservableValue)SizeObserver.getMediumModalHeight());
                    pane.maxWidthProperty().bind((ObservableValue)SizeObserver.getMediumModalWidth());
                    break;
                }
                case SMALL: {
                    pane.maxHeightProperty().bind((ObservableValue)SizeObserver.getSmallModalHeight());
                    pane.maxWidthProperty().bind((ObservableValue)SizeObserver.getSmallModalWidth());
                }
            }
        }
    }

    private void unbind(BaseModalController modalController) {
        AppLogger.d("ModalLayerController::unbind");
        Region region = modalController.getLayout();
        if (region instanceof Pane) {
            Pane pane = (Pane)region;
            switch (modalController.getSize()) {
                case BIG: 
                case MEDIUM: 
                case SMALL: {
                    pane.maxHeightProperty().unbind();
                    pane.maxWidthProperty().unbind();
                }
            }
        }
    }

    private void modalNotificationListener(NotificationType notification) {
        this.logger.info("modalNotificationListener received new modal notification : " + String.valueOf(notification.getNotificationType()));
        ViewControllerHelper.smartUIUpdate(() -> {
            if (CustomPopup.getCurrentPopUpRef() != null) {
                CustomPopup.getCurrentPopUpRef().hide();
            }
            boolean clearStack = false;
            if (notification.getNotificationType() != UIActionNC.UserInteractionNotificationEnumType.OPEN_MODAL) return;
            if (!(notification instanceof ModalNotification)) return;
            ModalNotification modalNotification = (ModalNotification)notification;
            BaseModalController controller = (BaseModalController)modalNotification.getIncomingValue();
            if (controller == null) {
                return;
            }
            BaseModalController modalController = controller;
            clearStack = modalNotification.clearStack;
            Objects.requireNonNull(modalController);
            this.logger.debug("ModalLayerController::modalNotificationListener modal controller not null");
            boolean finalClearStack = clearStack;
            modalController.setCloseModalDelegate(() -> this.closeModalDelegate(finalClearStack, false));
            this.bindModalSize(modalController);
            Optional<BaseModalController> modalWithSameId = this.stackedModalControllers.stream().filter(stackedModalController -> stackedModalController.getClass().equals(modalController.getClass())).findFirst();
            if (modalWithSameId.isPresent()) {
                this.logger.debug("ModalLayerController::modalNotificationListener Duplicated modal type with clzz --> %s", modalWithSameId.getClass());
                modalController.onLayoutDetached();
                return;
            }
            if (this.modal_container_stack.getChildren().contains((Object)modalController.getLayout())) return;
            if (this.modal_container_stack.getChildren().size() > 2) {
                int stackedModalBackgroundIndex = this.modal_container_stack.getChildren().lastIndexOf((Object)this.stacked_modal_background_anchor);
                int stackedModalIndex = this.modal_container_stack.getChildren().lastIndexOf((Object)this.stackedModalControllers.getLast().getLayout());
                this.modal_container_stack.getChildren().remove(stackedModalBackgroundIndex);
                this.modal_container_stack.getChildren().add(stackedModalIndex, (Object)this.stacked_modal_background_anchor);
            }
            if (modalController.getCloseKeyEventHandler().isPresent()) {
                this.modal_container_stack.getScene().setOnKeyPressed(modalController.getCloseKeyEventHandler().get());
            }
            this.modal_container_stack.getChildren().add((Object)modalController.getLayout());
            modalController.getLayout().requestFocus();
            this.stackedModalControllers.add(modalController);
            MainStackManager.displayedLayerState.pushState(MainStackManager.DisplayedLayerWrapper.of(MainStackManager.DisplayedLayer.MODAL));
            this.logger.debug("ModalLayerController::modalNotificationListener new modal displayed");
        });
    }

    protected void closeModalDelegate(boolean clearStack, boolean attemptToClose) {
        AppLogger.t("ModalLayerController::closeModal");
        ViewControllerHelper.smartUIUpdate(() -> {
            BaseViewController modalControllerToDestroy;
            if (this.stackedModalControllers.isEmpty()) {
                modalControllerToDestroy = null;
            } else if (this.stackedModalControllers.getLast() != null) {
                if (attemptToClose) {
                    this.stackedModalControllers.getLast().attemptClose();
                    return;
                }
                modalControllerToDestroy = this.stackedModalControllers.removeLast();
            } else {
                modalControllerToDestroy = null;
            }
            if (modalControllerToDestroy != null) {
                this.modal_container_stack.getChildren().remove((Object)modalControllerToDestroy.getLayout());
                ((BaseModalController)modalControllerToDestroy).onLayoutDetached();
                this.unbind((BaseModalController)modalControllerToDestroy);
                if (this.stackedModalControllers.isEmpty()) {
                    if (((BaseModalController)modalControllerToDestroy).getCloseKeyEventHandler().isPresent()) {
                        this.modal_container_stack.getScene().setOnKeyPressed(null);
                    }
                    this.disappearsTransition.setOnFinished(event -> {
                        MainStackManager.displayedLayerState.pushState(MainStackManager.DisplayedLayerWrapper.of(MainStackManager.DisplayedLayer.CLOSE_MODAL));
                        this.disappearsTransition.setOnFinished(null);
                    });
                    this.disappearsTransition.play();
                } else if (clearStack) {
                    this.closeModalDelegate(clearStack, false);
                } else {
                    BaseModalController formerController = this.stackedModalControllers.getLast();
                    if (formerController.getCloseKeyEventHandler().isPresent()) {
                        this.modal_container_stack.getScene().setOnKeyPressed(formerController.getCloseKeyEventHandler().get());
                    }
                    int indexFormerNode = this.modal_container_stack.getChildren().lastIndexOf((Object)this.stackedModalControllers.getLast().getLayout());
                    if (this.modal_container_stack.getChildren().size() > 2) {
                        this.modal_container_stack.getChildren().remove((Object)this.stacked_modal_background_anchor);
                        this.modal_container_stack.getChildren().add(indexFormerNode, (Object)this.stacked_modal_background_anchor);
                    }
                }
            }
        });
    }

    public boolean hasQueuedModals() {
        return !this.stackedModalControllers.isEmpty();
    }
}

