/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal;

import io.olvid.windows.messenger.fx.framework.utils.FxIcons;
import io.olvid.windows.messenger.fx.framework.view_controller.CloseGuard;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.modal.confirmation.ConfirmModalController;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import java.util.List;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public abstract class CloseableModalController
extends BaseModalController {
    protected Runnable closeModalDelegate;

    @Override
    protected abstract CloseGuard getActiveCloseGuard();

    @Override
    public void setCloseModalDelegate(Runnable delegate) {
        this.closeModalDelegate = delegate;
    }

    @Override
    public Runnable getCloseModalDelegate() {
        return this.closeModalDelegate;
    }

    @Override
    protected final void attemptClose() {
        CloseGuard guard = this.getActiveCloseGuard();
        if (guard != null && guard.hasChangesProperty().get()) {
            this.confirmUnsavedChanges(guard, () -> {
                if (this.closeModalDelegate != null) {
                    this.closeModalDelegate.run();
                }
            }, () -> {});
        } else if (this.closeModalDelegate != null) {
            this.closeModalDelegate.run();
        }
    }

    public void confirmUnsavedChanges(CloseGuard guard, Runnable onProceed, Runnable onCancel) {
        ConfirmModalController confirm = new ConfirmModalController(475.0);
        String title = guard.unsavedWarningTitle();
        String desc = guard.unsavedWarningText();
        List<ConfirmModalController.ConfirmationAction> actions = List.of(ConfirmModalController.ConfirmationAction.of(ViewControllerHelper.getString("modal_unsaved_changes_save_button"), List.of("button-outline"), () -> {
            guard.saveChangesSilently();
            onProceed.run();
        }).asDefault(), ConfirmModalController.ConfirmationAction.of(ViewControllerHelper.getString("modal_unsaved_changes_discard_button"), List.of("button-outline", "button-outline-danger"), () -> {
            guard.discardChangesSilently();
            onProceed.run();
        }), ConfirmModalController.ConfirmationAction.of(ViewControllerHelper.getString("modal.cancel"), List.of("button-outline"), onCancel).asCancel());
        confirm.configure(title, desc, FxIcons.icon(FxIcons.TRASH((Paint)Color.RED, null), 20.0, 20.0), actions);
        confirm.setBadgeKind(ConfirmModalController.BadgeKind.DANGER);
        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(confirm, false));
    }
}

