/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc.richtextfx.utils;

import io.olvid.windows.messenger.fx.misc.richtextfx.RichStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.style.ParagraphStyle;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.BlocksInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.List;
import java.util.function.IntFunction;
import javafx.beans.value.ObservableValue;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;

public class ParagraphGraphicFactory
implements IntFunction<Node> {
    public static final AppLogger logger = new AppLogger(RichStyledArea.class);
    private final RichStyledArea area;
    private static final double width = 15.0;

    public ParagraphGraphicFactory(RichStyledArea area) {
        this.area = area;
    }

    @Override
    public Node apply(int paragraphIndex) {
        switch (this.area.configuration.processDelimiter()) {
            case NONE: 
            case STYLE: {
                return null;
            }
        }
        BlocksInfo blockInfo = new BlocksInfo(this.area);
        List<BlocksInfo.Info> infos = blockInfo.getBlockInfos(paragraphIndex);
        if (infos.isEmpty()) {
            return null;
        }
        HBox hBox = new HBox();
        for (BlocksInfo.Info info : infos) {
            Node node;
            if (info.block() instanceof ParagraphStyle.Quote) {
                Node quote = this.createQuote((Node)hBox);
                hBox.getChildren().add((Object)quote);
                continue;
            }
            if (info instanceof BlocksInfo.BulletInfo) {
                BlocksInfo.BulletInfo bulletInfo = (BlocksInfo.BulletInfo)info;
                node = this.createBullet(bulletInfo.level(), bulletInfo.first());
                hBox.getChildren().add((Object)this.alignedNode(node));
                continue;
            }
            if (!(info instanceof BlocksInfo.OrdinalInfo)) continue;
            BlocksInfo.OrdinalInfo ordinalInfo = (BlocksInfo.OrdinalInfo)info;
            node = this.createOrdinal(ordinalInfo.index(), ordinalInfo.first());
            hBox.getChildren().add((Object)this.alignedNode(node));
        }
        double top = 0.0;
        double bottom = 0.0;
        if (blockInfo.addTopPadding(paragraphIndex)) {
            top += 8.0;
        }
        if (blockInfo.addBottomPadding(paragraphIndex)) {
            bottom += 8.0;
        }
        hBox.setPadding(new Insets(top, 15.0, bottom, 0.0));
        return hBox;
    }

    private VBox alignedNode(Node node) {
        Label label = new Label();
        label.setGraphic(node);
        VBox.setVgrow((Node)node, (Priority)Priority.ALWAYS);
        VBox vBox = new VBox(0.0, new Node[]{label});
        return vBox;
    }

    private Node createBullet(int level, boolean isVisible) {
        Circle shape;
        StackPane stackPane = new StackPane();
        SimpleStyleableObjectProperty<Paint> textFillProperty = this.area.textFillProperty;
        switch (level) {
            case 1: {
                shape = new Circle(2.5);
                shape.fillProperty().bind(textFillProperty);
                shape.strokeProperty().bind(textFillProperty);
                break;
            }
            case 2: {
                shape = new Circle(2.5);
                shape.setFill((Paint)Color.TRANSPARENT);
                shape.strokeProperty().bind(textFillProperty);
                break;
            }
            default: {
                shape = new Rectangle(5.0, 5.0);
                shape.fillProperty().bind(textFillProperty);
                shape.strokeProperty().bind(textFillProperty);
            }
        }
        shape.setVisible(isVisible);
        stackPane.getChildren().add((Object)shape);
        stackPane.setPrefWidth(15.0);
        return stackPane;
    }

    private Node createOrdinal(int index, boolean isVisible) {
        StackPane stackPane = new StackPane();
        SimpleStyleableObjectProperty<Paint> textFillProperty = this.area.textFillProperty;
        Text shape = new Text(String.format("%d.", index));
        shape.fillProperty().bind(textFillProperty);
        shape.setVisible(isVisible);
        stackPane.getChildren().add((Object)shape);
        stackPane.setPrefWidth(15.0);
        return stackPane;
    }

    private Node createQuote(Node parent) {
        StackPane stackPane = new StackPane();
        Rectangle rectangle = new Rectangle(2.0, 0.0);
        rectangle.setHeight(Double.MAX_VALUE);
        rectangle.setArcHeight(1.0);
        rectangle.setArcWidth(1.0);
        SimpleStyleableObjectProperty<Paint> quoteBarFillProperty = this.area.quoteBarFillProperty;
        rectangle.fillProperty().bind(quoteBarFillProperty);
        parent.parentProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue instanceof Region) {
                Region region = (Region)newValue;
                rectangle.heightProperty().bind((ObservableValue)region.heightProperty());
            }
        });
        stackPane.getChildren().add((Object)rectangle);
        stackPane.setPrefWidth(15.0);
        return stackPane;
    }
}

