/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc.richtextfx.utils;

import io.olvid.windows.messenger.fx.misc.richtextfx.RichStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.style.ParagraphStyle;
import io.olvid.windows.messenger.fx.misc.richtextfx.style.SegmentStyle;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.RichStyledConfiguration;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.PositionsMapping;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javafx.scene.control.IndexRange;
import org.commonmark.node.SourceSpan;
import org.fxmisc.richtext.MultiChangeBuilder;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.StyleSpan;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.TwoDimensional;
import org.reactfx.util.Either;

public class MarkdownChangeBuilder {
    private static final AppLogger logger = new AppLogger(MarkdownChangeBuilder.class);
    private final PositionsMapping positions;
    public final RichStyledArea area;
    private final MultiChangeBuilder<ParagraphStyle, Either<String, CharSequence>, SegmentStyle> changeBuilder;
    private boolean hasStyles = false;
    private boolean hasLinks = false;
    private final Map<Integer, BitSet> paragraphModifications = new HashMap<Integer, BitSet>();
    private final Map<Integer, List<ParagraphStyle.BlockStyle>> paragraphBlocks = new HashMap<Integer, List<ParagraphStyle.BlockStyle>>();
    private final Set<Integer> codeDelimiter = new HashSet<Integer>();
    private final Map<Integer, ParagraphStyle.Heading> headings = new HashMap<Integer, ParagraphStyle.Heading>();
    private final RichStyledConfiguration configuration;

    public MarkdownChangeBuilder(RichStyledArea area) {
        this.configuration = area.configuration;
        this.positions = new PositionsMapping(area.getPlainText(), EnumSet.of(PositionsMapping.Kind.EmojiAndNewlines));
        this.area = area;
        this.changeBuilder = area.createMultiChange();
        for (int p = 0; p < area.getParagraphs().size(); ++p) {
            int len = area.getParagraphLength(p);
            BitSet bitSet = new BitSet(len);
            bitSet.set(0, len);
            this.paragraphModifications.put(p, bitSet);
        }
    }

    public RichStyledConfiguration getConfiguration() {
        return this.configuration;
    }

    private int correctedStart(int start) {
        return this.positions.getIndex(start, true);
    }

    private int correctedEnd(int end) {
        return this.positions.getIndex(end, false);
    }

    private MarkdownChangeBuilder addStyle(Range range, Optional<SegmentStyle.Style> styles, Optional<String> url) {
        this.area.addStyle(range.start(this), range.end(this), styles, url);
        this.hasStyles = true;
        return this;
    }

    public MarkdownChangeBuilder addUrl(Range range, String url) {
        if (this.configuration.processDelimiter() == RichStyledConfiguration.DelimiterProcessing.TOGGLEABLE) {
            if (((ParagraphStyle)this.area.getParagraph(range.paragraph(this)).getParagraphStyle()).isCode()) {
                return this;
            }
            StyleSpans styleSpans = this.area.getDocument().getStyleSpans(range.start(this), range.end(this));
            if (styleSpans.getSpanCount() != 1) {
                return this;
            }
            StyleSpan styleSpan = styleSpans.getStyleSpan(0);
            if (((SegmentStyle)styleSpan.getStyle()).contains(SegmentStyle.Style.InlineCode.class)) {
                return this;
            }
        }
        if (this.configuration.applyStyle() || this.configuration.enableLinkDetection()) {
            Optional<String> urlOpt = this.configuration.clickableLinks() ? Optional.of(url) : Optional.empty();
            this.addStyle(range, Optional.of(new SegmentStyle.Style.Underline()), urlOpt);
        }
        if (this.configuration.enableLinkDetection() && !this.hasLinks) {
            this.hasLinks = true;
            this.configuration.linkFound(Optional.of(url));
        }
        return this;
    }

    public MarkdownChangeBuilder addStyle(Optional<SegmentStyle.Style> styles, Range range) {
        if (!this.configuration.applyStyle()) {
            return this;
        }
        return this.addStyle(range, styles, Optional.empty());
    }

    public MarkdownChangeBuilder addCodeBlockStyle(Range range) {
        if (!this.configuration.applyBlockCodeStyle()) {
            return this;
        }
        return this.addStyle(range, Optional.of(new SegmentStyle.Style.BlockCode()), Optional.empty());
    }

    public MarkdownChangeBuilder addDelimiterStyle(Range range, DelimiterType type) {
        if (!this.configuration.applyStyle()) {
            return this;
        }
        SegmentStyle.Style style = type.toStyle();
        return this.addStyle(range, Optional.of(style), Optional.empty());
    }

    private boolean hasModificationText(int paragraph, int startColumn, int endColumn) {
        BitSet modifications = this.paragraphModifications.get(paragraph);
        if (modifications == null) {
            return true;
        }
        BitSet bitSet = modifications.get(startColumn, endColumn);
        return bitSet.cardinality() != endColumn - startColumn;
    }

    private void deleteText(Range range) {
        int lineStart = range.lineStart(this);
        int start = range.start(this);
        int end = range.end(this);
        int paragraph = range.paragraph(this);
        if (start == end) {
            return;
        }
        this.changeBuilder.deleteText(start, end);
        int startColumn = start - lineStart;
        int endColumn = end - lineStart;
        BitSet modifications = this.paragraphModifications.get(paragraph);
        if (modifications == null) {
            logger.error("Try to remove text from a paragraph that has been deleted");
            return;
        }
        if (this.hasModificationText(paragraph, startColumn, endColumn)) {
            logger.error("Try to remove text twice");
            return;
        }
        modifications.clear(startColumn, endColumn);
    }

    public MarkdownChangeBuilder processDelimiter(Range range, DelimiterType type) {
        RichStyledConfiguration.DelimiterProcessing delimiterProcessing = this.configuration.processDelimiter();
        switch (delimiterProcessing) {
            case NONE: 
            case TOGGLEABLE: {
                break;
            }
            case DELETE_AND_RICH_REPLACE: {
                this.deleteText(range);
                break;
            }
            case STYLE: {
                this.addDelimiterStyle(range, type);
            }
        }
        return this;
    }

    public MarkdownChangeBuilder addParagraphBlock(int paragraph, ParagraphStyle.BlockStyle blockStyle) {
        switch (this.configuration.processDelimiter()) {
            case NONE: 
            case TOGGLEABLE: {
                break;
            }
            case DELETE_AND_RICH_REPLACE: 
            case STYLE: {
                this.paragraphBlocks.computeIfAbsent(paragraph, p -> new ArrayList()).add(0, blockStyle);
                this.hasStyles = true;
            }
        }
        return this;
    }

    public MarkdownChangeBuilder addHeading(int paragraph, ParagraphStyle.Heading heading) {
        switch (this.configuration.processDelimiter()) {
            case NONE: 
            case TOGGLEABLE: {
                break;
            }
            case DELETE_AND_RICH_REPLACE: 
            case STYLE: {
                this.headings.put(paragraph, heading);
                this.hasStyles = true;
            }
        }
        return this;
    }

    public MarkdownChangeBuilder addCodeDelimiter(int paragraph) {
        this.codeDelimiter.add(paragraph);
        this.hasStyles = true;
        return this;
    }

    private int correctedParagraph(int paragraph) {
        int p = paragraph;
        for (int i = 0; i < paragraph; ++i) {
            if (this.paragraphModifications.containsKey(i)) continue;
            --p;
        }
        return p;
    }

    private boolean removeEmptyParagraph(int paragraph) {
        boolean hasCodeDelimiter = this.codeDelimiter.contains(paragraph);
        if (hasCodeDelimiter) {
            return true;
        }
        List<ParagraphStyle.BlockStyle> blockStyles = this.paragraphBlocks.get(paragraph);
        if (blockStyles == null) {
            return false;
        }
        boolean hasCode = false;
        boolean hasItem = false;
        boolean hasQuote = false;
        for (ParagraphStyle.BlockStyle blockStyle : blockStyles) {
            hasItem |= blockStyle instanceof ParagraphStyle.Ordinal || blockStyle instanceof ParagraphStyle.Bullet;
            hasCode |= blockStyle instanceof ParagraphStyle.Code;
            hasQuote |= blockStyle instanceof ParagraphStyle.Quote;
        }
        if (hasCode) {
            return false;
        }
        if (hasQuote) {
            return false;
        }
        return !hasItem;
    }

    private void cleanEmptyParagraphs() {
        for (int paragraph : Set.copyOf(this.paragraphModifications.keySet())) {
            boolean isLast;
            BitSet modifications = this.paragraphModifications.get(paragraph);
            if (modifications.cardinality() != 0 || !this.removeEmptyParagraph(paragraph)) continue;
            this.paragraphModifications.remove(paragraph);
            if (this.paragraphModifications.isEmpty()) continue;
            boolean isFirst = paragraph == 0;
            boolean bl = isLast = paragraph == this.area.getParagraphs().size() - 1;
            if (isFirst && isLast) continue;
            if (isLast) {
                this.changeBuilder.deleteText(paragraph - 1, this.area.getParagraphLength(paragraph - 1), paragraph, 0);
                continue;
            }
            this.changeBuilder.deleteText(paragraph, this.area.getParagraphLength(paragraph), paragraph + 1, 0);
        }
    }

    private void applyParagraphStyles() {
        HashSet<Integer> paragraphs = new HashSet<Integer>();
        paragraphs.addAll(this.paragraphBlocks.keySet());
        paragraphs.addAll(this.codeDelimiter);
        paragraphs.addAll(this.headings.keySet());
        for (Integer idx : paragraphs) {
            ParagraphStyle.Heading heading;
            int paragraphIndex;
            if (!this.paragraphModifications.containsKey(idx) || (paragraphIndex = this.correctedParagraph(idx)) >= this.area.getParagraphs().size()) continue;
            Paragraph p = this.area.getParagraph(paragraphIndex);
            ParagraphStyle paragraphStyle = (ParagraphStyle)p.getParagraphStyle();
            List<ParagraphStyle.BlockStyle> blockStyles = this.paragraphBlocks.get(idx);
            if (blockStyles != null) {
                paragraphStyle = paragraphStyle.addBlocks(blockStyles);
            }
            if ((heading = this.headings.get(idx)) != null) {
                paragraphStyle = paragraphStyle.setHeading(Optional.of(heading));
            }
            if (this.codeDelimiter.contains(idx)) {
                paragraphStyle = paragraphStyle.setCodeDelimiter(true);
            }
            this.area.setParagraphStyle(paragraphIndex, paragraphStyle);
        }
    }

    public void commit() {
        if (this.hasStyles || this.changeBuilder.hasChanges()) {
            if (this.changeBuilder.hasChanges()) {
                this.cleanEmptyParagraphs();
                this.changeBuilder.commit();
            }
            this.applyParagraphStyles();
            this.area.layout();
        }
        if (this.configuration.enableLinkDetection() && !this.hasLinks) {
            this.configuration.linkFound(Optional.empty());
        }
    }

    public String getParagraphText(int paragraph) {
        return this.area.getText(List.of(this.area.getParagraph(paragraph)));
    }

    public static interface Range {
        public int start(MarkdownChangeBuilder var1);

        public int end(MarkdownChangeBuilder var1);

        public int paragraph(MarkdownChangeBuilder var1);

        public int lineStart(MarkdownChangeBuilder var1);

        public static Range absolute(int start, int end) {
            return new Absolute(start, end);
        }

        public static Range relative(int paragraph, int startColumn, int endColumn) {
            return new Relative(paragraph, startColumn, endColumn);
        }

        public static Range of(SourceSpan sourceSpan) {
            return new Relative(sourceSpan.getLineIndex(), sourceSpan.getColumnIndex(), sourceSpan.getColumnIndex() + sourceSpan.getLength());
        }

        public static Range of(IndexRange indexRange) {
            return Range.absolute(indexRange.getStart(), indexRange.getEnd());
        }

        public static class Absolute
        implements Range {
            private final int start;
            private final int end;

            public Absolute(int start, int end) {
                this.start = start;
                this.end = end;
            }

            @Override
            public int start(MarkdownChangeBuilder builder) {
                return builder.correctedStart(this.start);
            }

            @Override
            public int end(MarkdownChangeBuilder builder) {
                return builder.correctedEnd(this.end);
            }

            @Override
            public int paragraph(MarkdownChangeBuilder builder) {
                return builder.area.offsetToPosition(this.start, TwoDimensional.Bias.Backward).getMajor();
            }

            @Override
            public int lineStart(MarkdownChangeBuilder builder) {
                int paragraph = this.paragraph(builder);
                int absolute = builder.area.getAbsolutePlainPosition(paragraph, 0);
                return builder.correctedStart(absolute);
            }

            public String toString() {
                return "Absolute{start=" + this.start + ", end=" + this.end + "}";
            }
        }

        public static class Relative
        implements Range {
            private final int paragraph;
            private final int startColumn;
            private final int endColumn;

            public Relative(int paragraph, int startColumn, int endColumn) {
                this.paragraph = paragraph;
                this.startColumn = startColumn;
                this.endColumn = endColumn;
            }

            @Override
            public int start(MarkdownChangeBuilder builder) {
                int absolute = builder.area.getAbsolutePlainPosition(this.paragraph, this.startColumn);
                return builder.correctedStart(absolute);
            }

            @Override
            public int end(MarkdownChangeBuilder builder) {
                int absolute = builder.area.getAbsolutePlainPosition(this.paragraph, this.endColumn);
                return builder.correctedEnd(absolute);
            }

            @Override
            public int paragraph(MarkdownChangeBuilder builder) {
                return this.paragraph;
            }

            @Override
            public int lineStart(MarkdownChangeBuilder builder) {
                int absolute = builder.area.getAbsolutePlainPosition(this.paragraph, 0);
                return builder.correctedStart(absolute);
            }

            public String toString() {
                return "Relative{paragraph=" + this.paragraph + ", startColumn=" + this.startColumn + ", endColumn=" + this.endColumn + "}";
            }
        }
    }

    public static enum DelimiterType {
        OPEN,
        CLOSE,
        NONE;


        SegmentStyle.Style toStyle() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> new SegmentStyle.Style.OpenDelimiter();
                case 1 -> new SegmentStyle.Style.CloseDelimiter();
                case 2 -> new SegmentStyle.Style.Delimiter();
            };
        }
    }
}

