/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc.richtextfx.utils;

import io.olvid.windows.messenger.fx.misc.richtextfx.utils.MarkdownVisitor;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.RichStyledConfiguration;
import org.commonmark.ext.gfm.strikethrough.Strikethrough;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.CustomNode;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.Heading;
import org.commonmark.node.Link;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.nibor.autolink.LinkSpan;
import org.nibor.autolink.Span;

public class HasMarkdownVisitor
extends AbstractVisitor {
    private boolean canHaveMarkdown = false;
    private final RichStyledConfiguration configuration;

    public HasMarkdownVisitor(RichStyledConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean canHaveMarkdown() {
        return this.canHaveMarkdown;
    }

    public void visit(Emphasis emphasis) {
        this.canHaveMarkdown = true;
        super.visit(emphasis);
    }

    public void visit(StrongEmphasis strongEmphasis) {
        this.canHaveMarkdown = true;
        super.visit(strongEmphasis);
    }

    public void visit(CustomNode customNode) {
        if (customNode instanceof Strikethrough) {
            this.canHaveMarkdown = true;
        }
        super.visit(customNode);
    }

    public void visit(Heading heading) {
        this.canHaveMarkdown = true;
        super.visit(heading);
    }

    public void visit(Code code) {
        this.canHaveMarkdown = true;
        super.visit(code);
    }

    public void visit(FencedCodeBlock fencedCodeBlock) {
        this.canHaveMarkdown = true;
        super.visit(fencedCodeBlock);
    }

    public void visit(BlockQuote blockQuote) {
        this.canHaveMarkdown = true;
        super.visit(blockQuote);
    }

    public void visit(OrderedList orderedList) {
        this.canHaveMarkdown = true;
        super.visit(orderedList);
    }

    public void visit(BulletList bulletList) {
        this.canHaveMarkdown = true;
        super.visit(bulletList);
    }

    public void visit(ListItem listItem) {
        this.canHaveMarkdown = true;
        super.visit(listItem);
    }

    private void visitLink(String s) {
        for (Span span : MarkdownVisitor.linkExtractor.extractSpans((CharSequence)s)) {
            if (!(span instanceof LinkSpan)) continue;
            this.canHaveMarkdown = true;
            return;
        }
    }

    private boolean enableLinkDetection() {
        if (this.configuration.enableLinkDetection()) {
            return true;
        }
        return this.configuration.applyStyle();
    }

    public void visit(Text text) {
        if (!this.enableLinkDetection()) {
            return;
        }
        String literal = text.getLiteral();
        this.visitLink(literal);
        super.visit(text);
    }

    public void visit(Link link) {
        if (!this.enableLinkDetection()) {
            return;
        }
        String destination = link.getDestination();
        this.visitLink(destination);
    }

    protected void visitChildren(Node parent) {
        if (this.canHaveMarkdown) {
            return;
        }
        super.visitChildren(parent);
    }
}

