/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc.richtextfx.utils;

import io.olvid.windows.messenger.fx.misc.CollectionUtils;
import io.olvid.windows.messenger.fx.misc.richtextfx.RichStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.style.ParagraphStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.geometry.Insets;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import org.fxmisc.richtext.model.Paragraph;
import org.reactfx.collection.LiveList;

public class BlocksInfo {
    private final RichStyledArea area;
    private final Map<Integer, List<Info>> blockMap = new HashMap<Integer, List<Info>>();

    public BlocksInfo(RichStyledArea area) {
        this.area = area;
        this.computeInfos();
    }

    private void computeInfos() {
        for (int p = 0; p < this.area.getParagraphs().size(); ++p) {
            ParagraphStyle ps = (ParagraphStyle)this.area.getParagraph(p).getParagraphStyle();
            ArrayList<Record> infos = new ArrayList<Record>();
            for (int b = 0; b < ps.blocks.size(); ++b) {
                Optional<Record> previousSibling;
                ParagraphStyle.BlockStyle block = ps.blocks.get(b);
                if (block instanceof ParagraphStyle.Ordinal) {
                    ParagraphStyle.Ordinal ordinal = (ParagraphStyle.Ordinal)block;
                    OrdinalInfo ordinalInfo = this.getOrdinalInfo(p, b, ordinal);
                    infos.add(ordinalInfo);
                    continue;
                }
                if (block instanceof ParagraphStyle.Bullet) {
                    ParagraphStyle.Bullet bullet = (ParagraphStyle.Bullet)block;
                    previousSibling = this.getPreviousSibling(p, b, bullet);
                    boolean first = previousSibling.isEmpty();
                    int level = Math.toIntExact(infos.stream().filter(BulletInfo.class::isInstance).count());
                    infos.add(new BulletInfo(bullet, level, first));
                    continue;
                }
                if (block instanceof ParagraphStyle.Code) {
                    ParagraphStyle.Code code = (ParagraphStyle.Code)block;
                    previousSibling = this.getPreviousSibling(p, b, code);
                    Optional<ParagraphStyle.Code> nextSibling = this.getNextSibling(p, b, code);
                    infos.add(new CodeInfo(code, previousSibling.isEmpty(), nextSibling.isEmpty()));
                    continue;
                }
                infos.add(new BlockInfo(block));
            }
            this.blockMap.put(p, infos);
        }
    }

    private OrdinalInfo getOrdinalInfo(int p, int b, ParagraphStyle.Ordinal ordinal) {
        Optional<Info> previousInfoOpt = this.getPreviousInfo(p, b);
        if (previousInfoOpt.isEmpty()) {
            return new OrdinalInfo(ordinal, ordinal.startIndex(), true);
        }
        Info previousInfo = previousInfoOpt.get();
        if (!(previousInfo instanceof OrdinalInfo)) {
            return new OrdinalInfo(ordinal, ordinal.startIndex(), true);
        }
        OrdinalInfo previousOrdinalInfo = (OrdinalInfo)previousInfo;
        ParagraphStyle.Ordinal previousOrdinal = previousOrdinalInfo.ordinal();
        if (previousOrdinal == ordinal) {
            return new OrdinalInfo(ordinal, previousOrdinalInfo.index(), false);
        }
        if (previousOrdinal.markerDelimiter().equals(ordinal.markerDelimiter())) {
            return new OrdinalInfo(ordinal, previousOrdinalInfo.index() + 1, true);
        }
        return new OrdinalInfo(ordinal, ordinal.startIndex(), true);
    }

    public List<Info> getBlockInfos(int paragraphIndex) {
        return this.blockMap.get(paragraphIndex);
    }

    public boolean addBottomPadding(int paragraphIndex) {
        List<Info> blocks = this.getBlockInfos(paragraphIndex);
        List<Info> blocksAfter = this.getBlockInfos(paragraphIndex + 1);
        if (blocks == null || blocksAfter == null) {
            return false;
        }
        return !CollectionUtils.equals(blocks, blocksAfter, Info::equiv);
    }

    public boolean addTopPadding(int paragraphIndex) {
        List<Info> blocks = this.getBlockInfos(paragraphIndex);
        if (!blocks.isEmpty()) {
            return false;
        }
        List<Info> blocksBefore = this.getBlockInfos(paragraphIndex - 1);
        if (blocksBefore == null || blocksBefore.isEmpty()) {
            return false;
        }
        for (Info block : blocksBefore) {
            if (!(block.block() instanceof ParagraphStyle.Quote)) continue;
            return true;
        }
        return false;
    }

    public Optional<Integer> findIndex(ParagraphStyle style) {
        LiveList paragraphs = this.area.getParagraphs();
        for (int p = 0; p < paragraphs.size(); ++p) {
            Paragraph paragraph = (Paragraph)paragraphs.get(p);
            if (paragraph.getParagraphStyle() != style) continue;
            return Optional.of(p);
        }
        return Optional.empty();
    }

    private Optional<Info> getPreviousInfo(int p, int b) {
        List<Info> previousInfos = this.blockMap.get(p - 1);
        if (previousInfos == null) {
            return Optional.empty();
        }
        if (b >= previousInfos.size()) {
            return Optional.empty();
        }
        Info previous = previousInfos.get(b);
        return Optional.of(previous);
    }

    private <B extends ParagraphStyle.BlockStyle> Optional<B> getPreviousSibling(int p, int b, B block) {
        if (p == 0) {
            return Optional.empty();
        }
        List<ParagraphStyle.BlockStyle> previousBlocks = ((ParagraphStyle)this.area.getParagraph((int)(p - 1)).getParagraphStyle()).blocks;
        if (b >= previousBlocks.size()) {
            return Optional.empty();
        }
        ParagraphStyle.BlockStyle previous = previousBlocks.get(b);
        if (previous == block) {
            return Optional.of(block);
        }
        return Optional.empty();
    }

    private <B extends ParagraphStyle.BlockStyle> Optional<B> getNextSibling(int p, int b, B block) {
        if (p == this.area.getParagraphs().size() - 1) {
            return Optional.empty();
        }
        List<ParagraphStyle.BlockStyle> nextBlocks = ((ParagraphStyle)this.area.getParagraph((int)(p + 1)).getParagraphStyle()).blocks;
        if (b >= nextBlocks.size()) {
            return Optional.empty();
        }
        ParagraphStyle.BlockStyle next = nextBlocks.get(b);
        if (next == block) {
            return Optional.of(block);
        }
        return Optional.empty();
    }

    public record OrdinalInfo(ParagraphStyle.Ordinal ordinal, int index, boolean first) implements Info
    {
        @Override
        public ParagraphStyle.BlockStyle block() {
            return this.ordinal;
        }

        @Override
        public boolean equiv(Info other) {
            if (!Info.super.equiv(other)) {
                return false;
            }
            OrdinalInfo otherOrdinalInfo = (OrdinalInfo)other;
            return this.ordinal.markerDelimiter().equals(otherOrdinalInfo.ordinal.markerDelimiter());
        }

        @Override
        public String toString() {
            return "OrdinalInfo{index=" + this.index + ", first=" + this.first + "}";
        }
    }

    public record BulletInfo(ParagraphStyle.Bullet bullet, int level, boolean first) implements Info
    {
        @Override
        public ParagraphStyle.BlockStyle block() {
            return this.bullet;
        }

        @Override
        public boolean equiv(Info other) {
            if (!Info.super.equiv(other)) {
                return false;
            }
            BulletInfo otherBulletInfo = (BulletInfo)other;
            return this.bullet.marker().equals(otherBulletInfo.bullet.marker());
        }
    }

    public record CodeInfo(ParagraphStyle.Code code, boolean first, boolean last) implements Info
    {
        @Override
        public ParagraphStyle.BlockStyle block() {
            return this.code;
        }

        public void update(Values values) {
            if (this.first) {
                values.top = true;
            }
            values.left = true;
            values.right = true;
            if (this.last) {
                values.bottom = true;
            }
        }
    }

    public record BlockInfo(ParagraphStyle.BlockStyle block) implements Info
    {
        @Override
        public boolean first() {
            return true;
        }
    }

    public static sealed interface Info
    permits OrdinalInfo, BulletInfo, CodeInfo, BlockInfo {
        public ParagraphStyle.BlockStyle block();

        public boolean first();

        default public boolean equiv(Info other) {
            return this.block().getClass().equals(other.block().getClass());
        }

        default public String delimiter() {
            if (this.first()) {
                return this.block().delimiter();
            }
            return this.hiddenDelimiter();
        }

        default public String hiddenDelimiter() {
            String delimiter = this.block().delimiter();
            return " ".repeat(delimiter.length());
        }
    }

    public static class Values {
        public boolean top = false;
        public boolean bottom = false;
        public boolean right = false;
        public boolean left = false;

        public BorderWidths toBorderWidths(double v) {
            return new BorderWidths(this.top ? v : 0.0, this.right ? v : 0.0, this.bottom ? v : 0.0, this.left ? v : 0.0);
        }

        public CornerRadii toCornerRadii(double v) {
            return new CornerRadii(this.top ? v : 0.0, this.top ? v : 0.0, this.bottom ? v : 0.0, this.bottom ? v : 0.0, false);
        }

        public Insets toInsets(double v) {
            return new Insets(this.top ? v : 0.0, this.right ? v : 0.0, this.bottom ? v : 0.0, this.left ? v : 0.0);
        }

        public String toString() {
            return "Values{top=" + this.top + ", bottom=" + this.bottom + ", right=" + this.right + ", left=" + this.left + "}";
        }
    }
}

