/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc.richtextfx;

import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.SearchableTextArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.RichStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.style.ParagraphStyle;
import io.olvid.windows.messenger.fx.misc.richtextfx.style.SegmentStyle;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.RichStyledConfiguration;
import io.olvid.windows.messenger.misc.StringUtils;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.Selection;
import org.fxmisc.richtext.SelectionImpl;
import org.fxmisc.richtext.model.StyleSpan;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyledDocument;
import org.reactfx.util.Either;

public class SearchableStyledArea
extends RichStyledArea
implements SearchableTextArea {
    private StringProperty searchText = null;
    private final List<Selection<ParagraphStyle, Either<String, CharSequence>, SegmentStyle>> selections = new ArrayList<Selection<ParagraphStyle, Either<String, CharSequence>, SegmentStyle>>();
    private boolean disableSearch = false;

    public SearchableStyledArea(RichStyledConfiguration configuration) {
        super(configuration);
        this.setUseInitialStyleForInsertion(true);
        this.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.selectRange(0, 0);
            }
        });
    }

    @Override
    public void configure(List<Node> siblings) {
        siblings.add((Node)this);
    }

    @Override
    public void hide() {
        ViewControllerHelper.hideNode((Node)this);
    }

    @Override
    public void show() {
        ViewControllerHelper.showNode((Node)this);
    }

    @Override
    public void bindSearchProperty(StringProperty search) {
        this.searchText = search;
        this.searchText.addListener((observable, oldValue, newValue) -> this.computeHighLight(this.getPlainText()));
    }

    @Override
    public void setDisableSearch(boolean disableSearch) {
        this.disableSearch = disableSearch;
    }

    @Override
    public void bindMaxWidthProperty(DoubleExpression maxWidthBinding) {
        this.maxWidthProperty().bind((ObservableValue)maxWidthBinding);
    }

    @Override
    public void setStyleClass(String styleClass) {
        this.getStyleClass().setAll((Object[])new String[]{styleClass});
    }

    private void clearSelections() {
        for (Selection<ParagraphStyle, Either<String, CharSequence>, SegmentStyle> selection : this.selections) {
            selection.selectRange(0, 0);
            selection.dispose();
            if (this.removeSelection(selection)) continue;
            logger.error(String.format("Cannot removed selection [%d, %d]", selection.getStartPosition(), selection.getEndPosition()));
        }
        this.selections.clear();
    }

    @Override
    public void replace(int start, int end, StyledDocument<ParagraphStyle, Either<String, CharSequence>, SegmentStyle> replacement) {
        super.replace(start, end, replacement);
        this.computeHighLight(this.getPlainText());
    }

    private void computeHighLight(String text) {
        this.clearSelections();
        if (this.disableSearch) {
            return;
        }
        if (this.searchText == null || this.searchText.getValue() == null || this.searchText.getValue().isEmpty()) {
            return;
        }
        List<StringUtils.HighlightRange> ranges = StringUtils.highlightString(text, this.searchText.getValue());
        for (StringUtils.HighlightRange range : ranges) {
            int from = range.start();
            int to = range.end();
            StyleSpans styleSpans = this.getStyleSpans(from, to);
            int idx = from;
            for (StyleSpan styleSpan : styleSpans) {
                SelectionImpl selection = new SelectionImpl(Integer.toString(idx), (GenericStyledArea)this, path -> path.getStyleClass().add((Object)"main-selection"));
                this.selections.add((Selection<ParagraphStyle, Either<String, CharSequence>, SegmentStyle>)selection);
                if (!this.addSelection((Selection)selection)) {
                    logger.error(String.format("Cannot add selection [%d, %d]", idx, idx + styleSpan.getLength()));
                    continue;
                }
                selection.selectRange(idx, idx + styleSpan.getLength());
                idx += styleSpan.getLength();
            }
        }
        this.layout();
    }
}

