/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc.richtextfx;

import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.custom_components.toggle_switch.TSwitch;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.richtextfx.EditableStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.RichStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.style.ParagraphStyle;
import io.olvid.windows.messenger.fx.misc.richtextfx.style.SegmentStyle;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.RichStyledConfiguration;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.ToggleableArea;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.IndexRange;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Separator;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.StringConverter;

public final class RichToolBarController {
    public final ToolBar toolBar;
    private final ToggleableArea area;
    private final Set<StyleButton<?>> buttons = new HashSet();
    private final ComboBox<ParagraphStyle.Heading> headingComboBox;
    private final ObservableList<ParagraphStyle.Heading> headingsItems = FXCollections.observableArrayList(ParagraphStyle.Heading.values());
    private final AtomicBoolean disableHeadingComboBoxListeners = new AtomicBoolean(false);

    public RichToolBarController(ToggleableArea area) {
        this.area = area;
        this.area.setToolBarController(this);
        HBox modeContainer = this.makeModeContainer();
        StyleSegmentButton boldButton = new StyleSegmentButton("svg-bold", new SegmentStyle.Style.Bold(), ViewControllerHelper.getString("bold-tooltip"));
        StyleSegmentButton italicButton = new StyleSegmentButton("svg-italic", new SegmentStyle.Style.Italic(), ViewControllerHelper.getString("italic-tooltip"));
        StyleSegmentButton strikethroughButton = new StyleSegmentButton("svg-strikethrough", new SegmentStyle.Style.Strikethrough(), ViewControllerHelper.getString("strikethrough-tooltip"));
        StyleBlockButton bulletButton = new StyleBlockButton("svg-bullet-list", (ParagraphStyle.BlockStyle)new ParagraphStyle.Bullet(), ViewControllerHelper.getString("bullet-list-tooltip"), false);
        StyleBlockButton ordinalButton = new StyleBlockButton(List.of("svg-ordinal-list-lines", "svg-ordinal-list-numbers"), (ParagraphStyle.BlockStyle)new ParagraphStyle.Ordinal(), ViewControllerHelper.getString("numbered-list-tooltip"), false);
        StyleBlockButton quoteButton = new StyleBlockButton("svg-quote", (ParagraphStyle.BlockStyle)new ParagraphStyle.Quote(), ViewControllerHelper.getString("quote-tooltip"), false);
        StyleSegmentButton inlineCodeButton = new StyleSegmentButton("svg-inline-code", new SegmentStyle.Style.InlineCode(), ViewControllerHelper.getString("inline-code-tooltip"));
        StyleBlockButton blockCodeButton = new StyleBlockButton("svg-block-code", (ParagraphStyle.BlockStyle)new ParagraphStyle.Code(), ViewControllerHelper.getString("block-code-tooltip"), true);
        TabButton incrButton = new TabButton(List.of("svg-incr-block-1", "svg-incr-block-2"), true, ViewControllerHelper.getString("increase-indent-tooltip"));
        TabButton decrButton = new TabButton(List.of("svg-decr-block-1", "svg-decr-block-2"), false, ViewControllerHelper.getString("decrease-indent-tooltip"));
        Pane spacer = new Pane();
        HBox.setHgrow((Node)spacer, (Priority)Priority.SOMETIMES);
        this.headingComboBox = this.makeHeadingComboBox();
        this.toolBar = new ToolBar(new Node[]{modeContainer, new Separator(Orientation.VERTICAL), boldButton, italicButton, strikethroughButton, new Separator(Orientation.VERTICAL), bulletButton, ordinalButton, quoteButton, new Separator(Orientation.VERTICAL), incrButton, decrButton, new Separator(Orientation.VERTICAL), inlineCodeButton, blockCodeButton, new Separator(Orientation.VERTICAL), this.headingComboBox, spacer});
        this.toolBar.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)}));
        area.selectionProperty().addListener((obs, oldVal, newVal) -> this.update());
    }

    private HBox makeModeContainer() {
        HBox modeContainer = new HBox(4.0);
        modeContainer.getStyleClass().add((Object)"mode-container");
        modeContainer.setAlignment(Pos.CENTER);
        TSwitch modeButton = new TSwitch();
        modeContainer.getChildren().add((Object)modeButton);
        Label label = new Label();
        label.setText(ViewControllerHelper.getString("rich-text-button"));
        modeContainer.getChildren().add((Object)label);
        modeButton.setDisable(true);
        modeButton.setMouseTransparent(true);
        modeContainer.setOnMouseClicked(event -> this.area.switchMode());
        modeButton.selectedProperty().bind((ObservableValue)this.area.modeProperty().isEqualTo((Object)EditableStyledArea.Mode.RICH));
        return modeContainer;
    }

    private ComboBox<ParagraphStyle.Heading> makeHeadingComboBox() {
        ComboBox comboBox = new ComboBox();
        comboBox.setConverter((StringConverter)new StringConverter<ParagraphStyle.Heading>(this){

            public String toString(ParagraphStyle.Heading heading) {
                return heading == null ? "" : heading.title();
            }

            public ParagraphStyle.Heading fromString(String s) {
                throw new IllegalStateException();
            }
        });
        comboBox.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
            if (newVal == null) {
                return;
            }
            if (this.disableHeadingComboBoxListeners.get()) {
                return;
            }
            this.area.updateHeader((ParagraphStyle.Heading)newVal);
        });
        comboBox.setCellFactory(param -> new ListCell<ParagraphStyle.Heading>(){

            protected void updateItem(ParagraphStyle.Heading item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setText(null);
                    this.styleProperty().unbind();
                } else {
                    this.setText(item.title());
                    ToggleableArea toggleableArea = RichToolBarController.this.area;
                    if (toggleableArea instanceof RichStyledArea) {
                        RichStyledArea richStyledArea = (RichStyledArea)((Object)toggleableArea);
                        StringBinding size = Bindings.createStringBinding(() -> String.format("-fx-font-size: %s;", richStyledArea.fontSizeProperty.get() * item.getScale()), (Observable[])new Observable[]{richStyledArea.fontSizeProperty});
                        this.styleProperty().bind((ObservableValue)size);
                    }
                }
                this.setAlignment(Pos.CENTER);
            }
        });
        comboBox.setItems(this.headingsItems);
        return comboBox;
    }

    public void update() {
        for (StyleButton<?> b : this.buttons) {
            b.update();
        }
        IndexRange selection = this.area.getSelection();
        Optional<ParagraphStyle.Heading> headingOpt = this.area.detectHeader(selection);
        this.disableHeadingComboBoxListeners.set(true);
        if (headingOpt.isPresent()) {
            ParagraphStyle.Heading heading = headingOpt.get();
            this.headingComboBox.setValue((Object)heading);
            if (heading.level() != ParagraphStyle.Heading.BODY.level() && this.area.getConfiguration().processDelimiter() == RichStyledConfiguration.DelimiterProcessing.STYLE) {
                this.headingComboBox.setDisable(true);
            } else {
                this.headingComboBox.setDisable(false);
            }
        } else {
            this.headingComboBox.setValue(null);
            this.headingComboBox.setDisable(true);
        }
        this.disableHeadingComboBoxListeners.set(false);
    }

    private class StyleSegmentButton
    extends StyleButton<SegmentStyle.Style> {
        public StyleSegmentButton(String styleClass, SegmentStyle.Style style, String toolTip) {
            super(List.of(styleClass), style, toolTip, RichToolBarController.this.buttons);
        }

        @Override
        public ToggleableArea.StyleDetection detectStyle(IndexRange selection, SegmentStyle.Style style) {
            return RichToolBarController.this.area.detectStyle(selection, style);
        }

        @Override
        public void toggleStyle() {
            IndexRange selection = RichToolBarController.this.area.getSelection();
            if (selection.getLength() == 0) {
                if (RichToolBarController.this.area.getConfiguration().processDelimiter() != RichStyledConfiguration.DelimiterProcessing.TOGGLEABLE) {
                    return;
                }
                SegmentStyle segmentStyle = (SegmentStyle)RichToolBarController.this.area.getTextStyleForInsertionAt(selection.getStart());
                if (segmentStyle.styles().contains(this.style)) {
                    segmentStyle = segmentStyle.removeStyles(Set.of(((SegmentStyle.Style)this.style).getClass()));
                    this.setButtonStyle(false, false);
                } else {
                    segmentStyle = segmentStyle.addStyle(Optional.of((SegmentStyle.Style)this.style));
                    this.setButtonStyle(true, false);
                }
                RichToolBarController.this.area.setTextInsertionStyle(segmentStyle);
            } else {
                RichToolBarController.this.area.toggleStyle((SegmentStyle.Style)this.style);
                this.update();
            }
        }
    }

    private class StyleBlockButton
    extends StyleButton<ParagraphStyle.BlockStyle> {
        private final boolean sameInstance;

        public StyleBlockButton(String styleClass, ParagraphStyle.BlockStyle style, String toolTip, boolean sameInstance) {
            this(List.of(styleClass), style, toolTip, sameInstance);
        }

        public StyleBlockButton(List<String> styleClass, ParagraphStyle.BlockStyle style, String toolTip, boolean sameInstance) {
            super(styleClass, style, toolTip, RichToolBarController.this.buttons);
            this.sameInstance = sameInstance;
        }

        @Override
        public void toggleStyle() {
            RichToolBarController.this.area.toggleStyle((ParagraphStyle.BlockStyle)this.style, this.sameInstance);
        }

        @Override
        public ToggleableArea.StyleDetection detectStyle(IndexRange selection, ParagraphStyle.BlockStyle blockStyle) {
            return RichToolBarController.this.area.detectStyle(selection, blockStyle.getClass());
        }
    }

    private class TabButton
    extends StyleButton<Void> {
        private final boolean incr;

        public TabButton(List<String> styleClass, boolean incr, String toolTip) {
            super(styleClass, null, toolTip, RichToolBarController.this.buttons);
            this.incr = incr;
        }

        @Override
        public void toggleStyle() {
            if (this.incr) {
                RichToolBarController.this.area.processTab();
            } else {
                RichToolBarController.this.area.processShiftTab();
            }
        }

        @Override
        public ToggleableArea.StyleDetection detectStyle(IndexRange selection, Void ignore) {
            boolean active = this.incr ? RichToolBarController.this.area.canTab() : RichToolBarController.this.area.canShiftTab();
            if (active) {
                return ToggleableArea.StyleDetection.NONE;
            }
            return ToggleableArea.StyleDetection.INVALID;
        }
    }

    private abstract class StyleButton<Style>
    extends Button {
        protected final Style style;

        public StyleButton(List<String> styleClasses, Style style, String toolTip, Set<StyleButton<?>> buttons) {
            this.style = style;
            StackPane stackPane = new StackPane();
            for (String styleClass : styleClasses) {
                SvgSizeable icon = new SvgSizeable();
                icon.getStyleClass().addAll((Object[])new String[]{styleClass, "icon-xsmall"});
                stackPane.getChildren().add((Object)icon);
            }
            buttons.add(this);
            this.setOnAction(event -> {
                try {
                    this.toggleStyle();
                    RichToolBarController.this.update();
                    RichToolBarController.this.area.requestFocus();
                }
                catch (Exception e) {
                    RichToolBarController.this.area.logger().error("Error while toggling style", e);
                }
            });
            this.setGraphic((Node)stackPane);
            this.setTooltip(new Tooltip(toolTip));
            this.getStyleClass().add((Object)"transparent-icon-button");
        }

        public abstract void toggleStyle();

        public abstract ToggleableArea.StyleDetection detectStyle(IndexRange var1, Style var2);

        protected void setButtonStyle(boolean active, boolean disable) {
            if (active) {
                if (!this.getStyleClass().contains((Object)"active-button")) {
                    this.getStyleClass().add((Object)"active-button");
                }
            } else {
                this.getStyleClass().remove((Object)"active-button");
            }
            this.setDisable(disable);
        }

        public final void update() {
            IndexRange selection = RichToolBarController.this.area.getSelection();
            ToggleableArea.StyleDetection styleDetection = this.detectStyle(selection, this.style);
            switch (styleDetection) {
                case NONE: 
                case MIXED: {
                    this.setButtonStyle(false, false);
                    break;
                }
                case ALL: {
                    this.setButtonStyle(true, false);
                    break;
                }
                case ALL_INFO: {
                    this.setButtonStyle(true, true);
                    break;
                }
                case NONE_INFO: 
                case INVALID: {
                    this.setButtonStyle(false, true);
                }
            }
        }
    }
}

