/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc.richtextfx;

import io.olvid.windows.messenger.misc.Watches;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.text.TextFlow;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.StyledSegment;
import org.fxmisc.richtext.model.TextOps;

public class AutoSizeStyledArea<PS, SEG, S>
extends GenericStyledArea<PS, SEG, S> {
    protected AutoSizeStyledArea(PS initialParagraphStyle, BiConsumer<TextFlow, PS> applyParagraphStyle, S initialTextStyle, TextOps<SEG, S> segmentOps, Function<StyledSegment<SEG, S>, Node> nodeFactory) {
        super(initialParagraphStyle, applyParagraphStyle, initialTextStyle, segmentOps, nodeFactory);
        this.setWrapText(true);
        this.maxWidthProperty().addListener((obv, oldValue, newValue) -> this.observeMaxWidthProperty());
    }

    protected void observeMaxWidthProperty() {
        this.requestLayout();
    }

    private ParagraphNode getParagraphNode(int p) {
        ObservableList children = this.getChildren();
        Object object = children.get(0);
        if (!(object instanceof VirtualFlow)) {
            throw new IllegalStateException();
        }
        VirtualFlow virtualFlow = (VirtualFlow)object;
        Cell cell = virtualFlow.getCell(p);
        Node paragraphBoxNode = cell.getNode();
        if (!(paragraphBoxNode instanceof Region)) {
            throw new IllegalStateException();
        }
        Region paragraphBox = (Region)paragraphBoxNode;
        return new ParagraphNode(paragraphBox);
    }

    protected double computeCellPrefHeight(int p, double width) {
        ParagraphNode paragraphNode = this.getParagraphNode(p);
        return paragraphNode.getTextFlow().prefHeight(width);
    }

    protected double computeCellPrefWidth(int p) {
        ParagraphNode paragraphNode = this.getParagraphNode(p);
        double width = 0.0;
        width += paragraphNode.getTextFlow().prefWidth(-1.0);
        Optional<Node> graphicOpt = paragraphNode.getGraphic();
        if (graphicOpt.isPresent()) {
            Node graphic = graphicOpt.get();
            width += Math.min(Math.max(graphic.prefWidth(-1.0), graphic.minWidth(-1.0)), graphic.maxWidth(-1.0));
        }
        Insets insets = paragraphNode.getInsets();
        return width += insets.getLeft() + insets.getRight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double computePrefHeight(double width) {
        Watches.Watch watch = Watches.getInstance().start("AutoSizeStyledArea.computePrefHeight");
        try {
            double height = 0.0;
            Insets in = this.getInsets();
            double maxWidth = width == -1.0 ? this.getMaxWidth() : width;
            for (int p = 0; p < this.getParagraphs().size(); ++p) {
                height += this.computeCellPrefHeight(p, maxWidth);
            }
            if (height > 0.0) {
                if (this.getMinHeight() != -1.0) {
                    height = Math.max(this.getMinHeight(), height);
                }
                if (this.getMaxHeight() != -1.0) {
                    height = Math.min(this.getMaxHeight(), height);
                }
                double d = height + in.getTop() + in.getBottom();
                return d;
            }
            double d = super.computePrefHeight(width);
            return d;
        }
        finally {
            watch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double computePrefWidth(double height) {
        Watches.Watch watch = Watches.getInstance().start("AutoSizeStyledArea.computePrefWidth");
        try {
            double width = 0.0;
            Insets in = this.getInsets();
            for (int p = 0; p < this.getParagraphs().size(); ++p) {
                Paragraph paragraph = this.getParagraph(p);
                if (paragraph.length() == 0) continue;
                width = Math.max(width, this.computeCellPrefWidth(p));
            }
            if (width > 0.0) {
                if (this.getMinWidth() != -1.0) {
                    width = Math.max(this.getMinWidth(), width);
                }
                if (this.getMaxWidth() != -1.0) {
                    width = Math.min(this.getMaxWidth(), width);
                }
                double d = width + in.getLeft() + in.getRight();
                return d;
            }
            double d = super.computePrefWidth(height);
            return d;
        }
        finally {
            watch.stop();
        }
    }

    record ParagraphNode(Region node) {
        TextFlow getTextFlow() {
            ObservableList children = this.node.getChildrenUnmodifiable();
            if (children.isEmpty()) {
                throw new IllegalStateException();
            }
            Node child = (Node)children.get(0);
            if (!(child instanceof TextFlow)) {
                throw new IllegalStateException();
            }
            TextFlow textFlow = (TextFlow)child;
            return textFlow;
        }

        Optional<Node> getGraphic() {
            ObservableList children = this.node.getChildrenUnmodifiable();
            if (children.size() != 2) {
                return Optional.empty();
            }
            return Optional.of((Node)children.get(1));
        }

        Insets getInsets() {
            return this.node.getInsets();
        }
    }
}

