/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc;

import io.olvid.windows.messenger.fx.misc.ImageHelper;
import io.olvid.windows.messenger.fx.misc.OpenGraph;
import io.olvid.windows.messenger.misc.cache.FutureLruCache;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javafx.scene.image.Image;

public class OpenGraphLruCache
extends FutureLruCache<ImageHelper.ImageData, OpenGraphWrapper, Throwable> {
    public OpenGraphLruCache(long cacheMaxSize) {
        super(cacheMaxSize);
    }

    public static class OpenGraphWrapper {
        private final Image image;
        private final OpenGraph openGraph;

        public OpenGraphWrapper(OpenGraph openGraph) {
            this.openGraph = openGraph;
            byte[] imageBytes = openGraph.getImageBytes();
            this.image = imageBytes != null ? new Image((InputStream)new ByteArrayInputStream(imageBytes)) : null;
        }

        public Image getImage() {
            return this.image;
        }

        public String getTitle() {
            return this.openGraph.getTitle();
        }

        public String getDescription() {
            return this.openGraph.getDescription();
        }

        public String getUrl() {
            return this.openGraph.getUrl();
        }
    }
}

