/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc;

import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.secure_io.SecureFile;
import io.olvid.engine.secure_io.SecureFileInputStream;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.fx.misc.HttpClientHelper;
import io.olvid.windows.messenger.fx.misc.OpenGraph;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.Result;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Optional;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class OpenGraphHelper {
    public static final String MIME_TYPE = "olvid/link-preview";
    private static final String DOC_SELECT_OGTAGS = "meta[property^=og:]";
    private static final String DOC_SELECT_DESCRIPTION = "meta[name=description]";
    private static final String DOC_SELECT_FAVICON = "link[rel~=icon][href~=.*\\.(ico|png)]";
    private static final String DOC_SELECT_ITEMPROP = "meta[itemprop=image]";
    private static final String OPEN_GRAPH_KEY = "content";
    private static final String PROPERTY = "property";
    private static final String OG_IMAGE = "og:image";
    private static final String OG_DESCRIPTION = "og:description";
    private static final String OG_TITLE = "og:title";
    private static final String OG_SITE_NAME = "og:site_name";
    private static final String OG_TYPE = "og:type";
    private static final long MAX_IMAGE_SIZE = 0x500000L;
    private static final String userAgent = "WhatsApp/2";
    private static final CloseableHttpClient httpClient = HttpClientHelper.getHttpClient("WhatsApp/2");

    public static byte[] encodeOpenGraphStruct(OpenGraph openGraph) {
        HashMap<DictionaryKey, Encoded> map = new HashMap<DictionaryKey, Encoded>();
        if (openGraph.getTitle() != null) {
            map.put(new DictionaryKey("title"), Encoded.of((String)openGraph.getTitle()));
        }
        if (openGraph.getDescription() != null) {
            map.put(new DictionaryKey("desc"), Encoded.of((String)openGraph.getDescription()));
        }
        if (openGraph.getUrl() != null) {
            map.put(new DictionaryKey("url"), Encoded.of((String)openGraph.getUrl()));
        }
        if (openGraph.getImageBytes() != null) {
            map.put(new DictionaryKey("image"), Encoded.of((byte[])openGraph.getImageBytes()));
        }
        return Encoded.of(map).getBytes();
    }

    public static Result<OpenGraph, Throwable> loadOpenGraph(String path) {
        try {
            OpenGraph openGraph;
            String pathToUse = FileApi.absolutePathFromRelative(path);
            SecureFile secureInputFile = new SecureFile(pathToUse);
            try (SecureFileInputStream secureFileInputStream = new SecureFileInputStream(secureInputFile);){
                openGraph = OpenGraph.of(new Encoded(secureFileInputStream.readAllBytes()));
            }
            return Result.success(openGraph);
        }
        catch (Exception e) {
            return Result.failure(e);
        }
    }

    public static Optional<OpenGraph> fetchOpenGraph(String url) {
        Optional<OpenGraph> openGraph = OpenGraphHelper.requestSite(url);
        if (openGraph.isEmpty()) {
            return Optional.empty();
        }
        openGraph.get().setUrl(url);
        if (openGraph.get().getImageUrl() != null) {
            openGraph.get().setImageBytes(OpenGraphHelper.fetchImage(openGraph.get().getImageUrl()));
        } else {
            AppLogger.e("LinkPreview.fetchOpenGraph: no image to download");
        }
        return openGraph;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] fetchImage(String uri) {
        try (CloseableHttpClient closeableHttpClient = httpClient;){
            URIBuilder uriBuilder = new URIBuilder(uri, StandardCharsets.UTF_8);
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            try (CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpGet);){
                if (response.getCode() != 200) return null;
                try (HttpEntity responseEntity = response.getEntity();){
                    if (responseEntity == null) return null;
                    if (responseEntity.getContentLength() > 0x500000L) {
                        AppLogger.i("LinkPreview.image preview is too big, ignoring");
                        byte[] byArray = null;
                        return byArray;
                    }
                    byte[] byArray = responseEntity.getContent().readAllBytes();
                    return byArray;
                }
            }
        }
        catch (URISyntaxException e) {
            AppLogger.d("OpenGraphHelper.fetchImage: couldn't parse given uri : " + uri);
            return null;
        }
        catch (Exception e) {
            AppLogger.e("OpenGraphHelper.fetchImage: cannot download preview image", e);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static Optional<OpenGraph> requestSite(String url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Optional<OpenGraph> parse(String url, HttpEntity responseEntity, OpenGraph result) throws IOException, ParseException {
        ContentType contentType = ContentType.parse((CharSequence)responseEntity.getContentType());
        if (!contentType.isSameMimeType(ContentType.TEXT_HTML)) {
            AppLogger.e("OpenGraphHelper.parse: cannot load preview: content type is invalid");
            return Optional.empty();
        }
        Charset charset = contentType.getCharset(StandardCharsets.UTF_8);
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        String html = EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)html, (String)url);
        Elements ogTags = document.select(DOC_SELECT_OGTAGS);
        ogTags.forEach(tag -> {
            switch (tag.attr(PROPERTY)) {
                case "og:image": {
                    result.setImageUrl(tag.attr(OPEN_GRAPH_KEY));
                    break;
                }
                case "og:description": {
                    result.setDescription(tag.attr(OPEN_GRAPH_KEY));
                    break;
                }
                case "og:title": {
                    result.setTitle(tag.attr(OPEN_GRAPH_KEY));
                    break;
                }
                case "og:site_name": {
                    result.setSiteName(tag.attr(OPEN_GRAPH_KEY));
                    break;
                }
                case "og:type": {
                    result.setType(tag.attr(OPEN_GRAPH_KEY));
                }
            }
        });
        if (result.getTitle() == null || result.getTitle().isEmpty()) {
            result.setTitle(document.title());
        }
        if (result.getDescription() == null || result.getDescription().isEmpty()) {
            Elements docSelection = document.select(DOC_SELECT_DESCRIPTION);
            Element firstElement = docSelection.first();
            if (firstElement != null) {
                result.setDescription(firstElement.attr(OPEN_GRAPH_KEY));
            } else {
                result.setDescription("");
            }
        }
        if (result.getImageUrl() == null || result.getImageUrl().isEmpty() || result.getImageUrl().equals("null")) {
            Elements faviconSelection = document.head().select(DOC_SELECT_FAVICON);
            Element faviconElement = faviconSelection.first();
            Elements itempropSelection = document.head().select(DOC_SELECT_ITEMPROP);
            Element contentElement = itempropSelection.first();
            if (faviconElement != null) {
                result.setImageUrl(faviconElement.attr("abs:href"));
            } else if (contentElement != null) {
                result.setImageUrl(contentElement.attr(OPEN_GRAPH_KEY));
            }
        }
        return Optional.of(result);
    }
}

