/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc;

import io.olvid.engine.secure_io.SecureFile;
import io.olvid.engine.secure_io.SecureFileInputStream;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.engine.sync.ProfilePictureKey;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.ByteArray;
import io.olvid.windows.messenger.misc.ImageUtils;
import io.olvid.windows.messenger.misc.Result;
import io.olvid.windows.messenger.misc.Watches;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javafx.geometry.Rectangle2D;
import javafx.scene.image.Image;

public final class ImageHelper {
    public static final double THUMBNAIL_SIZE = 810.0;

    private ImageHelper() {
    }

    public static ImageInfo readImage(String path) throws Exception {
        Watches.Watch watch = Watches.getInstance().start("ImageHelper.readImage");
        SecureFile secureInputFile = new SecureFile(FileApi.absolutePathFromRelative(path));
        try {
            ImageInfo imageInfo;
            try (SecureFileInputStream secureFileInputStream = new SecureFileInputStream(secureInputFile);){
                Optional<ImageUtils.ImageMetadata> metadata = ImageUtils.getMetadata((InputStream)secureFileInputStream);
                secureFileInputStream.seek(0L);
                Image image = new Image((InputStream)secureFileInputStream);
                Exception exception = image.getException();
                if (exception != null) {
                    throw exception;
                }
                imageInfo = new ImageInfo(image, metadata.flatMap(ImageUtils.ImageMetadata::orientation));
            }
            return imageInfo;
        }
        finally {
            watch.stop();
        }
    }

    public static ImageInfo readSmallImage(String path) throws Exception {
        Watches.Watch watch = Watches.getInstance().start("ImageHelper.readSmallImage");
        SecureFile secureInputFile = new SecureFile(FileApi.absolutePathFromRelative(path));
        try {
            ImageInfo imageInfo;
            try (SecureFileInputStream secureFileInputStream = new SecureFileInputStream(secureInputFile);){
                Optional<ImageUtils.ImageMetadata> metadata = ImageUtils.getMetadata((InputStream)secureFileInputStream);
                secureFileInputStream.seek(0L);
                Image image = new Image((InputStream)secureFileInputStream, 160.0, 160.0, true, false);
                Exception exception = image.getException();
                if (exception != null) {
                    throw exception;
                }
                imageInfo = new ImageInfo(image, metadata.flatMap(ImageUtils.ImageMetadata::orientation));
            }
            return imageInfo;
        }
        finally {
            watch.stop();
        }
    }

    public static Rectangle2D croppedImageViewPort(Image image, double targetWidth, double targetHeight) {
        double oldImageWidth = image.getWidth();
        double oldImageHeight = image.getHeight();
        double imageRatio = oldImageWidth / oldImageHeight;
        double targetRatio = targetWidth / targetHeight;
        double newImageWidth = oldImageWidth;
        double newImageHeight = oldImageHeight;
        if (targetRatio > imageRatio) {
            newImageHeight = oldImageWidth / targetRatio;
        } else if (targetRatio < imageRatio) {
            newImageWidth = oldImageHeight * targetRatio;
        }
        return new Rectangle2D((oldImageWidth - newImageWidth) / 2.0, (oldImageHeight - newImageHeight) / 2.0, newImageWidth, newImageHeight);
    }

    public static Result<ImageInfo, Throwable> computeImage(ImageData imageData) {
        Result<ImageInfo, Throwable> result;
        boolean mimeTypeHandled = ImageUtils.isSupportedImage(imageData.mimeType());
        if (!mimeTypeHandled) {
            String defaultImageUrl = ImageUtils.getDefaultImage(imageData.mimeType());
            Image image = new Image(defaultImageUrl, 810.0, 810.0, true, true);
            return Result.success(new ImageInfo(image, Optional.of(ImageUtils.Orientation.Normal)));
        }
        String pathToUse = FileApi.absolutePathFromRelative(imageData.path());
        SecureFile secureInputFile = new SecureFile(pathToUse);
        SecureFileInputStream secureFileInputStream = new SecureFileInputStream(secureInputFile);
        try {
            long duration;
            Image image;
            double size;
            Watches.Watch watch = Watches.getInstance().start("ImageHelper.computeImage metadata");
            Optional<ImageUtils.ImageMetadata> attachmentMetadata = ImageUtils.getMetadata((InputStream)secureFileInputStream);
            watch.stop();
            int originalSize = 0;
            if (attachmentMetadata.isPresent()) {
                ImageUtils.ImageMetadata metadata = attachmentMetadata.get();
                int max = Math.max(metadata.width(), metadata.height());
                int min = Math.min(metadata.width(), metadata.height());
                originalSize = max;
                double ratio = (double)max / (double)min;
                size = ratio * 810.0;
            } else {
                size = 810.0;
            }
            secureFileInputStream.seek(0L);
            if ((double)originalSize > 810.0) {
                watch = Watches.getInstance().start("ImageHelper.computeImage small");
                image = new Image((InputStream)secureFileInputStream, size, size, true, false);
                duration = watch.stop();
            } else {
                watch = Watches.getInstance().start("ImageHelper.computeImage original");
                image = new Image((InputStream)secureFileInputStream);
                duration = watch.stop();
            }
            AppLogger.d("computeImage: new Image took ---> " + duration / 1000000L);
            Optional<ImageUtils.Orientation> orientation = attachmentMetadata.flatMap(ImageUtils.ImageMetadata::orientation);
            result = Result.success(new ImageInfo(image, orientation));
        }
        catch (Throwable throwable) {
            try {
                try {
                    secureFileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return Result.failure(e);
            }
        }
        secureFileInputStream.close();
        return result;
    }

    public static Result<ImageInfo, Throwable> computeLargeImage(ImageData imageData) {
        try {
            ImageInfo value = ImageHelper.readImage(imageData.path());
            return Result.success(value);
        }
        catch (Exception e) {
            return Result.failure(e);
        }
    }

    public static Result<ImageInfo, Throwable> fetchAndReadSmallImage(ProfilePictureKey profilePictureKey) {
        ByteArray profilePicBytes;
        try {
            profilePicBytes = Api.getBackupApi().downloadProfilePicture(profilePictureKey.bytesIdentity(), profilePictureKey.photoLabel(), profilePictureKey.photoKey());
        }
        catch (Exception e) {
            return Result.failure(e);
        }
        if (profilePicBytes.isPresent()) {
            ImageInfo imageInfo = new ImageInfo(new Image((InputStream)new ByteArrayInputStream(profilePicBytes.byteArray())), Optional.empty());
            return Result.success(imageInfo);
        }
        return Result.failure(new Exception("ImageHelper::fetchAndReadSmallImage failed"));
    }

    public record ImageInfo(Image image, Optional<ImageUtils.Orientation> orientation) {
    }

    public record ImageData(Id<Fyle> fyleId, String path, byte[] sha256, String mimeType) {
        public static ImageData of(Id<Fyle> fyleId, String path, byte[] sha256, String mimeType) {
            return new ImageData(fyleId, path, sha256, mimeType);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageData imageData = (ImageData)o;
            return Objects.deepEquals(this.sha256, imageData.sha256) && Objects.equals(this.mimeType, imageData.mimeType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.sha256), this.mimeType);
        }
    }
}

