/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc;

import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.network.CustomSSLSocketFactory;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.util.TimeValue;

public class HttpClientHelper {
    static CustomSSLSocketFactory sslSocketFactory;
    static SSLConnectionSocketFactory sslsf;
    static Registry<ConnectionSocketFactory> socketFactoryRegistry;
    static BasicHttpClientConnectionManager connectionManager;
    static HttpClientBuilder httpClientBuilder;
    public static final int HTTP_200_OK = 200;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final String HTTP_CONTENT_TYPE = "Content-Type";
    public static final String HTTP_CONTENT_TYPE_APP_FORM_URL_ENCODED_VALUE = "application/x-www-form-urlencoded";
    public static final String HTTP_CONTENT_TYPE_APP_JSON_VALUE = "application/json";

    public static CloseableHttpClient getHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClientHelper.getBuilder();
        return httpClientBuilder.build();
    }

    public static CloseableHttpClient getHttpClient(String userAgent) {
        HttpClientBuilder httpClientBuilder = HttpClientHelper.getBuilder();
        httpClientBuilder.setUserAgent(userAgent);
        httpClientBuilder.disableCookieManagement();
        return httpClientBuilder.build();
    }

    private static HttpClientBuilder getBuilder() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        httpClientBuilder.setConnectionManagerShared(true);
        httpClientBuilder.useSystemProperties();
        return httpClientBuilder;
    }

    static {
        try {
            sslSocketFactory = new CustomSSLSocketFactory(SSLContext.getDefault().getSocketFactory());
        }
        catch (NoSuchAlgorithmException e) {
            AppLogger.e("HttpClientHelper::init couldn't create ssl factory", e);
            throw new IllegalStateException();
        }
        sslsf = new SSLConnectionSocketFactory((SSLSocketFactory)sslSocketFactory, CustomSSLSocketFactory.ENABLED_PROTOCOLS, CustomSSLSocketFactory.ENABLED_CIPHER_SUITES, (HostnameVerifier)new DefaultHostnameVerifier());
        socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
        connectionManager = new BasicHttpClientConnectionManager(socketFactoryRegistry);
        ConnectionConfig config = ConnectionConfig.custom().setConnectTimeout(5000L, TimeUnit.MILLISECONDS).setSocketTimeout(5000, TimeUnit.MILLISECONDS).build();
        connectionManager.setConnectionConfig(config);
        connectionManager.closeIdle(TimeValue.of((long)10L, (TimeUnit)TimeUnit.SECONDS));
    }
}

