/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc;

import io.olvid.windows.messenger.fx.misc.SearchableTextArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.RichStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.SearchableStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.HasMarkdownVisitor;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.RichStyledConfiguration;
import io.olvid.windows.messenger.fx.misc.textflow.SearchableTextFlow;
import io.olvid.windows.messenger.misc.Watches;
import java.util.List;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.text.TextAlignment;
import org.commonmark.node.Visitor;

public class FancyTextArea
implements SearchableTextArea {
    private final SimpleBooleanProperty richMode = new SimpleBooleanProperty(false);
    private final SearchableStyledArea richArea;
    private final SearchableTextFlow textFlow;

    public FancyTextArea(RichStyledConfiguration configuration) {
        this.richArea = new SearchableStyledArea(configuration);
        this.textFlow = new SearchableTextFlow();
    }

    @Override
    public void hide() {
        this.richArea.hide();
        this.textFlow.hide();
    }

    @Override
    public void show() {
        if (this.richMode.get()) {
            this.richArea.show();
        } else {
            this.textFlow.show();
        }
    }

    @Override
    public void configure(List<Node> siblings) {
        this.richArea.configure(siblings);
        this.textFlow.configure(siblings);
    }

    @Override
    public void setEditable(boolean editable) {
        this.richArea.setEditable(editable);
        this.textFlow.setEditable(editable);
    }

    @Override
    public void bindSearchProperty(StringProperty search) {
        this.richArea.bindSearchProperty(search);
        this.textFlow.bindSearchProperty(search);
    }

    @Override
    public void setDisableSearch(boolean disableSearch) {
        this.richArea.setDisableSearch(disableSearch);
        this.textFlow.setDisableSearch(disableSearch);
    }

    @Override
    public void bindMaxWidthProperty(DoubleExpression maxWidthBinding) {
        this.richArea.bindMaxWidthProperty(maxWidthBinding);
        this.textFlow.bindMaxWidthProperty(maxWidthBinding);
    }

    @Override
    public void setStyleClass(String styleClass) {
        this.richArea.setStyleClass(styleClass);
        this.textFlow.setStyleClass(styleClass);
    }

    @Override
    public void setBackground(Background background) {
        this.richArea.setBackground(background);
        this.textFlow.setBackground(background);
    }

    @Override
    public void setMouseTransparent(boolean mouseTransparent) {
        this.richArea.setMouseTransparent(mouseTransparent);
        this.textFlow.setMouseTransparent(mouseTransparent);
    }

    @Override
    public void setTextAlignment(TextAlignment alignment) {
        this.richArea.setTextAlignment(alignment);
        this.textFlow.setTextAlignment(alignment);
    }

    @Override
    public boolean isVisible() {
        return this.richArea.isVisible() || this.textFlow.isVisible();
    }

    @Override
    public void clear() {
        if (this.richMode.get()) {
            this.richArea.clear();
        } else {
            this.textFlow.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void replaceText(String text) {
        boolean useRichContent = false;
        RichStyledConfiguration configuration = this.richArea.getConfiguration();
        if (configuration.shouldProcessMarkdown() || configuration.enableLinkDetection()) {
            HasMarkdownVisitor visitor = new HasMarkdownVisitor(configuration);
            Watches.Watch watch = Watches.getInstance().start("FancyTextArea::hasMarkdownVisitor");
            try {
                RichStyledArea.getParser().parse(text).accept((Visitor)visitor);
            }
            finally {
                watch.stop();
            }
            if (visitor.canHaveMarkdown()) {
                useRichContent = true;
            }
        }
        if (useRichContent) {
            this.textFlow.hide();
            this.richArea.replaceText(text);
            this.richArea.show();
            this.richMode.set(true);
        } else {
            this.richArea.hide();
            this.textFlow.replaceText(text);
            this.textFlow.show();
            this.richMode.set(false);
        }
    }

    @Override
    public <T extends Event> void addEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.richArea.addEventFilter(eventType, eventFilter);
        this.textFlow.addEventFilter(eventType, eventFilter);
    }
}

