/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> List<T> asList(List<T> list, T last) {
        return new ListPlusOne<T>(list, last);
    }

    public static <T> List<T> asList(T first, List<T> list) {
        return new OnePlusList<T>(first, list);
    }

    public static <T> List<T> concat(List<T> list1, List<T> list2) {
        return new ConcatList<T>(list1, list2);
    }

    public static <T> boolean equals(List<T> list1, List<T> list2, BiPredicate<T, T> equals) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (equals.test(list1.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean containsAny(Collection<T> collection1, Collection<T> collection2) {
        if (collection1.size() < collection2.size()) {
            for (T t1 : collection1) {
                if (!collection2.contains(t1)) continue;
                return true;
            }
        } else {
            for (T t2 : collection2) {
                if (!collection1.contains(t2)) continue;
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    public static <T extends Comparable<T>> List<T> kWayMerge(List<T> ... lists) {
        PriorityQueue<ListEntry> queue = new PriorityQueue<ListEntry>(lists.length);
        int capacity = 0;
        for (List<T> list : lists) {
            if (list.isEmpty()) continue;
            capacity += list.size();
            Iterator<T> iterator = list.iterator();
            queue.add(new ListEntry<Comparable>((Comparable)iterator.next(), iterator));
        }
        ArrayList result = new ArrayList(capacity);
        while (!queue.isEmpty()) {
            ListEntry entry = (ListEntry)queue.poll();
            result.add(entry.head);
            Iterator tail = entry.tail;
            if (!tail.hasNext()) continue;
            entry.head = (Comparable)tail.next();
            queue.add(entry);
        }
        return result;
    }

    public static <T> int indexOf(List<T> list, Predicate<T> predicate) {
        for (int i = 0; i < list.size(); ++i) {
            if (!predicate.test(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    private static class ListPlusOne<T>
    extends AbstractList<T> {
        final List<T> list;
        final T last;

        ListPlusOne(List<T> list, T last) {
            this.list = list;
            this.last = last;
        }

        @Override
        public int size() {
            return this.list.size() + 1;
        }

        @Override
        public T get(int index) {
            Objects.checkIndex(index, this.size());
            return index == this.size() - 1 ? this.last : this.list.get(index);
        }
    }

    private static class OnePlusList<T>
    extends AbstractList<T> {
        final T first;
        final List<T> list;

        OnePlusList(T first, List<T> list) {
            this.first = first;
            this.list = list;
        }

        @Override
        public int size() {
            return this.list.size() + 1;
        }

        @Override
        public T get(int index) {
            Objects.checkIndex(index, this.size());
            return index == 0 ? this.first : this.list.get(index - 1);
        }
    }

    private static class ConcatList<T>
    extends AbstractList<T> {
        private final List<T> list1;
        private final List<T> list2;

        ConcatList(List<T> list1, List<T> list2) {
            this.list1 = list1;
            this.list2 = list2;
        }

        @Override
        public T get(int index) {
            if (index < this.list1.size()) {
                return this.list1.get(index);
            }
            return this.list2.get(index - this.list1.size());
        }

        @Override
        public int size() {
            return this.list1.size() + this.list2.size();
        }
    }

    private static class ListEntry<T extends Comparable<T>>
    implements Comparable<ListEntry<T>> {
        private T head;
        private Iterator<T> tail;

        public ListEntry(T head, Iterator<T> tail) {
            this.head = head;
            this.tail = tail;
        }

        @Override
        public int compareTo(ListEntry<T> o) {
            return this.head.compareTo(o.head);
        }
    }
}

