/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc;

import io.olvid.windows.messenger.fx.generic_types.list_view.model.ListPanelSelectModel;
import io.olvid.windows.messenger.livedata.Diffable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;

public class BindingUtils {
    public static <Target, Source extends Diffable> void bindMappedListFromSelectModel(ObservableList<Target> targets, ListPanelSelectModel<Source> sources, Function<Source, Target> mapFunction) {
        HashMap sourceTargetMap = new HashMap();
        targets.clear();
        SetChangeListener selectListener = change -> {
            if (change.wasRemoved()) {
                targets.remove(sourceTargetMap.get(change.getElementRemoved()));
                sourceTargetMap.remove(change.getElementRemoved());
            }
            if (change.wasAdded()) {
                Object newTarget = mapFunction.apply((Diffable)change.getElementAdded());
                sourceTargetMap.put((Diffable)change.getElementAdded(), newTarget);
                targets.add(newTarget);
            }
        };
        sources.getSelectedItems().addListener(selectListener);
    }

    public static <T> ObservableList<T> of(ObservableSet<T> set) {
        ObservableList list = FXCollections.observableArrayList(set);
        set.addListener(change -> {
            if (change.wasAdded()) {
                Object added = change.getElementAdded();
                list.add(added);
            } else {
                Object removed = change.getElementRemoved();
                list.remove(removed);
            }
        });
        return FXCollections.unmodifiableObservableList((ObservableList)list);
    }

    public static <T> ListBuilder<T> listBuilder() {
        return new ListBuilder();
    }

    public static final class ListBuilder<T> {
        private final ObservableList<T> list;
        private final List<Observable> observables = new ArrayList<Observable>();

        public ListBuilder() {
            this.list = FXCollections.observableArrayList();
        }

        public ListBuilder<T> add(T t) {
            this.list.add(t);
            return this;
        }

        public ListBuilder<T> add(ObservableValue<T> t) {
            int index = this.list.size();
            t.addListener((odv, o, n) -> this.list.set(index, n));
            this.observables.add((Observable)t);
            this.list.add(t.getValue());
            return this;
        }

        public ObservableList<T> build() {
            return FXCollections.unmodifiableObservableList(this.list);
        }
    }
}

