/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.main_layer.right_panel;

import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.main_layer.right_panel.RightPanelContextState;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ElementDisplayConfirmationNotification;
import io.olvid.windows.messenger.misc.state_pattern.StackContext;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;

public class RightPanelHeaderController
implements Initializable {
    @FXML
    public HBox right_panel_header_content;
    @FXML
    public Button go_back;
    @FXML
    public Button close;
    @FXML
    public Label right_panel_header_label;
    public final LiveDataListener<RightPanelContextState> rightPanelContextStateLiveDataListener = this::rightPanelContextStateListener;
    final StackContext<RightPanelContextState> rightPanelContext;
    private static final String RIGHT_HEADER_PANEL_GROUP_LABEL = "right_header_panel_group_label";
    private static final String RIGHT_HEADER_PANEL_CONTACT_LABEL = "right_header_panel_contact_label";

    public RightPanelHeaderController(StackContext<RightPanelContextState> rightPanelContext) {
        this.rightPanelContext = rightPanelContext;
        this.rightPanelContext.getCurrentStateLiveData().addListener(this.rightPanelContextStateLiveDataListener);
    }

    public void initialize(URL location, ResourceBundle resources) {
        AppLogger.d("CenterPanelHeaderController::initialize()");
        this.close.setOnMouseClicked(this::onCloseRequest);
        this.go_back.setOnMouseClicked(this::onBackRequest);
    }

    private void rightPanelContextStateListener(RightPanelContextState newValue, RightPanelContextState oldValue) {
        if (newValue != null && newValue.equals(oldValue)) {
            return;
        }
        if (newValue == null && oldValue == null) {
            return;
        }
        ViewControllerHelper.smartUIUpdate(() -> {
            if (newValue != null && newValue.getCardType().equals((Object)RightPanelContextState.CardType.GROUP_CARD)) {
                this.right_panel_header_label.setText(ViewControllerHelper.RESOURCE_BUNDLE.getString(RIGHT_HEADER_PANEL_GROUP_LABEL));
            } else if (newValue != null && newValue.getCardType().equals((Object)RightPanelContextState.CardType.CONTACT_CARD)) {
                this.right_panel_header_label.setText(ViewControllerHelper.RESOURCE_BUNDLE.getString(RIGHT_HEADER_PANEL_CONTACT_LABEL));
            }
            if (oldValue == null || this.rightPanelContext.getIsStatesHistoryEmpty().getValue().booleanValue()) {
                ViewControllerHelper.hideNode((Node)this.go_back);
            } else if (newValue != null) {
                ViewControllerHelper.showNode((Node)this.go_back);
            }
        });
    }

    private void onCloseRequest(MouseEvent mouseEvent) {
        AppLogger.d("RightPanelController::onCloseRequest()");
        switch (((RightPanelContextState)this.rightPanelContext.getCurrentState()).getCardType()) {
            case GROUP_CARD: {
                ElementDisplayConfirmationNotification.fireGroupCardDisplayNotification(null);
                break;
            }
            case CONTACT_CARD: {
                ElementDisplayConfirmationNotification.fireContactCardDisplayNotification(null);
            }
        }
        this.rightPanelContext.clearContext();
    }

    private void onBackRequest(MouseEvent mouseEvent) {
        AppLogger.d("RightPanelController::onBackRequest()");
        if (this.rightPanelContext.goToPreviousState()) {
            Object s = this.rightPanelContext.getCurrentState();
            if (s instanceof RightPanelContextState.ContactCard) {
                RightPanelContextState.ContactCard contactCard = (RightPanelContextState.ContactCard)s;
                ElementDisplayConfirmationNotification.fireContactCardDisplayNotification(contactCard.contactId());
            } else {
                s = this.rightPanelContext.getCurrentState();
                if (s instanceof RightPanelContextState.GroupCard) {
                    RightPanelContextState.GroupCard groupCard = (RightPanelContextState.GroupCard)s;
                    ElementDisplayConfirmationNotification.fireGroupCardDisplayNotification(groupCard.group());
                }
            }
        }
    }
}

