/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.main_layer.right_panel;

import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.fx.contacts.contact_details.ContactCardController;
import io.olvid.windows.messenger.fx.contacts.keycloak.KeycloakCardController;
import io.olvid.windows.messenger.fx.contacts.keycloak.KeycloakUserDetailsListItemData;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.groups.group_management.GroupCardController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.main_layer.right_panel.RightPanelContextHolder;
import io.olvid.windows.messenger.fx.main_stack.main_layer.right_panel.RightPanelContextState;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ElementDisplayConfirmationNotification;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.RequestCardDisplayNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import io.olvid.windows.messenger.misc.state_pattern.StackContext;
import java.util.Optional;
import java.util.function.Function;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class RightPanelController {
    public static final Duration DURATION = Duration.millis((double)200.0);
    private Timeline animationSliding;
    public final StackPane container = new StackPane();
    public final Pane wrapper = new Pane(new Node[]{this.container});
    private final DoubleProperty horizontalVisibleProportion = new SimpleDoubleProperty(1.0);
    private final RightPanelContextHolder rightPanelContextHolder;
    final NotificationListener<RequestCardDisplayNotification<Id<Group>>> externalGroupSelectionListener = notification -> this.externalSelectionListener((RequestCardDisplayNotification)notification, RightPanelContextState.GroupCard::new);
    final NotificationListener<RequestCardDisplayNotification<Id<Contact>>> externalContactSelectionListener = notification -> this.externalSelectionListener((RequestCardDisplayNotification)notification, RightPanelContextState.ContactCard::new);
    final NotificationListener<RequestCardDisplayNotification<KeycloakUserDetailsListItemData>> externalKeycloakSelectionListener = notification -> this.externalSelectionListener((RequestCardDisplayNotification)notification, RightPanelContextState.KeycloakCard::new);
    public final StackContext<RightPanelContextState> rightPanelContext = new StackContext();
    public final LiveDataListener<RightPanelContextState> rightPanelContextStateLiveDataListener = this::rightPanelContextStateListener;
    public final LiveDataListener<Optional<OwnedIdentityInfo>> ownedIdentitySelectedLiveDataListener = this::ownedIdentitySelectedLiveDataListener;

    public RightPanelController() {
        AppLogger.d("RightPanelController::RightPanelController()");
        this.rightPanelContext.getCurrentStateLiveData().addListener(this.rightPanelContextStateLiveDataListener);
        SelectedOwnedIdentitySingleton.getInstance().addListener(this.ownedIdentitySelectedLiveDataListener);
        NCRegistry.getUIActionNC().subscribe(UIActionNC.UserInteractionNotificationEnumType.GROUP_SELECTED, this.externalGroupSelectionListener);
        NCRegistry.getUIActionNC().subscribe(UIActionNC.UserInteractionNotificationEnumType.CONTACT_SELECTED, this.externalContactSelectionListener);
        NCRegistry.getUIActionNC().subscribe(UIActionNC.UserInteractionNotificationEnumType.KEYCLOAK_SELECTED, this.externalKeycloakSelectionListener);
        this.rightPanelContextHolder = new RightPanelContextHolder(this.rightPanelContext);
        this.wrapper.prefWidthProperty().bind((ObservableValue)this.container.widthProperty().multiply((ObservableNumberValue)this.horizontalVisibleProportion));
        this.container.prefHeightProperty().bind((ObservableValue)this.wrapper.heightProperty());
        this.initTimeLine();
        this.wrapper.managedProperty().bind((ObservableValue)this.wrapper.visibleProperty());
        this.wrapper.visibleProperty().bind((ObservableValue)Bindings.isNotEmpty((ObservableList)this.container.getChildren()));
        Rectangle outputClip = new Rectangle();
        this.wrapper.setClip((Node)outputClip);
        this.wrapper.layoutBoundsProperty().addListener((ov, oldValue, newValue) -> {
            outputClip.setWidth(newValue.getWidth());
            outputClip.setHeight(newValue.getHeight());
        });
        this.container.minWidthProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)Bindings.isEmpty((ObservableList)this.container.getChildren())).then(0).otherwise(200));
    }

    private void initTimeLine() {
        this.animationSliding = new Timeline();
        this.animationSliding.setCycleCount(1);
        this.animationSliding.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.horizontalVisibleProportion, (Object)0.0)}));
        this.animationSliding.getKeyFrames().add((Object)new KeyFrame(DURATION, new KeyValue[]{new KeyValue((WritableValue)this.horizontalVisibleProportion, (Object)1.0)}));
    }

    private <T> void externalSelectionListener(RequestCardDisplayNotification<T> notification, Function<T, RightPanelContextState> buildState) {
        RightPanelContextState newRightPanelContextState = buildState.apply(notification.getIncomingValue());
        this.rightPanelContext.updateLocalContext(newRightPanelContextState, notification.getHasContextToBeCleared());
    }

    private void ownedIdentitySelectedLiveDataListener(Optional<OwnedIdentityInfo> newValue, Optional<OwnedIdentityInfo> oldValue) {
        if (newValue == null || newValue.isEmpty()) {
            return;
        }
        if (oldValue != null && oldValue.isPresent() && newValue.get().areContentTheSame(oldValue.get())) {
            return;
        }
        this.rightPanelContext.clearContext();
    }

    private void rightPanelContextStateListener(RightPanelContextState newValue, RightPanelContextState oldValue) {
        Node oldCard;
        AnimationType animationType;
        AppLogger.t("RightPanelController::rightPanelContextStateListener()");
        if (newValue != null && newValue.equals(oldValue)) {
            return;
        }
        if (newValue == null && oldValue == null) {
            return;
        }
        if (newValue == null) {
            animationType = AnimationType.CLOSE;
        } else if (oldValue == null) {
            animationType = AnimationType.OPEN;
        } else {
            int indexOfNew = this.rightPanelContext.indexOf(newValue);
            int indexOfOld = this.rightPanelContext.indexOf(oldValue);
            if (indexOfOld != 1 && indexOfNew != 1) {
                animationType = indexOfNew > indexOfOld ? AnimationType.PUSH : AnimationType.POP;
            } else {
                AppLogger.w(String.format("Cannot find animation from %s to %s", oldValue, newValue));
                return;
            }
        }
        if (!this.container.getChildren().isEmpty()) {
            oldCard = (Node)this.container.getChildren().get(0);
        } else {
            if (animationType != AnimationType.OPEN) {
                AppLogger.w("No OldCard for animation type : " + String.valueOf((Object)animationType));
            }
            oldCard = null;
        }
        ViewControllerHelper.smartUIUpdate(() -> {
            RightPanelContextState state;
            Region futureCard = null;
            if (newValue != null) {
                RightPanelContextState.KeycloakCard keycloakCard;
                RightPanelContextState.GroupCard groupCard;
                RightPanelContextState.ContactCard contactCard;
                BaseViewController baseViewController = null;
                if (newValue instanceof RightPanelContextState.ContactCard && (contactCard = (RightPanelContextState.ContactCard)newValue).contactId() != null) {
                    baseViewController = new ContactCardController(contactCard.contactId(), this.rightPanelContextHolder);
                } else if (newValue instanceof RightPanelContextState.GroupCard && (groupCard = (RightPanelContextState.GroupCard)newValue).group() != null) {
                    baseViewController = new GroupCardController(groupCard.group(), this.rightPanelContextHolder);
                } else if (newValue instanceof RightPanelContextState.KeycloakCard && (keycloakCard = (RightPanelContextState.KeycloakCard)newValue).data() != null) {
                    baseViewController = new KeycloakCardController(keycloakCard.data(), this.rightPanelContextHolder);
                } else {
                    AppLogger.e(String.format("Should handle the case %s on the right panel controller", newValue));
                    return;
                }
                futureCard = ((BaseViewController)baseViewController).getLayout();
            }
            switch (animationType.ordinal()) {
                case 1: {
                    if (futureCard == null) break;
                    Region finalFutureCard = futureCard;
                    Runnable open = () -> {
                        AppLogger.i("OPENING");
                        this.container.getChildren().add((Object)finalFutureCard);
                        this.animationSliding.setRate(1.0);
                        this.animationSliding.setOnFinished(null);
                        this.animationSliding.play();
                    };
                    if (this.animationSliding.getStatus() == Animation.Status.RUNNING) {
                        this.animationSliding.setOnFinished(event -> {
                            this.container.getChildren().clear();
                            open.run();
                        });
                        break;
                    }
                    open.run();
                    break;
                }
                case 0: {
                    if (oldCard == null) break;
                    AppLogger.w("CLOSING");
                    this.animationSliding.setRate(-1.0);
                    this.animationSliding.setOnFinished(event -> {
                        AppLogger.i("CLOSED");
                        this.container.getChildren().clear();
                    });
                    this.animationSliding.play();
                    ElementDisplayConfirmationNotification.fireContactCardDisplayNotification(null);
                    ElementDisplayConfirmationNotification.fireGroupCardDisplayNotification(null);
                    return;
                }
                case 3: {
                    if (oldCard == null || futureCard == null) break;
                    double range = this.container.getWidth();
                    futureCard.setVisible(false);
                    this.container.getChildren().add(futureCard);
                    futureCard.setTranslateX(range);
                    futureCard.setVisible(true);
                    KeyFrame kf = new KeyFrame(DURATION, new KeyValue[]{new KeyValue((WritableValue)futureCard.translateXProperty(), (Object)0)});
                    Timeline newCardApparition = new Timeline(new KeyFrame[]{kf});
                    KeyFrame kf0 = new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)oldCard.translateXProperty(), (Object)0)});
                    KeyFrame kf1 = new KeyFrame(DURATION, new KeyValue[]{new KeyValue((WritableValue)oldCard.translateXProperty(), (Object)(-range))});
                    Timeline oldCardDisparition = new Timeline(new KeyFrame[]{kf0, kf1});
                    ParallelTransition transition = new ParallelTransition(new Animation[]{newCardApparition, oldCardDisparition});
                    transition.setOnFinished(event -> this.container.getChildren().remove((Object)oldCard));
                    transition.play();
                    break;
                }
                case 2: {
                    if (oldCard == null || futureCard == null) break;
                    double range = this.container.getWidth();
                    this.container.getChildren().add(0, futureCard);
                    KeyFrame kf = new KeyFrame(DURATION, new KeyValue[]{new KeyValue((WritableValue)oldCard.translateXProperty(), (Object)range)});
                    Timeline oldCardDisparition = new Timeline(new KeyFrame[]{kf});
                    KeyFrame kf0 = new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)futureCard.translateXProperty(), (Object)(-range))});
                    KeyFrame kf1 = new KeyFrame(DURATION, new KeyValue[]{new KeyValue((WritableValue)futureCard.translateXProperty(), (Object)0)});
                    Timeline newCardApparition = new Timeline(new KeyFrame[]{kf0, kf1});
                    ParallelTransition transition = new ParallelTransition(new Animation[]{oldCardDisparition, newCardApparition});
                    transition.setOnFinished(event -> this.container.getChildren().remove((Object)oldCard));
                    transition.play();
                }
            }
            RightPanelContextState rightPanelContextState = state = newValue == null ? oldValue : newValue;
            if (state instanceof RightPanelContextState.ContactCard) {
                RightPanelContextState.ContactCard contactCard = (RightPanelContextState.ContactCard)state;
                ElementDisplayConfirmationNotification.fireContactCardDisplayNotification(contactCard.contactId());
                ElementDisplayConfirmationNotification.fireGroupCardDisplayNotification(null);
            } else if (state instanceof RightPanelContextState.GroupCard) {
                RightPanelContextState.GroupCard groupCard = (RightPanelContextState.GroupCard)state;
                ElementDisplayConfirmationNotification.fireGroupCardDisplayNotification(groupCard.group());
                ElementDisplayConfirmationNotification.fireContactCardDisplayNotification(null);
            }
        });
    }

    private static enum AnimationType {
        CLOSE,
        OPEN,
        POP,
        PUSH;

    }
}

