/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.main_layer.right_panel;

import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.main_layer.right_panel.RightPanelContextState;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ElementDisplayConfirmationNotification;
import io.olvid.windows.messenger.misc.state_pattern.StackContext;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;

public class RightPanelContextHolder {
    final StackContext<RightPanelContextState> rightPanelContext;
    private final BooleanProperty previousStateExists = new SimpleBooleanProperty(false);
    private final LiveDataListener<Boolean> booleanLiveDataListener = (newValue, oldValue) -> {
        if (newValue != null) {
            ViewControllerHelper.smartUIUpdate(() -> this.previousStateExists.set(newValue == false));
        }
    };

    public RightPanelContextHolder(StackContext<RightPanelContextState> rightPanelContext) {
        this.rightPanelContext = rightPanelContext;
        rightPanelContext.getIsStatesHistoryEmpty().addListener(this.booleanLiveDataListener);
    }

    public void close() {
        AppLogger.d("RightPanelController::onCloseRequest()");
        this.rightPanelContext.clearContext();
    }

    public boolean goToPrevious() {
        AppLogger.d("RightPanelController::onBackRequest()");
        if (this.rightPanelContext.goToPreviousState()) {
            Object s = this.rightPanelContext.getCurrentState();
            if (s instanceof RightPanelContextState.ContactCard) {
                RightPanelContextState.ContactCard contactCard = (RightPanelContextState.ContactCard)s;
                ElementDisplayConfirmationNotification.fireContactCardDisplayNotification(contactCard.contactId());
            } else {
                s = this.rightPanelContext.getCurrentState();
                if (s instanceof RightPanelContextState.GroupCard) {
                    RightPanelContextState.GroupCard groupCard = (RightPanelContextState.GroupCard)s;
                    ElementDisplayConfirmationNotification.fireGroupCardDisplayNotification(groupCard.group());
                }
            }
            return true;
        }
        return false;
    }

    public StackContext<RightPanelContextState> getRightPanelContext() {
        return this.rightPanelContext;
    }
}

