/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.main_layer.left_panel.tabs_management;

import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.main_stack.main_layer.left_panel.tabs_management.NavBarTab;
import io.olvid.windows.messenger.fx.main_stack.main_layer.left_panel.tabs_management.StandardTab;
import io.olvid.windows.messenger.misc.Either;
import java.util.Optional;
import javafx.beans.binding.StringExpression;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;

public abstract class BaseNavBarTab
extends BaseViewController
implements NavBarTab {
    protected StandardTab tabContainer;

    protected void buildStandardTab(Either<String, StringExpression> tabTitle, Optional<StringExpression> titleRetreat, Optional<String> svgFloatingButtonStyleClass, Optional<EventHandler<ActionEvent>> floatingButtonActionHandler, Optional<String> customMoreButtonSvg, Optional<EventHandler<ActionEvent>> moreButtonHandler, Optional<Button> backButton, Node ... children) {
        this.tabContainer = new StandardTab();
        if (tabTitle.isLeft()) {
            this.tabContainer.setTitle(tabTitle.getLeft());
        } else {
            this.tabContainer.titleProperty().bind((ObservableValue)tabTitle.getRight());
        }
        if (titleRetreat.isPresent()) {
            this.tabContainer.titleRetreatProperty().bind((ObservableValue)titleRetreat.get());
        } else {
            this.tabContainer.setTitleRetreat("");
        }
        if (svgFloatingButtonStyleClass.isPresent() && floatingButtonActionHandler.isPresent()) {
            this.tabContainer.setRoundButtonIcon(svgFloatingButtonStyleClass.get());
            this.tabContainer.setRoundHandler(floatingButtonActionHandler.get());
        } else {
            this.tabContainer.disableFloatingButton();
        }
        if (customMoreButtonSvg.isPresent()) {
            this.tabContainer.setParameterIcon(customMoreButtonSvg.get());
        } else {
            this.tabContainer.setParameterIcon("svg-menu");
        }
        if (moreButtonHandler.isPresent()) {
            this.tabContainer.setParameterHandler(moreButtonHandler.get());
        } else {
            this.tabContainer.hideParameterButton();
        }
        backButton.ifPresent(button -> this.tabContainer.title_hbox.getChildren().add(0, button));
        this.tabContainer.setChildren(children);
    }

    protected Button createButton(String styleClass) {
        Button button = new Button();
        button.getStyleClass().addAll((Object[])new String[]{"nav-button"});
        SvgSizeable icon = new SvgSizeable();
        icon.getStyleClass().add((Object)styleClass);
        button.setGraphic((Node)icon);
        return button;
    }

    @Override
    public void onLayoutDetached() {
    }
}

