/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync;

import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.custom_components.loader.RingProgressIndicator;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.DisplayTextModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlowModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync.RestrictedTransferAuthenticationRequiredModel;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.TcpMessageNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.TcpServerNC;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;

public class RestrictedTransferAuthenticationRequiredController
extends BaseViewController {
    public static final DisplayTextModel AUTHENTICATION_REQUIRED_DISPLAY_TEXT_MODEL = DisplayTextModel.ofOnlyIds("onboarding_authentication_required_title", null, "onboarding_transfer_keycloak_authentication_required", null, null);
    private final AppLogger logger = new AppLogger(this.getClass());
    private final VBox root = new VBox();
    protected final HBox buttonSpinnerContainer = new HBox();
    protected final RingProgressIndicator ringProgressIndicator = new RingProgressIndicator();
    protected final StackPane ringContainer = new StackPane();
    private final StackPane validateButtonSpinner = new StackPane();
    protected final Button validateButton;
    public final TextField input = new TextField();
    public final Button nextButton = new Button();
    public final Hyperlink enableManualRedirectHyperlink = new Hyperlink(ViewControllerHelper.getString("on_boarding_flow_keycloak_authentication_in_paste_redirect_url_label"));
    private final Label errorLabel = new Label();
    final RestrictedTransferAuthenticationRequiredModel localModel;

    public RestrictedTransferAuthenticationRequiredController(IdentityManagementFlowModel identityManagementFlowModel) {
        this.localModel = new RestrictedTransferAuthenticationRequiredModel(identityManagementFlowModel);
        this.root.setAlignment(Pos.CENTER);
        this.root.setSpacing(12.0);
        this.root.getStyleClass().addAll((Object[])new String[]{"modal-contextual-background"});
        this.errorLabel.getStyleClass().setAll((Object[])new String[]{"error-text", "body-1-size"});
        this.errorLabel.setTextAlignment(TextAlignment.JUSTIFY);
        this.errorLabel.setAlignment(Pos.CENTER);
        this.errorLabel.setWrapText(true);
        this.input.getStyleClass().addAll((Object[])new String[]{"body-2"});
        this.input.setPromptText(ViewControllerHelper.getString("on_boarding_flow_keycloak_authentication_link_example"));
        this.input.textProperty().bindBidirectional((Property)this.localModel.redirectInput);
        SvgSizeable buttonIcon = new SvgSizeable();
        buttonIcon.getStyleClass().addAll((Object[])new String[]{"icon-medium", "svg-chevron", "icon-white"});
        this.nextButton.setGraphic((Node)buttonIcon);
        this.nextButton.getStyleClass().add((Object)"primary-button");
        this.nextButton.setAlignment(Pos.CENTER_RIGHT);
        this.nextButton.disableProperty().bind((ObservableValue)this.input.textProperty().isEmpty());
        this.nextButton.setOnMouseClicked(event -> {
            TcpMessageNotification tcpMessageNotification = new TcpMessageNotification(TcpServerNC.TcpMessageNotificationEnumType.KEYCLOAK_AUTHENTICATION_REDIRECT_URI.messageId, this.input.getText().trim());
            NCRegistry.getTCPServerNC().postNotification(tcpMessageNotification);
        });
        HBox inputAndButton = new HBox(new Node[]{this.input, this.nextButton});
        inputAndButton.setSpacing(12.0);
        HBox.setHgrow((Node)this.input, (Priority)Priority.ALWAYS);
        inputAndButton.visibleProperty().bind((ObservableValue)this.localModel.showManualRedirectInput);
        this.enableManualRedirectHyperlink.setOnAction(event -> this.localModel.showManualRedirectInput.set(true));
        this.enableManualRedirectHyperlink.getStyleClass().addAll((Object[])new String[]{"body-1-size"});
        this.enableManualRedirectHyperlink.setTextAlignment(TextAlignment.CENTER);
        this.enableManualRedirectHyperlink.visibleProperty().bind((ObservableValue)this.localModel.showManualRedirectInput.not());
        StackPane explanationOrInput = new StackPane(new Node[]{inputAndButton, this.enableManualRedirectHyperlink});
        explanationOrInput.setAlignment(Pos.CENTER);
        explanationOrInput.visibleProperty().bind((ObservableValue)this.localModel.loading.and((ObservableBooleanValue)this.localModel.failed.not()));
        HBox.setHgrow((Node)explanationOrInput, (Priority)Priority.ALWAYS);
        SvgSizeable svgSizeable = new SvgSizeable();
        svgSizeable.getStyleClass().addAll((Object[])new String[]{"icon-white", "icon-large", "svg-arrow-right"});
        this.validateButton = new Button();
        this.validateButton.getStyleClass().add((Object)"primary-button");
        this.validateButton.setGraphic((Node)svgSizeable);
        this.validateButton.setOnAction(this::validateCode);
        this.ringProgressIndicator.getStyleClass().setAll((Object[])new String[]{"sync-progress-indicator", "indeterminate"});
        this.ringProgressIndicator.setProgress(-1);
        this.ringProgressIndicator.setInnerCircleRadius(8);
        this.ringProgressIndicator.setRingWidth(2);
        this.ringContainer.getChildren().add((Object)this.ringProgressIndicator);
        this.validateButtonSpinner.getChildren().addAll((Object[])new Node[]{this.validateButton, this.ringContainer});
        this.validateButtonSpinner.setAlignment(Pos.CENTER_RIGHT);
        this.buttonSpinnerContainer.setAlignment(Pos.CENTER_RIGHT);
        this.buttonSpinnerContainer.setSpacing(8.0);
        Region sep = new Region();
        this.buttonSpinnerContainer.getChildren().addAll((Object[])new Node[]{sep, this.validateButtonSpinner});
        this.buttonSpinnerContainer.setPadding(new Insets(12.0, 12.0, 12.0, 12.0));
        HBox.setHgrow((Node)sep, (Priority)Priority.ALWAYS);
        this.root.getChildren().addAll((Object[])new Node[]{explanationOrInput, this.errorLabel, this.buttonSpinnerContainer});
        this.errorLabel.textProperty().bind((ObservableValue)this.localModel.identityManagementFlowModel.identitySyncModel.errorDescription);
        this.errorLabel.visibleProperty().bind((ObservableValue)this.localModel.failed);
        this.validateButton.visibleProperty().bind((ObservableValue)this.localModel.loading.not());
        this.ringContainer.visibleProperty().bind((ObservableValue)this.localModel.loading);
        this.errorLabel.textProperty().bind((ObservableValue)this.localModel.errorLabel);
    }

    protected void validateCode(ActionEvent event) {
        this.localModel.startProtocol();
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }

    @Override
    public Region getLayout() {
        return this.root;
    }
}

