/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync;

import io.olvid.engine.encoder.Encoded;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.api.TransferApi;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.MainStackManager;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlow;
import io.olvid.windows.messenger.fx.owned_identities.DeviceInfo;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.BytesKey;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UtilityNC;
import io.olvid.windows.messenger.misc.state_pattern.FlowStackContext;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class IdentitySyncModel {
    final AppLogger logger = new AppLogger(IdentitySyncModel.class);
    final BooleanProperty validationInProgress = new SimpleBooleanProperty();
    final BooleanProperty validationError = new SimpleBooleanProperty();
    final StringProperty sessionNumber = new SimpleStringProperty(null);
    final StringProperty sas = new SimpleStringProperty(null);
    final StringProperty correctSas = new SimpleStringProperty(null);
    final StringProperty deviceName = new SimpleStringProperty(null);
    public final StringProperty keycloakServerUrl = new SimpleStringProperty(null);
    public final StringProperty keycloakClientId = new SimpleStringProperty(null);
    public final StringProperty keycloakClientSecret = new SimpleStringProperty(null);
    final StringProperty targetDeviceName = new SimpleStringProperty(null);
    final StringProperty errorDescription = new SimpleStringProperty(null);
    final ObjectProperty<TransferApi.Step> step = new SimpleObjectProperty(null);
    final ObjectProperty<UUID> dialogUUID = new SimpleObjectProperty(null);
    final ObjectProperty<byte[]> bytesOwnedIdentity = new SimpleObjectProperty(null);
    final ObjectProperty<Encoded> encodedElements = new SimpleObjectProperty(null);
    final BooleanProperty multiDevice = new SimpleBooleanProperty();
    final ObjectProperty<DeviceInfo> deviceToKeepActive = new SimpleObjectProperty(null);
    final BooleanProperty transferRestricted = new SimpleBooleanProperty(false);
    final NotificationListener<UtilityNC.TransferNotification> transfertNotificationListener = this::transfertNotificationListener;
    final FlowStackContext<IdentityManagementFlow> context;

    public IdentitySyncModel(FlowStackContext<IdentityManagementFlow> context) {
        NCRegistry.getUtilityNC().subscribe(UtilityNC.UtilityNotificationEnumType.IDENTITY_TRANSFERT_STEP, this.transfertNotificationListener);
        this.context = context;
    }

    private void transfertNotificationListener(UtilityNC.TransferNotification transfertNotification) {
        Objects.requireNonNull(transfertNotification.step());
        Objects.requireNonNull(transfertNotification.uuid());
        Objects.requireNonNull(transfertNotification.bytesOwnedIdentity());
        Objects.requireNonNull(transfertNotification.encodedElements());
        TransferApi.Step step = transfertNotification.step();
        this.step.set((Object)step);
        this.dialogUUID.set((Object)transfertNotification.uuid());
        this.bytesOwnedIdentity.set((Object)transfertNotification.bytesOwnedIdentity());
        this.encodedElements.set((Object)transfertNotification.encodedElements());
        switch (step.getKind()) {
            case FAIL: {
                ViewControllerHelper.smartUIUpdate(() -> {
                    switch (((TransferApi.Fail)step).e()) {
                        case NETWORK_ERROR: {
                            this.errorDescription.set((Object)ViewControllerHelper.getString("onboarding_transfer_network_error_code_label"));
                            break;
                        }
                        case TRANSFERRED_IDENTITY_ALREADY_EXISTS: {
                            this.errorDescription.set((Object)ViewControllerHelper.getString("onboarding_transfer_known_profile_error_code_label"));
                            break;
                        }
                        case INVALID_RESPONSE: {
                            this.errorDescription.set((Object)ViewControllerHelper.getString("onboarding_transfer_invalid_response_error_code_label"));
                        }
                    }
                    this.validationError.set(true);
                    this.validationInProgress.set(false);
                });
                break;
            }
            case SOURCE_WAIT_FOR_SESSION_NUMBER: {
                if (KeycloakManager.getInstance().isOwnedIdentityTransferRestricted(BytesKey.of((byte[])this.bytesOwnedIdentity.get()))) {
                    this.context.pushState(IdentityManagementFlow.SYNC_SOURCE, IdentityManagementFlow.SyncSourceState.SHOW_TRANSFER_RESTRICTED_DISCLAIMER);
                    break;
                }
                this.context.pushState(IdentityManagementFlow.SYNC_SOURCE, IdentityManagementFlow.SyncSourceState.SHOW_CODE);
                break;
            }
            case SOURCE_DISPLAY_SESSION_NUMBER: {
                TransferApi.SourceDisplaySessionNumber sourceDisplaySessionNumber = (TransferApi.SourceDisplaySessionNumber)step;
                this.validationInProgress.set(false);
                this.sessionNumber.set((Object)sourceDisplaySessionNumber.value());
                this.transferRestricted.set(KeycloakManager.getInstance().isOwnedIdentityTransferRestricted(BytesKey.of((byte[])this.bytesOwnedIdentity.get())));
                break;
            }
            case ONGOING_PROTOCOL: {
                this.validationInProgress.set(true);
                break;
            }
            case SOURCE_SAS_INPUT: {
                TransferApi.SourceSasInput sourceSasInput = (TransferApi.SourceSasInput)step;
                this.validationInProgress.set(false);
                this.targetDeviceName.set((Object)sourceSasInput.targetDeviceName());
                this.correctSas.set((Object)sourceSasInput.correctSas());
                this.context.pushState(IdentityManagementFlow.SYNC_SOURCE, IdentityManagementFlow.SyncSourceState.ENTER_CODE);
                break;
            }
            case TARGET_SESSION_NUMBER_INPUT: {
                if (this.context.getCurrentState() == null) break;
                if (this.context.getCurrentState().equals(IdentityManagementFlow.SyncTargetState.ENTER_CODE)) {
                    ViewControllerHelper.smartUIUpdate(() -> this.errorDescription.set((Object)ViewControllerHelper.getString("onboarding_transfer_incorrect_code_or_network_error_code_label")));
                    this.validationError.set(true);
                    break;
                }
                this.validationError.set(false);
                this.context.pushState(IdentityManagementFlow.SYNC_TARGET, IdentityManagementFlow.SyncTargetState.ENTER_CODE);
                break;
            }
            case SOURCE_SNAPSHOT_SENT: {
                this.context.clearContext();
                this.context.pushState(IdentityManagementFlow.IDENTITY_CREATION, IdentityManagementFlow.IdentityCreationState.ON_BOARDING);
                MainStackManager.displayedLayerState.pushState(MainStackManager.DisplayedLayerWrapper.of(MainStackManager.DisplayedLayer.MAIN));
                this.reset();
                break;
            }
            case TARGET_SHOW_SAS: {
                TransferApi.TargetShowSas targetShowSas = (TransferApi.TargetShowSas)step;
                this.validationInProgress.set(false);
                ViewControllerHelper.smartUIUpdate(() -> this.errorDescription.set(null));
                this.sas.set((Object)targetShowSas.sas());
                this.context.pushState(IdentityManagementFlow.SYNC_TARGET, IdentityManagementFlow.SyncTargetState.SHOW_CODE);
                break;
            }
            case TARGET_SNAPSHOT_RECEIVED: {
                this.validationInProgress.set(false);
                this.context.pushState(IdentityManagementFlow.SYNC_TARGET, IdentityManagementFlow.SyncTargetState.SUCCESS);
                break;
            }
            case TARGET_REQUESTS_KEYCLOAK_AUTHENTICATION_PROOF: {
                AppLogger.d(TransferApi.Kind.TARGET_REQUESTS_KEYCLOAK_AUTHENTICATION_PROOF.name());
                TransferApi.TargetRequestKeycloakAuthenticationProof targetRequestKeycloakAuthenticationProof = (TransferApi.TargetRequestKeycloakAuthenticationProof)step;
                this.sas.set((Object)targetRequestKeycloakAuthenticationProof.fullSas());
                this.sessionNumber.set((Object)String.valueOf(targetRequestKeycloakAuthenticationProof.sessionNumber()));
                this.keycloakServerUrl.set((Object)targetRequestKeycloakAuthenticationProof.keycloakServerUrl());
                this.keycloakClientId.set((Object)targetRequestKeycloakAuthenticationProof.clientId());
                this.keycloakClientSecret.set((Object)targetRequestKeycloakAuthenticationProof.clientSecret());
                this.transferRestricted.set(true);
                this.context.pushState(IdentityManagementFlow.SYNC_TARGET, IdentityManagementFlow.SyncTargetState.AUTHENTICATION_REQUIRED);
            }
        }
    }

    public Optional<OwnedIdentityInfo> getOwnedIdentityInfo() {
        List<OwnedIdentityInfo> ownedIdentityListLD = DbCache.getInstance().ownedIdentitiesInfo.getValue();
        if (!ownedIdentityListLD.isEmpty() && this.bytesOwnedIdentity.get() != null) {
            return ownedIdentityListLD.stream().filter(ownedIdentityInfo -> Arrays.equals(ownedIdentityInfo.bytesOwnedIdentity(), (byte[])this.bytesOwnedIdentity.get())).findFirst();
        }
        return Optional.empty();
    }

    public void reset() {
        if (this.step.get() == null) {
            return;
        }
        KeycloakManager.getInstance().stopTransferAuthenticationProtocol();
        this.validationError.set(false);
        Objects.requireNonNull((UUID)this.dialogUUID.get());
        Objects.requireNonNull((byte[])this.bytesOwnedIdentity.get());
        Objects.requireNonNull((Encoded)this.encodedElements.get());
        Api.getTransferApi().abortTransfer((TransferApi.Step)this.step.get(), (UUID)this.dialogUUID.get(), (byte[])this.bytesOwnedIdentity.get(), (Encoded)this.encodedElements.get());
        this.sessionNumber.unbind();
        this.sas.unbind();
        this.sas.set(null);
        this.sessionNumber.set(null);
        this.correctSas.set(null);
        this.targetDeviceName.set(null);
        this.deviceName.set(null);
        this.errorDescription.set(null);
    }
}

