/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync;

import io.olvid.engine.encoder.Encoded;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.api.TransferApi;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.DisplayTextModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync.IdentitySyncModel;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Objects;
import java.util.UUID;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

@FXMLView(path="fx/main_stack/identity_management_layer/sync/enter_code.fxml")
public class EnterSessionNumberController
extends BaseModalController {
    private final AppLogger logger = new AppLogger(this.getClass());
    public static final DisplayTextModel RECIPIENT_DISPLAY_TEXT_MODEL = DisplayTextModel.ofOnlyIds("on_boarding_flow_sync_target_enter_code_title", null, "on_boarding_flow_sync_target_enter_code_subText", null, null);
    @FXML
    private VBox enter_code_vbox;
    @FXML
    protected TextField code;
    @FXML
    private Button enter_code_button;
    @FXML
    private Label error_label;
    protected final IdentitySyncModel model;

    public EnterSessionNumberController(IdentitySyncModel identitySyncModel) {
        this.model = identitySyncModel;
        this.loadFxml();
        this.enter_code_button.setOnAction(this::validateCode);
        BooleanBinding disableProperty = Bindings.createBooleanBinding(() -> this.stringToConsider().get() == null || ((String)this.stringToConsider().get()).length() != 8 || !((String)this.stringToConsider().get()).matches("[0-9]*"), (Observable[])new Observable[]{this.stringToConsider()});
        this.enter_code_button.disableProperty().bind((ObservableValue)disableProperty);
        this.error_label.textProperty().bind((ObservableValue)this.model.errorDescription);
        this.error_label.visibleProperty().bind((ObservableValue)this.model.validationError);
    }

    protected StringProperty stringToConsider() {
        return this.model.sessionNumber;
    }

    protected void validateCode(ActionEvent event) {
        this.model.validationInProgress.set(true);
        Objects.requireNonNull((TransferApi.Step)this.model.step.get());
        Objects.requireNonNull((UUID)this.model.dialogUUID.get());
        Objects.requireNonNull((byte[])this.model.bytesOwnedIdentity.get());
        Objects.requireNonNull((Encoded)this.model.encodedElements.get());
        boolean engineCallSuccess = Api.getTransferApi().setTransferSessionNumber(Long.parseLong((String)this.model.sessionNumber.get()), (TransferApi.Step)this.model.step.get(), (UUID)this.model.dialogUUID.get(), (byte[])this.model.bytesOwnedIdentity.get(), (Encoded)this.model.encodedElements.get());
        if (!engineCallSuccess) {
            this.logger.error("Unable to setTransferSessionNumber");
        }
    }

    @Override
    public void onLayoutAttached() {
        this.model.sessionNumber.bind((ObservableValue)this.code.textProperty());
    }

    @Override
    public void onLayoutDetached() {
        this.code.textProperty().set(null);
        this.model.sessionNumber.unbind();
    }

    @Override
    public Region getLayout() {
        return this.enter_code_vbox;
    }
}

