/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync;

import io.olvid.engine.encoder.Encoded;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.api.TransferApi;
import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.custom_components.bubbles.IdentityBubble;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.DisplayTextModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync.IdentitySyncModel;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.owned_identities.DeviceInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

@FXMLView(path="fx/main_stack/identity_management_layer/sync/confirm_profile_activation.fxml")
public class ConfirmProfileActivationController
extends BaseModalController {
    private final AppLogger logger = new AppLogger(this.getClass());
    public static final DisplayTextModel DISPLAY_TEXT_MODEL = DisplayTextModel.ofOnlyIds("confirm_profile_activation", null, null, null, null);
    @FXML
    private VBox confirm_profile_vbox;
    @FXML
    private Button confirm_profile_activation_button;
    @FXML
    private IdentityBubble owned_bubble;
    @FXML
    private Label profile_name;
    @FXML
    private Label device_name;
    @FXML
    private Label device_description;
    @FXML
    private Label restricted_label;
    final IdentitySyncModel model;
    private final BooleanProperty confirmActionDisable = new SimpleBooleanProperty(false);

    public ConfirmProfileActivationController(IdentitySyncModel model) {
        this.model = model;
        this.loadFxml();
        this.confirm_profile_activation_button.setOnAction(this::confirmAction);
        this.confirm_profile_activation_button.disableProperty().bind((ObservableValue)this.confirmActionDisable);
    }

    @Override
    public Region getLayout() {
        return this.confirm_profile_vbox;
    }

    @Override
    public void onLayoutAttached() {
        super.onLayoutAttached();
        Optional<OwnedIdentityInfo> ownedIdentityInfo = this.model.getOwnedIdentityInfo();
        if (ownedIdentityInfo.isPresent()) {
            this.profile_name.setText(ownedIdentityInfo.get().getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST_POSITION_COMPANY));
            BubbleUtils.setBubbleData(ownedIdentityInfo.get(), this.owned_bubble);
        } else {
            AppLogger.e("Cannot get selected owned identity");
        }
        this.device_name.setText((String)this.model.targetDeviceName.get());
        this.device_description.setText(ViewControllerHelper.getString("text_new_device"));
        MessageFormat messageFormat = new MessageFormat(ViewControllerHelper.getString("onboarding_transfer_source_button_label_activate_profile_on_xxx"));
        String message = messageFormat.format(new String[]{(String)this.model.targetDeviceName.get()});
        this.confirm_profile_activation_button.setText(message);
        this.restricted_label.visibleProperty().bind((ObservableValue)this.model.transferRestricted);
        this.restricted_label.managedProperty().bind((ObservableValue)this.restricted_label.visibleProperty());
        this.confirmActionDisable.set(false);
    }

    private void confirmAction(ActionEvent actionEvent) {
        this.confirmActionDisable.set(true);
        DeviceInfo deviceInfo = (DeviceInfo)this.model.deviceToKeepActive.get();
        Optional<Object> deviceUidToKeepActive = deviceInfo != null ? deviceInfo.uid() : Optional.empty();
        Objects.requireNonNull((TransferApi.Step)this.model.step.get());
        Objects.requireNonNull((String)this.model.sas.get());
        Objects.requireNonNull((UUID)this.model.dialogUUID.get());
        Objects.requireNonNull((byte[])this.model.bytesOwnedIdentity.get());
        Objects.requireNonNull((Encoded)this.model.encodedElements.get());
        boolean success = Api.getTransferApi().setTransferSasAndDeviceUid((String)this.model.sas.get(), deviceUidToKeepActive, (TransferApi.Step)this.model.step.get(), (UUID)this.model.dialogUUID.get(), (byte[])this.model.bytesOwnedIdentity.get(), (Encoded)this.model.encodedElements.get());
        if (!success) {
            this.logger.error("Unable to setTransferSasAndDeviceUid");
        }
    }
}

